/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.BAuthenticationService;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.jetty.BJettyWebServer;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.testng.TestAuthenticationClient;
import com.tridium.ui.NullUiEnv;
import com.tridium.ui.UiEnv;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.baja.alarm.BAlarmService;
import javax.baja.app.BAppContainer;
import javax.baja.category.BCategoryService;
import javax.baja.driver.BDriverContainer;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sync.BProxyComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTest;
import javax.baja.test.BTestNg;
import javax.baja.test.TestException;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.web.BWebService;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;

@NiagaraType
@NiagaraSlots
public abstract class BStationTestBase
extends BTestNg {
    public static final Type TYPE = Sys.loadType(BStationTestBase.class);
    public static final String TEST_SUPER_USER = "TestSuper";
    public static final String TEST_ADMIN_USER = "TestAdmin";
    public static final String TEST_OPERATOR_USER = "TestOperator";
    public static final String TEST_VISITOR_USER = "TestVisitor";
    public static final String TEST_PASSWORD = "Test@1234_5678";
    public static final String TEST_DELIMITED_USER = "username";
    public static final String TEST_DELIMITED_PASS = "user:password";
    public static final int NUMBER_OF_USERS = 5;
    protected static final String testStationName = "test";
    protected static final String USER_SERVICE = "UserService";
    protected static final String ROLE_SERVICE = "RoleService";
    protected static final String AUTH_SERVICE = "AuthenticationService";
    protected static final String CATEGORY_SERVICE = "CategoryService";
    protected static final String ALARM_SERVICE = "AlarmService";
    protected static final String WEB_SERVICE = "WebService";
    protected static final String DRIVERS = "Drivers";
    protected static final String NIAGARA_NETWORK = "NiagaraNetwork";
    protected static final int MAX_FOX_CONNECTION_ATTEMPTS = 3;
    protected static final long DEFAULT_FOX_CONNECTION_REATTEMPT_DELAY = 1000L;
    protected BTest.TestStationHandler stationHandler;
    protected int foxPort = 1911;
    protected int webPort = 9090;

    @Override
    public Type getType() {
        return TYPE;
    }

    @BeforeTest(alwaysRun=true, description="Setup and start test station")
    public void setupStation() throws Exception {
        if (this.stationHandler == null) {
            System.out.println("creating test station for " + ((Object)((Object)this)).getClass());
            this.makeStationHandler();
            System.out.println("done creating station for " + ((Object)((Object)this)).getClass());
        }
        BStation station = this.stationHandler.getStation();
        try {
            this.configureTestStation(station, testStationName, this.webPort, this.foxPort);
        }
        catch (Exception e) {
            this.stationHandler.stopStation();
            this.stationHandler.releaseStation();
            this.stationHandler = null;
            System.out.println("unable to set up station for " + ((Object)((Object)this)).getClass());
            throw new Exception("unable to set up station for " + ((Object)((Object)this)).getClass(), e);
        }
        this.startStation(station);
        Thread.sleep(500L);
        Station.atSteadyState = true;
        Nre.getEngineManager().atSteadyState((BComponent)station);
    }

    protected void makeStationHandler() throws Exception {
        this.stationHandler = BStationTestBase.createTestStation();
    }

    @AfterTest(alwaysRun=true, description="Teardown test station")
    public void teardownStation() throws Exception {
        if (this.stationHandler != null) {
            this.stationHandler.stopStation();
            this.stationHandler.releaseStation();
            this.stationHandler = null;
        }
    }

    public BUser getTestSuperUser() {
        BUserService userService = BUserService.getService();
        return userService.getUser(TEST_SUPER_USER);
    }

    public BUser getTestAdminUser() {
        BUserService userService = BUserService.getService();
        return userService.getUser(TEST_ADMIN_USER);
    }

    public BUser getTestOperatorUser() {
        BUserService userService = BUserService.getService();
        return userService.getUser(TEST_OPERATOR_USER);
    }

    public BUser getTestVisitorUser() {
        BUserService userService = BUserService.getService();
        return userService.getUser(TEST_VISITOR_USER);
    }

    protected BFoxSession connect(String userName, String password) throws Exception {
        return this.connect(userName, password, 3);
    }

    protected BFoxSession connect(String userName, String password, int maxAttempts) throws Exception {
        BFoxSession foxSession = BFoxSession.make((BHost)BLocalHost.INSTANCE, (int)this.foxPort, (boolean)false);
        TestAuthenticationClient client = new TestAuthenticationClient(userName, password);
        foxSession.getConnection().setAuthenticationClient((AuthenticationClient)client);
        Exception e = null;
        int attempts = 0;
        while (!foxSession.getConnection().isConnected() && attempts < maxAttempts) {
            try {
                ++attempts;
                foxSession = BFoxSession.connect((BFoxSession)foxSession);
                e = null;
            }
            catch (Exception ex) {
                e = ex;
            }
            if (foxSession.getConnection().isConnected() || attempts >= maxAttempts) continue;
            Thread.sleep(Long.getLong("SERVER_STARTUP_SLEEP", 1000L));
        }
        if (!foxSession.getConnection().isConnected() && e != null) {
            throw e;
        }
        Assert.assertTrue(foxSession.getConnection().isConnected(), "failed to connect fox client connection (" + foxSession.getLastFailureCause() + ")");
        return foxSession;
    }

    protected BOrd localOrd(String query) {
        return BOrd.make((String)String.format("local:|%s", query));
    }

    protected BOrd remoteOrd(String query) {
        return BOrd.make((String)String.format("local:|fox:%d|%s", this.foxPort, query));
    }

    protected BOrd remoteSlotPath(String slotPath) {
        return BOrd.make((String)String.format("local:|fox:%d|station:|slot:%s", this.foxPort, slotPath));
    }

    protected BOrd localSlotPath(String slotPath) {
        return BOrd.make((String)String.format("local:|station:|slot:%s", slotPath));
    }

    protected void sync() throws Exception {
        ((BProxyComponentSpace)BOrd.make((String)String.format("local:|fox:%d|station:", this.foxPort)).get().as(BProxyComponentSpace.class)).sync();
    }

    protected void pause(int ms) {
        try {
            System.out.println("      Pausing " + ms + "ms...");
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new TestException(e.toString());
        }
    }

    protected void configureTestStation(BStation station, String stationName, int webPort, int foxPort) throws Exception {
        BComponent drivers = BStationTestBase.addOrSetContainer(station, DRIVERS, BDriverContainer.TYPE);
        BStationTestBase.addOrSetContainer(station, "Apps", BAppContainer.TYPE);
        BServiceContainer services = station.getServices();
        services.add(ROLE_SERVICE, (BValue)this.makeRoleService());
        services.add(USER_SERVICE, (BValue)this.makeUserService());
        services.add(ALARM_SERVICE, (BValue)this.newInstance("alarm:AlarmService"));
        services.add("History", (BValue)this.newInstance("history:HistoryService"));
        services.add("Job", (BValue)this.newInstance("baja:JobService"));
        services.add(CATEGORY_SERVICE, (BValue)this.newInstance("baja:CategoryService"));
        services.add("BoxService", (BValue)this.newInstance("box:BoxService"));
        services.add(AUTH_SERVICE, (BValue)this.makeAuthService());
        services.add("SearchService", (BValue)this.newInstance("search:SearchService"));
        services.add("FoxService", (BValue)this.makeFoxService(foxPort));
        if (this.isWebServiceEnabled()) {
            services.add(WEB_SERVICE, (BValue)this.makeWebService(webPort));
        }
        if (drivers.get(NIAGARA_NETWORK) == null) {
            drivers.add(NIAGARA_NETWORK, (BValue)this.newInstance("niagaraDriver:NiagaraNetwork"));
        }
        station.setStationName(stationName);
    }

    private static BComponent addOrSetContainer(BStation station, String name, Type type) {
        BComponent container = (BComponent)station.get(name);
        if (container == null) {
            container = (BComponent)type.getInstance();
            station.add(name, (BValue)container);
        } else if (!container.getType().is(type)) {
            container = (BComponent)type.getInstance();
            station.set(name, (BValue)container, null);
        }
        return container;
    }

    protected void startStation(BStation station) throws Exception {
        BFoxService stationFoxService = ((BFoxService[])((BServiceContainer[])station.getChildren(BServiceContainer.class))[0].getChildren(BFoxService.class))[0];
        if (!station.isRunning()) {
            Nre.clearPlatform();
            Nre.loadPlatform();
            Nre.getServiceManager().startAllServices();
            station.start();
            Station.stationStarted = true;
            Nre.getEngineManager().stationStarted((BComponent)station);
        }
        int maxAttempts = 10;
        while (maxAttempts-- >= 0 && !station.isRunning()) {
            Thread.sleep(100L);
        }
        if (!station.isRunning()) {
            throw new Exception("Station did not start in time");
        }
        maxAttempts = 20;
        while (maxAttempts-- >= 0 && !stationFoxService.isServing()) {
            Thread.sleep(100L);
        }
        if (!stationFoxService.isServing()) {
            throw new Exception("Fox service did not start in time");
        }
    }

    protected BAuthenticationService makeAuthService() {
        BAuthenticationService authService = new BAuthenticationService();
        authService.get("authenticationSchemes");
        return authService;
    }

    protected BWebService makeWebService(int port) throws Exception {
        BWebService service = new BWebService();
        service.getHttpPort().setPublicServerPort(port);
        BJettyWebServer server = new BJettyWebServer();
        service.add("JettyWebServer", (BValue)server);
        return service;
    }

    protected boolean isWebServiceEnabled() {
        return true;
    }

    public BComponent makeRoleService() throws Exception {
        BRoleService roleService = new BRoleService();
        BStationTestBase.addRole(roleService, TEST_SUPER_USER, BPermissionsMap.SUPER_USER);
        BStationTestBase.addRole(roleService, TEST_ADMIN_USER, BStationTestBase.map(BPermissions.make((String)"rwiRWI")));
        BStationTestBase.addRole(roleService, TEST_OPERATOR_USER, BStationTestBase.map(BPermissions.make((String)"rwi")));
        BStationTestBase.addRole(roleService, TEST_VISITOR_USER, BStationTestBase.map(BPermissions.make((String)"r")));
        BStationTestBase.addRole(roleService, TEST_DELIMITED_USER, BPermissionsMap.SUPER_USER);
        return roleService;
    }

    public BComponent makeUserService() throws Exception {
        BUserService userService = new BUserService();
        BStationTestBase.addUser(userService, TEST_SUPER_USER);
        BStationTestBase.addUser(userService, TEST_ADMIN_USER);
        BStationTestBase.addUser(userService, TEST_OPERATOR_USER);
        BStationTestBase.addUser(userService, TEST_VISITOR_USER);
        BStationTestBase.addUser(userService, TEST_DELIMITED_USER, TEST_DELIMITED_PASS);
        return userService;
    }

    private static BPermissionsMap map(BPermissions permissions) {
        return BPermissionsMap.make((BPermissions[])new BPermissions[]{null, permissions});
    }

    protected static BPermissionsMap map(BPermissions ... permissions) {
        BPermissions[] mappedPermissions = new BPermissions[permissions.length + 1];
        mappedPermissions[0] = null;
        System.arraycopy(permissions, 0, mappedPermissions, 1, permissions.length);
        return BPermissionsMap.make((BPermissions[])mappedPermissions);
    }

    protected static BPermissionsMap map(String ... permissions) {
        BPermissions[] mappedPermissions = new BPermissions[permissions.length + 1];
        mappedPermissions[0] = null;
        for (int i = 0; i < permissions.length; ++i) {
            BPermissions permissionsValue = BPermissions.none;
            try {
                permissionsValue = BPermissions.make((String)permissions[i]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            mappedPermissions[i + 1] = permissionsValue;
        }
        return BPermissionsMap.make((BPermissions[])mappedPermissions);
    }

    private static void addRole(BRoleService roleService, String name, BPermissionsMap permissions) {
        BRole role = new BRole();
        role.setPermissions(permissions);
        roleService.add(name, (BValue)role);
    }

    protected BRole addRole(String name, BPermissionsMap permissionsMap) {
        BRole role = new BRole();
        role.setPermissions(permissionsMap);
        this.getRoleService().add(name, (BValue)role);
        return role;
    }

    private static void addUser(BUserService userService, String name) {
        BStationTestBase.addUser(userService, name, TEST_PASSWORD);
    }

    private static void addUser(BUserService userService, String name, String password) {
        userService.add(name, (BValue)BStationTestBase.makeUser(Collections.singleton(name), password));
    }

    protected BUser addUser(String userName, Set<String> roleNames) {
        BUser user = BStationTestBase.makeUser(roleNames, TEST_PASSWORD);
        this.getUserService().add(userName, (BValue)user);
        return user;
    }

    protected BUser addUser(String userName, Set<String> roleNames, String password) {
        BUser user = BStationTestBase.makeUser(roleNames, password);
        this.getUserService().add(userName, (BValue)user);
        return user;
    }

    private static BUser makeUser(Set<String> roleNames, String password) {
        BUser user = new BUser();
        roleNames.forEach(roleName -> user.addRole(roleName, Context.skipValidate));
        BPassword encodedPassword = BPassword.make((String)password, (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
        BPasswordAuthenticator pAuth = new BPasswordAuthenticator(encodedPassword);
        user.setAuthenticator((BAbstractAuthenticator)pAuth);
        return user;
    }

    protected BDriverContainer getDrivers() {
        return (BDriverContainer)this.stationHandler.getStation().get(DRIVERS);
    }

    protected BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getDrivers().get(NIAGARA_NETWORK);
    }

    protected BServiceContainer getServices() {
        return this.stationHandler.getStation().getServices();
    }

    protected BRoleService getRoleService() {
        return (BRoleService)this.getServices().get(ROLE_SERVICE);
    }

    protected BUserService getUserService() {
        return (BUserService)this.getServices().get(USER_SERVICE);
    }

    protected BWebService getWebService() {
        if (this.isWebServiceEnabled()) {
            return (BWebService)this.getServices().get(WEB_SERVICE);
        }
        return null;
    }

    protected BCategoryService getCategoryService() {
        return (BCategoryService)this.getServices().get(CATEGORY_SERVICE);
    }

    protected BAuthenticationService getAuthService() {
        return (BAuthenticationService)this.getServices().get(AUTH_SERVICE);
    }

    protected BAlarmService getAlarmService() {
        return (BAlarmService)this.getServices().get(ALARM_SERVICE);
    }

    protected String getBaseURI() {
        return "http://localhost:" + this.webPort + '/';
    }

    public BComponent makeFoxService(int foxPort) throws Exception {
        BFoxService foxSvc = new BFoxService();
        foxSvc.getFoxPort().setPublicServerPort(foxPort);
        return foxSvc;
    }

    public BComponent newInstance(String type) throws Exception {
        return (BComponent)Sys.getType((String)type).getInstance();
    }

    protected int defaultUserCount() {
        return 5;
    }

    protected String getSuperUsername() {
        return TEST_SUPER_USER;
    }

    protected String getSuperUserPassword() {
        return TEST_PASSWORD;
    }

    private static boolean hasUi() {
        UiEnv uiEnv = UiEnv.get();
        return uiEnv != null && !(uiEnv instanceof NullUiEnv);
    }
}

