/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.test.dashboard;

import java.util.List;
import java.util.regex.Pattern;
import javax.baja.security.dashboard.BISecurityDashboardItemProvider;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import org.testng.Assert;

public class SecurityDashboardItemTester {
    private final BISecurityDashboardItemProvider provider;
    private final SecurityDashboardItemBuilder itemBuilder;
    private final Context context;

    public SecurityDashboardItemTester(BISecurityDashboardItemProvider provider) {
        this(provider, null);
    }

    public SecurityDashboardItemTester(BISecurityDashboardItemProvider provider, Context context) {
        this.provider = provider;
        this.context = context;
        this.itemBuilder = new SecurityDashboardItemBuilder((BIObject)provider);
    }

    public TestForItemPresent shouldContainAlert() {
        return new TestForItemPresent(BSecurityItemStatus.securityStatusAlert);
    }

    public TestForItemPresent shouldContainInfo() {
        return new TestForItemPresent(BSecurityItemStatus.securityStatusInfo);
    }

    public TestForItemPresent shouldContainOk() {
        return new TestForItemPresent(BSecurityItemStatus.securityStatusOK);
    }

    public TestForItemPresent shouldContainWarning() {
        return new TestForItemPresent(BSecurityItemStatus.securityStatusWarning);
    }

    public void shouldContain(SecurityDashboardItem item) {
        new TestForItemPresent(item.getStatus()).withSummary(item.getSummary()).withDescription(item.getDescription());
    }

    public TestForItemsMatching filteredOn(String regex) {
        return new TestForItemsMatching(regex);
    }

    public void shouldNotContain(String summaryKey) {
        List<SecurityDashboardItem> items = this.getItems();
        for (SecurityDashboardItem item : items) {
            if (!item.getSummary().getKey().equals(summaryKey)) continue;
            Assert.fail("results should not have contained an item with key " + summaryKey);
        }
    }

    public void shouldBeEmpty() {
        List<SecurityDashboardItem> items = this.getItems();
        Assert.assertTrue(items.isEmpty(), "results should be empty");
    }

    private List<SecurityDashboardItem> getItems() {
        return this.provider.getSecurityDashboardItems(this.context);
    }

    public class TestForItemsMatching {
        private final Pattern pattern;

        public TestForItemsMatching(String regex) {
            this.pattern = Pattern.compile(regex, 2);
        }

        public void shouldEqual(SecurityDashboardItem ... expectedItems) {
            Object[] items = (SecurityDashboardItem[])SecurityDashboardItemTester.this.getItems().stream().filter(item -> this.pattern.matcher(item.getSummary().getKey()).find()).toArray(SecurityDashboardItem[]::new);
            Assert.assertEquals(items, expectedItems, "Items did not match exactly");
        }
    }

    public class TestForItemPresent {
        private final SecurityDashboardItemBuilder.ItemBuild itemBuild;

        private TestForItemPresent(BSecurityItemStatus status) {
            this.itemBuild = SecurityDashboardItemTester.this.itemBuilder.make(status);
        }

        public TestForItemPresent fromLexicon(String lex) {
            this.itemBuild.fromLexiconModule(lex);
            return this;
        }

        public TestForItemPresent withSummary(String summaryKey, Object ... args) {
            this.itemBuild.withSummary(summaryKey, args);
            return this;
        }

        public TestForItemPresent withSummary(LexiconFormatInfo summary) {
            this.itemBuild.withSummary(summary);
            return this;
        }

        public void withDescription(String descriptionKey, Object ... args) {
            this.shouldContain(this.itemBuild.withDescription(descriptionKey, args));
        }

        public void withDescription(LexiconFormatInfo description) {
            this.shouldContain(this.itemBuild.withDescription(description));
        }

        private void shouldContain(SecurityDashboardItem expectedItem) {
            List items = SecurityDashboardItemTester.this.getItems();
            boolean matches = false;
            boolean duplicateSummary = false;
            for (SecurityDashboardItem item : items) {
                if (item.getSummary().equals((Object)expectedItem.getSummary())) {
                    duplicateSummary = matches;
                }
                if (!item.equals((Object)expectedItem)) continue;
                matches = true;
            }
            if (!matches || duplicateSummary) {
                Assert.fail("results should have contained exactly one item matching " + expectedItem + "\nBut they were: " + items);
            }
        }
    }
}

