/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import com.tridium.ui.theme.Theme;
import java.text.NumberFormat;
import javax.baja.gx.BInsets;
import javax.baja.gx.IInsets;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BSlider;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BSliderEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.Lexicon;

public class BTouchSlider
extends BEdgePane {
    public static final Topic valueModified = BTouchSlider.newTopic((int)0, null);
    public static final Topic actionPerformed = BTouchSlider.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BTouchSlider.class);
    private static final BIcon icon = BIcon.std((String)"widgets/slider.png");
    private static final BIcon incIcon = BIcon.std((String)"add.png");
    private static final BIcon decIcon = BIcon.std((String)"subtract.png");
    private BButton decrement;
    private BSlider slider;
    private BButton increment;

    public void fireValueModified(BSliderEvent event) {
        this.fire(valueModified, (BValue)event, null);
    }

    public void fireActionPerformed(BSliderEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTouchSlider() {
        this(0.0, 100.0, 1.0, 50.0);
    }

    public BTouchSlider(double min, double max, double inc, double val) {
        this.increment = new BButton((Command)new IncrementCmd(inc));
        IInsets insets = Theme.button().getPadding((BAbstractButton)this.increment);
        this.increment.setPadding(BInsets.make((double)(insets.top() * 0.7)));
        this.slider = new BSlider(min, max, inc, val);
        this.decrement = new BButton((Command)new DecrementCmd(-inc));
        this.decrement.setPadding(BInsets.make((double)(insets.top() * 0.7)));
        this.setLeft((BWidget)this.decrement);
        this.setCenter((BWidget)this.slider);
        this.setRight((BWidget)this.increment);
        this.linkTo(null, (BComponent)this.slider, (Slot)BSlider.valueModified, (Slot)valueModified);
        this.linkTo(null, (BComponent)this.slider, (Slot)BSlider.actionPerformed, (Slot)actionPerformed);
    }

    public double getValue() {
        return this.slider.getValue();
    }

    public void setValue(double value) {
        this.slider.setValue(value);
    }

    private String valueToString(double v) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(3);
        return format.format(v);
    }

    public BIcon getIcon() {
        return icon;
    }

    class DecrementCmd
    extends Command {
        private double increment;

        public DecrementCmd(double increment) {
            super((BWidget)BTouchSlider.this, Lexicon.make((String)"bajaui"), "touchslider.decrement");
            this.increment = increment;
        }

        public CommandArtifact doInvoke() {
            BTouchSlider.this.slider.setValue(BTouchSlider.this.slider.getValue() + this.increment);
            BTouchSlider.this.slider.fireValueModified(new BSliderEvent(602, (BWidget)BTouchSlider.this.slider, BTouchSlider.this.slider.getValue()));
            BTouchSlider.this.slider.repaint();
            return null;
        }
    }

    class IncrementCmd
    extends Command {
        private double increment;

        public IncrementCmd(double increment) {
            super((BWidget)BTouchSlider.this, Lexicon.make((String)"bajaui"), "touchslider.increment");
            this.increment = increment;
        }

        public CommandArtifact doInvoke() {
            BTouchSlider.this.slider.setValue(BTouchSlider.this.slider.getValue() + this.increment);
            BTouchSlider.this.slider.fireValueModified(new BSliderEvent(602, (BWidget)BTouchSlider.this.slider, BTouchSlider.this.slider.getValue()));
            BTouchSlider.this.slider.repaint();
            return null;
        }
    }
}

