/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import com.tridium.kitpx.BLocalizableButton;
import com.tridium.platform.BSystemPlatformService;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandEvent;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BRebootButton
extends BLocalizableButton {
    public static final Property textFormat = BRebootButton.newProperty((int)0, (BValue)BFormat.make((String)"%lexicon(kitPx:command.reboot.label)%"), null);
    public static final Property image = BRebootButton.newProperty((int)0, (BValue)BImage.make((BIcon)BIcon.std((String)"reboot.png")), null);
    public static final Type TYPE = Sys.loadType(BRebootButton.class);
    static final Lexicon lex = Lexicon.make(BRebootButton.class);

    @Override
    public BFormat getTextFormat() {
        return (BFormat)this.get(textFormat);
    }

    @Override
    public void setTextFormat(BFormat v) {
        this.set(textFormat, (BValue)v, null);
    }

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        try {
            BSystemPlatformService service = this.getService();
            if (service != null) {
                this.setEnabled(this.canInvokeAction((BComponent)service, "restartStation"));
            } else {
                this.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setEnabled(false);
        }
    }

    @Override
    public void doInvokeAction(CommandEvent event) {
        if (this.getConfirmRequired() && !this.confirm(lex.getText("command.reboot.title"), lex.getText("command.reboot.message"))) {
            return;
        }
        BSystemPlatformService service = this.getService();
        if (service != null) {
            service.restartStation();
            BDialog.info((BWidget)this.getShell(), (Object)lex.getText("command.reboot.saving.message"));
        }
    }

    private BSystemPlatformService getService() {
        BWidgetShell shell = this.getShell();
        if (!(shell instanceof BWbShell)) {
            return null;
        }
        BOrd ord = BOrd.make((BOrd)((BWbShell)shell).getActiveOrd(), (String)"service:platform:SystemPlatformService");
        return (BSystemPlatformService)ord.get();
    }
}

