/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import com.tridium.kitpx.BButtonGroupStyle;
import java.util.HashMap;
import java.util.Map;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;

public class BButtonGroupBinding
extends BBinding {
    public static final Property style = BButtonGroupBinding.newProperty((int)0, (BValue)BButtonGroupStyle.radio, null);
    public static final Type TYPE = Sys.loadType(BButtonGroupBinding.class);
    private ToggleCommand[] cmds = null;
    Map<Integer, Integer> ordinalToCmdMap = null;

    public BButtonGroupStyle getStyle() {
        return (BButtonGroupStyle)this.get(style);
    }

    public void setStyle(BButtonGroupStyle v) {
        this.set(style, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void targetChanged() {
        String type;
        if (this.cmds == null) {
            this.init();
        }
        if ((type = this.get().getType().toString()).equals("control:BooleanWritable")) {
            this.booleanChanged();
        } else if (type.equals("control:EnumWritable")) {
            this.enumChanged();
        }
        super.targetChanged();
    }

    private void init() {
        String type = this.get().getType().toString();
        if (type.equals("control:BooleanWritable")) {
            this.booleanInit();
        } else if (type.equals("control:EnumWritable")) {
            this.enumInit();
        } else {
            System.out.println("Unknown type: " + type);
        }
    }

    private void booleanInit() {
        BWidget w = this.getWidget();
        final BComponent c = this.get().asComponent();
        final Action action = c.getAction("set");
        String trueText = "true";
        String falseText = "false";
        BFacets facets = (BFacets)c.get("facets");
        if (facets != null) {
            String s = facets.gets("trueText", null);
            if (s != null) {
                trueText = s;
            }
            if ((s = facets.gets("falseText", null)) != null) {
                falseText = s;
            }
        }
        this.cmds = new ToggleCommand[2];
        this.cmds[0] = new ToggleCommand(w, trueText){

            public CommandArtifact doInvoke() {
                if (this.isSelected()) {
                    c.invoke(action, (BValue)BBoolean.TRUE);
                }
                return null;
            }
        };
        this.cmds[1] = new ToggleCommand(w, falseText){

            public CommandArtifact doInvoke() {
                if (this.isSelected()) {
                    c.invoke(action, (BValue)BBoolean.FALSE);
                }
                return null;
            }
        };
        ToggleCommandGroup g = new ToggleCommandGroup();
        g.add(this.cmds[0]);
        g.add(this.cmds[1]);
        w.add(null, (BValue)this.makeButton(this.cmds[0]), 2);
        w.add(null, (BValue)this.makeButton(this.cmds[1]), 2);
    }

    private void booleanChanged() {
        BStatusBoolean sb = (BStatusBoolean)this.get().asComponent().get("out");
        if (sb.getValue()) {
            this.cmds[0].setSelected(true);
        } else {
            this.cmds[1].setSelected(true);
        }
    }

    private void enumInit() {
        BEnumRange r;
        BWidget w = this.getWidget();
        final BComponent c = this.get().asComponent();
        final Action action = c.getAction("set");
        BDynamicEnum enums = ((BStatusEnum)c.get("out")).getValue();
        BEnumRange range = enums.getRange();
        BFacets facets = (BFacets)c.get("facets");
        if (facets != null && (r = (BEnumRange)facets.getFacet("range")) != null) {
            range = r;
        }
        int[] ords = range.getOrdinals();
        this.cmds = new ToggleCommand[ords.length];
        ToggleCommandGroup g = new ToggleCommandGroup();
        this.ordinalToCmdMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < ords.length; ++i) {
            final int ord = ords[i];
            final BEnumRange r2 = range;
            this.cmds[i] = new ToggleCommand(w, range.getDisplayTag(ord, null)){

                public CommandArtifact doInvoke() {
                    if (this.isSelected()) {
                        BDynamicEnum val = BDynamicEnum.make((int)ord, (BEnumRange)r2);
                        c.invoke(action, (BValue)val);
                    }
                    return null;
                }
            };
            g.add(this.cmds[i]);
            w.add(null, (BValue)this.makeButton(this.cmds[i]), 2);
            this.ordinalToCmdMap.put(new Integer(ord), new Integer(i));
        }
    }

    private void enumChanged() {
        Integer idx;
        BDynamicEnum enums = ((BStatusEnum)this.get().asComponent().get("out")).getValue();
        if (this.ordinalToCmdMap != null && (idx = this.ordinalToCmdMap.get(new Integer(enums.getOrdinal()))) != null) {
            this.cmds[idx].setSelected(true);
        }
    }

    private BToggleButton makeButton(ToggleCommand c) {
        if (this.getStyle() == BButtonGroupStyle.radio) {
            return new BRadioButton(c);
        }
        return new BToggleButton((Command)c);
    }
}

