/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.util.Lexicon;

public class BBargraph
extends BWidget {
    public static final Property value = BBargraph.newProperty((int)0, (int)0, null);
    public static final Property min = BBargraph.newProperty((int)0, (int)0, null);
    public static final Property max = BBargraph.newProperty((int)0, (int)100, null);
    public static final Property text = BBargraph.newProperty((int)0, (String)"", null);
    public static final Property valueVisible = BBargraph.newProperty((int)0, (boolean)true, null);
    public static final Property valueFont = BBargraph.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property fill = BBargraph.newProperty((int)0, (BValue)BColor.make((int)0x666699).toBrush(), null);
    public static final Property foreground = BBargraph.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property background = BBargraph.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property orientation = BBargraph.newProperty((int)0, (BValue)BOrientation.vertical, null);
    public static final Property scale = BBargraph.newProperty((int)0, (int)10, null);
    public static final Property scaleFont = BBargraph.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property scaleVisible = BBargraph.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BBargraph.class);
    private static final BIcon icon = BIcon.std((String)"charts/bar.png");
    private static final double LOG10E = 0.4342944819018;
    static Lexicon lex = Lexicon.make((String)"kitPx");
    static BFont defValueFont = BFont.make((String)lex.getText("bargraph.value.font"));
    static BFont defScaleFont = BFont.make((String)lex.getText("bargraph.scale.font"));

    public double getValue() {
        return this.getDouble(value);
    }

    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    public double getMin() {
        return this.getDouble(min);
    }

    public void setMin(double v) {
        this.setDouble(min, v, null);
    }

    public double getMax() {
        return this.getDouble(max);
    }

    public void setMax(double v) {
        this.setDouble(max, v, null);
    }

    public String getText() {
        return this.getString(text);
    }

    public void setText(String v) {
        this.setString(text, v, null);
    }

    public boolean getValueVisible() {
        return this.getBoolean(valueVisible);
    }

    public void setValueVisible(boolean v) {
        this.setBoolean(valueVisible, v, null);
    }

    public BFont getValueFont() {
        return (BFont)this.get(valueFont);
    }

    public void setValueFont(BFont v) {
        this.set(valueFont, (BValue)v, null);
    }

    public BBrush getFill() {
        return (BBrush)this.get(fill);
    }

    public void setFill(BBrush v) {
        this.set(fill, (BValue)v, null);
    }

    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    public void setForeground(BBrush v) {
        this.set(foreground, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    public void setOrientation(BOrientation v) {
        this.set(orientation, (BValue)v, null);
    }

    public double getScale() {
        return this.getDouble(scale);
    }

    public void setScale(double v) {
        this.setDouble(scale, v, null);
    }

    public BFont getScaleFont() {
        return (BFont)this.get(scaleFont);
    }

    public void setScaleFont(BFont v) {
        this.set(scaleFont, (BValue)v, null);
    }

    public boolean getScaleVisible() {
        return this.getBoolean(scaleVisible);
    }

    public void setScaleVisible(boolean v) {
        this.setBoolean(scaleVisible, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        BBrush bg = this.getBackground();
        if (!bg.isNull()) {
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, w, h);
        }
        if (this.getOrientation() == BOrientation.horizontal) {
            this.paintHoriz(g);
        } else {
            this.paintVert(g);
        }
        BBrush fg = this.getForeground();
        if (!fg.isNull()) {
            g.setBrush(fg);
            g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        }
    }

    private void paintHoriz(Graphics g) {
        double scale;
        double w = this.getWidth();
        double h = this.getHeight();
        double v = this.getValue();
        double min = this.getMin();
        double max = this.getMax();
        if (max <= min) {
            return;
        }
        if (v < min) {
            v = min;
        }
        if (v > max) {
            v = max;
        }
        double x = (v - min) / (max - min) * w;
        g.setBrush(this.getFill());
        g.fillRect(0.0, 0.0, x, h);
        if (this.getValueVisible()) {
            String s = this.getText();
            BFont font = this.getValueFont();
            if (font.isNull()) {
                font = defValueFont;
            }
            double tx = x - font.width(s) - 3.0;
            double ty = (h - font.getAscent()) / 2.0 + font.getAscent();
            if (tx < 2.0) {
                tx = x + 3.0;
            }
            g.setBrush(this.getForeground());
            g.setFont(font);
            g.drawString(s, tx, ty);
        }
        if ((scale = this.getScale()) == 0.0) {
            scale = this.calcAutoScale(min, max);
        }
        if (this.getScaleVisible() && scale > 0.0) {
            double num = (max - min) / scale;
            double space = w / num;
            long roundMultiplier = 10L;
            BFont font = this.getScaleFont();
            if (font.isNull()) {
                font = defScaleFont;
            }
            g.setBrush(this.getForeground());
            g.setFont(font);
            roundMultiplier = this.calcRoundMultiplier(scale);
            int i = 0;
            while ((double)i < num) {
                double dx = (double)i * space;
                g.strokeLine(dx, h - 5.0, dx, h);
                if (i > 0 && (double)i < num) {
                    String s = "" + (double)((long)(((double)i * scale + min) * (double)roundMultiplier)) / (double)roundMultiplier;
                    if (s.endsWith(".0")) {
                        s = s.substring(0, s.length() - 2);
                    }
                    double tx = dx - font.width(s) / 2.0;
                    double ty = h - 8.0;
                    g.drawString(s, tx, ty);
                }
                ++i;
            }
        }
    }

    private void paintVert(Graphics g) {
        double scale;
        double w = this.getWidth();
        double h = this.getHeight();
        double v = this.getValue();
        double min = this.getMin();
        double max = this.getMax();
        if (max <= min) {
            return;
        }
        if (v < min) {
            v = min;
        }
        if (v > max) {
            v = max;
        }
        double y = h - (v - min) / (max - min) * h;
        g.setBrush(this.getFill());
        g.fillRect(0.0, y, w, h - y);
        if (this.getValueVisible()) {
            String s = this.getText();
            BFont font = this.getValueFont();
            if (font.isNull()) {
                font = defValueFont;
            }
            double tx = (w - font.width(s)) / 2.0;
            double ty = y + font.getAscent() + 3.0;
            if (ty > h - 2.0) {
                ty = y - 4.0;
            }
            g.setBrush(this.getForeground());
            g.setFont(font);
            g.drawString(s, tx, ty);
        }
        if ((scale = this.getScale()) == 0.0) {
            scale = this.calcAutoScale(min, max);
        }
        if (this.getScaleVisible() && scale > 0.0) {
            double num = (max - min) / scale;
            double space = h / num;
            long roundMultiplier = 10L;
            BFont font = this.getScaleFont();
            if (font.isNull()) {
                font = defScaleFont;
            }
            g.setBrush(this.getForeground());
            g.setFont(font);
            roundMultiplier = this.calcRoundMultiplier(scale);
            int i = 0;
            while ((double)i < num) {
                double dy = (double)i * space;
                g.strokeLine(w - 5.0, dy, w, dy);
                if (i > 0 && (double)i < num) {
                    String s = "" + (double)((long)(((num - (double)i) * scale + min) * (double)roundMultiplier)) / (double)roundMultiplier;
                    if (s.endsWith(".0")) {
                        s = s.substring(0, s.length() - 2);
                    }
                    double tx = w - font.width(s) - 8.0;
                    double ty = dy + font.getAscent() / 2.0 - 1.0;
                    g.drawString(s, tx, ty);
                }
                ++i;
            }
        }
    }

    private double calcAutoScale(double min, double max) {
        double tickIncrement;
        block6: {
            int tickCount;
            double delta;
            block5: {
                int MIN_TICKS = 4;
                int MAX_TICKS = 10;
                delta = max - min;
                double log10 = Math.log(delta) * 0.4342944819018;
                tickIncrement = Math.max((float)Math.pow(10.0, (long)log10), Float.MIN_VALUE);
                tickCount = (int)(delta / tickIncrement);
                if (!(delta > 1.0)) break block5;
                if (tickCount >= 4) break block6;
                tickIncrement /= 10.0;
                while (tickCount < 4) {
                    tickCount = (int)(delta / (tickIncrement *= 2.0)) + 1;
                }
                while (tickCount > 10) {
                    tickCount = (int)(delta / (tickIncrement *= 2.0)) + 1;
                }
                break block6;
            }
            if (tickCount < 4) {
                tickIncrement /= 10.0;
                while (tickCount < 4) {
                    tickCount = (int)(delta / (tickIncrement /= 2.0)) + 1;
                }
                while (tickCount > 10) {
                    tickCount = (int)(delta / (tickIncrement *= 2.0)) + 1;
                }
            }
        }
        return tickIncrement;
    }

    private long calcRoundMultiplier(double scale) {
        long multiplier = 10L;
        if (scale < 1.0) {
            while ((double)((int)scale) < 1.0) {
                scale /= 0.1;
                multiplier *= 10L;
            }
        }
        return multiplier;
    }

    public BIcon getIcon() {
        return icon;
    }
}

