/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platwifi.BWifiMacAddress;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.ui.BMacAddressFE;
import com.tridium.platwifi.ui.BWifiWhiteListEditorDialog;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

public class BWifiMacAddressVectorEditor
extends BWbView {
    public static final Action setEnabledStates = BWifiMacAddressVectorEditor.newAction((int)0, null);
    public static final Action handleFocusChange = BWifiMacAddressVectorEditor.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Type TYPE = Sys.loadType(BWifiMacAddressVectorEditor.class);
    private BGridPane contentPane;
    private BMacAddressFE focusedEditor = null;
    private Command addCommand;
    private Command deleteCommand;
    private int maxHosts = 20;
    BWifiWhiteListEditorDialog dialog;
    public static final String MAX_HOSTS = "maxHosts";

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public void handleFocusChange(BFocusEvent arg) {
        this.invoke(handleFocusChange, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWifiMacAddressVectorEditor(BWifiWhiteListEditorDialog dialog) {
        this.dialog = dialog;
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        BToolBar toolbar = new BToolBar();
        toolbarPane.add(null, (BValue)toolbar, null);
        this.addCommand = new AddCommand();
        BButton button = new BButton(this.addCommand);
        toolbar.add("add", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.deleteCommand = new DeleteCommand();
        button = new BButton(this.deleteCommand);
        toolbar.add("delete", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.contentPane = new BGridPane(1);
        this.contentPane.setHalign(BHalign.center);
        BBorderPane contentBorder = new BBorderPane((BWidget)this.contentPane, new BLabel("Whitelist MAC Addresses"), BBorder.ridge);
        contentBorder.setMargin(BInsets.make((double)20.0, (double)20.0, (double)20.0, (double)20.0));
        BEdgePane contentEdgePane = new BEdgePane();
        contentEdgePane.setTop((BWidget)contentBorder);
        contentEdgePane.setBottom((BWidget)toolbarPane);
        this.setEnabled(true);
        this.setContent((BWidget)contentEdgePane);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        try {
            this.maxHosts = cx == null ? 20 : cx.getFacets().geti(MAX_HOSTS, 20);
            BVector vector = (BVector)value;
            this.contentPane.removeAll();
            SlotCursor c = vector.loadSlots().getProperties();
            while (c.next(BWifiMacAddress.class)) {
                this.addElement(c.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BWifiMacAddressVector vector = (BWifiMacAddressVector)value;
        vector.removeAll();
        BWidget[] children = this.contentPane.getChildWidgets();
        for (int i = 0; i < children.length; ++i) {
            BWifiMacAddress fieldValue = (BWifiMacAddress)((BMacAddressFE)children[i]).saveValue(cx);
            if (fieldValue.getMac().trim().length() == 0) {
                throw new LocalizableRuntimeException("platWifi", "MacAddressFE.emptyAddress");
            }
            String propName = SlotPath.escape((String)fieldValue.getMac());
            if (vector.getProperty(propName) != null) {
                throw new LocalizableRuntimeException("platWifi", "MacAddressFE.duplicate", new Object[]{fieldValue});
            }
            vector.add(propName, (BValue)fieldValue, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:MacAddressFE")));
        }
        return vector;
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.deleteCommand.setEnabled(isEnabled && this.focusedEditor != null);
        BWidget[] children = this.contentPane.getChildWidgets();
        this.addCommand.setEnabled(isEnabled && children.length < this.maxHosts);
        for (int i = 0; i < children.length; ++i) {
            children[i].setEnabled(isEnabled);
        }
    }

    protected void doSetReadonly(boolean readonly) {
        this.setEnabled(!readonly);
        BWidget[] children = this.contentPane.getChildWidgets();
        for (int i = 0; i < children.length; ++i) {
            ((BWbFieldEditor)children[i]).setReadonly(readonly);
        }
    }

    public void addElements(BValue[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addElement(values[i]);
        }
    }

    public void addElement(BValue value) {
        BMacAddressFE editor = new BMacAddressFE();
        editor.loadValue((BObject)value);
        this.contentPane.add(null, (BValue)editor, 0);
        this.contentPane.requestFocus();
        this.focusedEditor = editor;
        editor.setEnabled(this.isEnabled());
        this.getContent().relayout();
        this.relayout();
        this.dialog.relayout();
        this.dialog.setScreenSizeToPreferredSize();
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
        this.setEnabled(this.isEnabled());
    }

    public void doSetEnabledStates() {
    }

    public void doHandleFocusChange(BFocusEvent evt) {
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (evt.getId() == 1005) {
                if (this.focusedEditor == evt.getWidget()) {
                    this.focusedEditor = null;
                }
            } else if (evt.getId() == 1004) {
                this.focusedEditor = (BMacAddressFE)evt.getWidget();
            }
            this.deleteCommand.setEnabled(this.focusedEditor != null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BMacAddressFE getFocusedEditor() {
        return this.focusedEditor;
    }

    public static Property[] getDynamicPropertiesArray(BObject obj, boolean autoLoad) {
        if (autoLoad) {
            obj.asComplex().loadSlots();
        }
        Property[] allProps = obj.asComplex().getPropertiesArray();
        for (int i = 0; i < allProps.length; ++i) {
            if (allProps[i].isFrozen()) continue;
            Property[] result = new Property[allProps.length - i];
            System.arraycopy(allProps, i, result, 0, result.length);
            return result;
        }
        return new Property[0];
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BWifiMacAddressVectorEditor.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
        }

        public CommandArtifact doInvoke() {
            BWifiMacAddressVectorEditor.this.addElement((BValue)new BWifiMacAddress(""));
            this.setEnabled(BWifiMacAddressVectorEditor.this.contentPane.getChildWidgets().length < BWifiMacAddressVectorEditor.this.maxHosts);
            BWifiMacAddressVectorEditor.this.computePreferredSize();
            BWifiMacAddressVectorEditor.this.relayout();
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BWifiMacAddressVectorEditor.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BWifiMacAddressVectorEditor.this.focusedEditor == null) {
                return null;
            }
            try {
                SlotCursor c = BWifiMacAddressVectorEditor.this.contentPane.loadSlots().getProperties();
                while (c.next(BWbFieldEditor.class)) {
                    if (c.get() != BWifiMacAddressVectorEditor.this.focusedEditor) continue;
                    BWifiMacAddressVectorEditor.this.contentPane.remove(c.property());
                    BWifiMacAddressVectorEditor.this.focusedEditor = null;
                    BWifiMacAddressVectorEditor.this.deleteCommand.setEnabled(false);
                    BWifiMacAddressVectorEditor.this.addCommand.setEnabled(true);
                    BWifiMacAddressVectorEditor.this.setModified();
                    BWifiMacAddressVectorEditor.this.relayout();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }
}

