/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platwifi.BWifiClientListEntry;
import com.tridium.platwifi.BWifiClientListVector;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLayout;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;

public class BWifiClientListEditorDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BWifiClientListEditorDialog.class);
    Command okCommand = new Ok((BWidget)this);
    int dialogResult;
    BDaemonSession sessionToUse = null;
    BWifiPlatformService serviceToUse = null;
    BGridPane displayPane;

    public Type getType() {
        return TYPE;
    }

    public BWifiClientListEditorDialog(BWidget owner, String title) throws Exception {
        super(owner, title, true);
        this.okCommand.setEnabled(true);
        BGridPane actions = new BGridPane(1);
        actions.setColumnAlign(BHalign.center);
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton(this.okCommand));
        this.displayPane = new BGridPane();
        this.displayPane.setColumnCount(1);
        this.displayPane.setHalign(BHalign.center);
        this.displayPane.setRowGap(5.0);
        this.displayPane.setColorRows(true);
        BBorderPane borderedDisplayPane = new BBorderPane((BWidget)this.displayPane, 5.0, 5.0, 5.0, 5.0);
        BEdgePane edgePane = new BEdgePane((BWidget)borderedDisplayPane, (BWidget)new BBorderPane((BWidget)actions, 10.0, 10.0, 10.0, 10.0), null, null, null);
        edgePane.getTop().setLayout(BLayout.FILL);
        this.setContent((BWidget)new BScrollPane((BWidget)edgePane));
        this.refreshSettings();
    }

    private void refreshSettings() throws Exception {
        BWifiAccessPointManager manager = (BWifiAccessPointManager)this.getOwner();
        BWifiClientListVector clients = new BWifiClientListVector();
        if (manager.getWifiDaemonSession() != null) {
            this.sessionToUse = manager.getWifiDaemonSession();
            this.serviceToUse = null;
            WifiUtil.clientListFromSession((BWifiClientListVector)clients, (BDaemonSession)manager.wifiDaemonSession);
            BWifiClientListEntry[] entries = (BWifiClientListEntry[])clients.getChildren(BWifiClientListEntry.class);
            for (int i = 0; i < entries.length; ++i) {
                StringBuilder sb = new StringBuilder();
                sb.append(" ").append(entries[i].getMac());
                sb.append(" connected for ").append(entries[i].getTime()).append(" secs");
                this.displayPane.add("entry" + i, (BValue)new BTextField(sb.toString(), 44, false));
            }
            this.relayout();
        } else if (manager.getWifiPlatformService() != null) {
            this.serviceToUse = manager.getWifiPlatformService();
            this.sessionToUse = null;
        } else {
            throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
        }
    }

    public int getResult() {
        return this.dialogResult;
    }

    class Ok
    extends Command {
        Ok(BWidget owner) {
            super(owner, BWifiClientListEditorDialog.this.getLexicon().getText("clientlist.dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            BWifiClientListEditorDialog.this.dialogResult = 1;
            BWifiClientListEditorDialog.this.close();
            return null;
        }
    }
}

