/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platwifi.BHapdHwModeEnum;
import com.tridium.platwifi.BHapdWpaConfigEnum;
import com.tridium.platwifi.BHtCapabilityEnum;
import com.tridium.platwifi.BWifiFreqBandEnum;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.security.BHapdKeyManagementEnum;
import com.tridium.platwifi.security.BWifiSupportedEncryptionEnum;
import com.tridium.platwifi.ui.BWifiChannelListVectorEditorDialog;
import com.tridium.platwifi.ui.BWifiClientListEditorDialog;
import com.tridium.platwifi.ui.BWifiWhiteListEditorDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.fieldeditors.BRelTimeFE;
import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

public class BWifiAccessPointManager
extends BWbComponentView {
    public static final Action whitelistEnabled = BWifiAccessPointManager.newAction((int)0, null);
    public static final Action adapterAddressChanged = BWifiAccessPointManager.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BWifiAccessPointManager.class);
    protected BDaemonSession wifiDaemonSession = null;
    protected BWifiSettings settings;
    protected BWifiPlatformService wifiPlatformService = null;
    private BFacets pollFacets = BFacets.make((String)"poll", (boolean)true);
    protected BGridPane generalPane = null;
    protected BGridPane sapConfigPane;
    protected BGridPane sapDhcpdPane;
    protected BLabel sapAdapterLabel = null;
    protected BIpHostFE sapAdapterIpFE = null;
    protected BIpHostFE sapAdapterNetmaskFE = null;
    private BLabel radioCfgTextInfo = null;
    private BTextField sapSsidField = null;
    private BCheckBox broadcastSsidCheckBox = null;
    private BPasswordFE sapPasswordField = null;
    private BFrozenEnumFE sapWpaField = null;
    private BFrozenEnumFE sapWpaKeyMgmtField = null;
    private BFrozenEnumFE sapWpaPairwiseField = null;
    private BIntegerFE sapTimeoutField = null;
    private ConfigWhiteListCommand configWhiteListCommand;
    private BCheckBox useWhitelistCheckBox;
    private ConfigChannelsCommand configChannelsCommand;
    private BRelTimeFE sapDhcpdLeaseTimeField = null;
    private BRelTimeFE sapDhcpdMaxLeaseTimeField = null;
    private BIpHostFE sapDhcpdSubnetField = null;
    private BIpHostFE sapDhcpdNetmaskField = null;
    private BIpHostFE sapDhcpdRangeStartField = null;
    private BIntegerFE sapDhcpdRangeSize = null;
    private int sapChannel;
    private BHapdHwModeEnum mode;
    private BHtCapabilityEnum cap;
    private static final BFacets rangeFacet = BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)16));

    public void whitelistEnabled() {
        this.invoke(whitelistEnabled, null, null);
    }

    public void adapterAddressChanged() {
        this.invoke(adapterAddressChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWifiAccessPointManager(BDaemonSession wifiDaemonSession) {
        this.wifiDaemonSession = wifiDaemonSession;
        this.wifiPlatformService = null;
    }

    public BWifiAccessPointManager(BWifiPlatformService wifiPlatformService) {
        this.wifiPlatformService = wifiPlatformService;
        this.wifiDaemonSession = null;
    }

    public final void doLoadValue(BObject value, Context contextIn) {
        this.autoRegisterForComponentEvents = false;
        this.generalPane = new BGridPane(2);
        this.generalPane.setRowAlign(BValign.top);
        this.generalPane.setHalign(BHalign.left);
        this.generalPane.setColumnAlign(BHalign.left);
        this.generalPane.setRowGap(5.0);
        this.generalPane.setColumnGap(10.0);
        this.generalPane.setStretchColumn(1);
        this.sapAdapterLabel = new BLabel("");
        LabelUtil.addLabelWidgetPair((BPane)this.generalPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.generalSettings.sapAdapterName.label"), (BWidget)this.sapAdapterLabel);
        this.sapAdapterIpFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.generalPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.generalSettings.sapAdapterIp.label"), (BWidget)this.sapAdapterIpFE);
        this.sapAdapterNetmaskFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.generalPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.generalSettings.sapAdapterNetmask.label"), (BWidget)this.sapAdapterNetmaskFE);
        this.linkTo("sapiplk0", (BComponent)this.sapAdapterIpFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo("sapiplk1", (BComponent)this.sapAdapterNetmaskFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo("sapiplk2", (BComponent)this.sapAdapterIpFE, (Slot)BIpHostFE.actionPerformed, (Slot)adapterAddressChanged);
        this.linkTo("sapiplk3", (BComponent)this.sapAdapterNetmaskFE, (Slot)BIpHostFE.actionPerformed, (Slot)adapterAddressChanged);
        BBorderPane settingsBorder = new BBorderPane((BWidget)this.generalPane);
        settingsBorder.setBorder(BBorder.solid);
        settingsBorder.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiAccessPointManager.generalSettings.label"), (boolean)true));
        settingsBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.sapConfigPane = new BGridPane(2);
        this.sapConfigPane.setRowAlign(BValign.top);
        this.sapConfigPane.setHalign(BHalign.left);
        this.sapConfigPane.setColumnAlign(BHalign.left);
        this.sapConfigPane.setRowGap(5.0);
        this.sapConfigPane.setColumnGap(10.0);
        this.sapConfigPane.setStretchColumn(1);
        this.sapConfigPane.setColorRows(false);
        this.sapSsidField = new BTextField("", 32);
        this.broadcastSsidCheckBox = new BCheckBox(LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.broadcastSsid.label").getText(null), false);
        BFlowPane ssidEditor = new BFlowPane();
        ssidEditor.add("ssid", (BValue)this.sapSsidField);
        ssidEditor.add("bcast", (BValue)this.broadcastSsidCheckBox);
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.ssid.label"), (BWidget)ssidEditor);
        this.sapPasswordField = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.psk.label"), (BWidget)this.sapPasswordField);
        this.sapWpaField = new BFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.wpa.label"), (BWidget)this.sapWpaField);
        this.sapWpaKeyMgmtField = new BFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.keymgmt.label"), (BWidget)this.sapWpaKeyMgmtField);
        this.sapWpaPairwiseField = new BFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.pairwise.label"), (BWidget)this.sapWpaPairwiseField);
        this.sapTimeoutField = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.sapTo.label"), (BWidget)this.sapTimeoutField);
        BButtonPane whiteListButtons = new BButtonPane();
        whiteListButtons.setColumnCount(2);
        whiteListButtons.setUniformColumnWidth(false);
        whiteListButtons.setBandBrush(Theme.scrollPane().getControlBackground());
        this.configWhiteListCommand = new ConfigWhiteListCommand();
        whiteListButtons.add("config", (BValue)new BButton((Command)this.configWhiteListCommand, true, true));
        BFlowPane whiteListFlowPane = new BFlowPane();
        String wlCheckBoxText = LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.whitelistCheckBox.label").getText(null);
        this.useWhitelistCheckBox = new BCheckBox(wlCheckBoxText, false);
        whiteListFlowPane.add("checkbox", (BValue)this.useWhitelistCheckBox);
        whiteListFlowPane.add("button", (BValue)whiteListButtons);
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.whitelist.label"), (BWidget)whiteListFlowPane);
        BButtonPane configChannelButtons = new BButtonPane();
        configChannelButtons.setColumnCount(2);
        configChannelButtons.setUniformColumnWidth(false);
        configChannelButtons.setBandBrush(Theme.scrollPane().getControlBackground());
        this.configChannelsCommand = new ConfigChannelsCommand();
        configChannelButtons.add("config", (BValue)new BButton((Command)this.configChannelsCommand, true, true));
        BFlowPane configChannelFlowPane = new BFlowPane();
        this.radioCfgTextInfo = new BLabel("");
        configChannelFlowPane.add("button", (BValue)configChannelButtons);
        configChannelFlowPane.add("cc", (BValue)this.radioCfgTextInfo);
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.sapSettings.configChannels.label"), (BWidget)configChannelFlowPane);
        this.settings = (BWifiSettings)value;
        BButtonPane hapdbuttons = new BButtonPane();
        hapdbuttons.add((Command)new ShowClientsCommand());
        hapdbuttons.addWorkbenchButtons((BWidget)this);
        this.linkTo("saplk1", (BComponent)this.sapSsidField, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("saplk2", (BComponent)this.broadcastSsidCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("saplk3", (BComponent)this.sapPasswordField, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo("saplk6", (BComponent)this.sapWpaField, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo("saplk7", (BComponent)this.sapWpaKeyMgmtField, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo("saplk8", (BComponent)this.sapWpaPairwiseField, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo("saplk9", (BComponent)this.sapTimeoutField, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        this.linkTo("saplk10", (BComponent)this.useWhitelistCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("saplk11", (BComponent)this.useWhitelistCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)whitelistEnabled);
        BBorderPane apBorder = new BBorderPane((BWidget)this.sapConfigPane);
        apBorder.setBorder(BBorder.solid);
        apBorder.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiAccessPointManager.sapSettings.label"), (boolean)true));
        apBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.sapDhcpdPane = new BGridPane(2);
        this.sapDhcpdPane.setRowAlign(BValign.top);
        this.sapDhcpdPane.setHalign(BHalign.left);
        this.sapDhcpdPane.setColumnAlign(BHalign.left);
        this.sapDhcpdPane.setRowGap(5.0);
        this.sapDhcpdPane.setColumnGap(10.0);
        this.sapDhcpdPane.setStretchColumn(1);
        this.sapDhcpdPane.setColorRows(false);
        this.sapDhcpdLeaseTimeField = new BRelTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.dhcpdSettings.defaultLeaseTime.label"), (BWidget)this.sapDhcpdLeaseTimeField);
        this.sapDhcpdMaxLeaseTimeField = new BRelTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.dhcpdSettings.maxLeaseTime.label"), (BWidget)this.sapDhcpdMaxLeaseTimeField);
        this.sapDhcpdSubnetField = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.dhcpdSettings.subnet.label"), (BWidget)this.sapDhcpdSubnetField);
        this.sapDhcpdNetmaskField = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.dhcpdSettings.netmask.label"), (BWidget)this.sapDhcpdNetmaskField);
        this.sapDhcpdRangeStartField = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.dhcpdSettings.rangestart.label"), (BWidget)this.sapDhcpdRangeStartField);
        this.sapDhcpdRangeSize = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiAccessPointManager.dhcpdSettings.rangesize.label"), (BWidget)this.sapDhcpdRangeSize);
        this.sapDhcpdSubnetField.setReadonly(true);
        this.sapDhcpdNetmaskField.setReadonly(true);
        this.linkTo("dhcpdlk0", (BComponent)this.sapDhcpdLeaseTimeField, (Slot)BRelTimeFE.pluginModified, (Slot)setModified);
        this.linkTo("dhcpdlk1", (BComponent)this.sapDhcpdMaxLeaseTimeField, (Slot)BRelTimeFE.pluginModified, (Slot)setModified);
        this.linkTo("dhcpdlk2", (BComponent)this.sapDhcpdSubnetField, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo("dhcpdlk3", (BComponent)this.sapDhcpdNetmaskField, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo("dhcpdlk4", (BComponent)this.sapDhcpdRangeStartField, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo("dhcpdlk5", (BComponent)this.sapDhcpdRangeSize, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        BBorderPane dhcpBorder = new BBorderPane((BWidget)this.sapDhcpdPane);
        dhcpBorder.setBorder(BBorder.solid);
        dhcpBorder.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiAccessPointManager.dhcpdSettings.label"), (boolean)true));
        dhcpBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        BGridPane assembledPanes = new BGridPane();
        assembledPanes.setColumnCount(1);
        assembledPanes.setUniformColumnWidth(true);
        assembledPanes.setStretchColumn(0);
        assembledPanes.setColumnAlign(BHalign.fill);
        assembledPanes.add("settingsBorder", (BValue)settingsBorder);
        assembledPanes.add("dhcpBorder", (BValue)dhcpBorder);
        assembledPanes.add("apBorder", (BValue)apBorder);
        assembledPanes.add("buttons", (BValue)hapdbuttons);
        this.setContent((BWidget)new BScrollPane((BWidget)new BBorderPane((BWidget)assembledPanes)));
        this.refreshSettings((BWifiSettings)value, contextIn);
    }

    private void setReadOnlyDhcpdPane(boolean readOnlyIn) {
        boolean enabled;
        boolean bl = enabled = !readOnlyIn;
        if (this.sapDhcpdLeaseTimeField != null) {
            this.sapDhcpdLeaseTimeField.setReadonly(enabled);
            this.sapDhcpdLeaseTimeField.setEnabled(enabled);
        }
        if (this.sapDhcpdLeaseTimeField != null) {
            this.sapDhcpdMaxLeaseTimeField.setReadonly(enabled);
            this.sapDhcpdMaxLeaseTimeField.setEnabled(enabled);
        }
        if (this.sapDhcpdLeaseTimeField != null) {
            this.sapDhcpdRangeStartField.setReadonly(enabled);
            this.sapDhcpdRangeStartField.setEnabled(enabled);
        }
        if (this.sapDhcpdLeaseTimeField != null) {
            this.sapDhcpdRangeSize.setReadonly(enabled);
            this.sapDhcpdRangeSize.setEnabled(enabled);
        }
    }

    public final void refreshSettings(BWifiSettings wifiSettings, Context contextIn) {
        if (wifiSettings == null) {
            return;
        }
        if (this.sapAdapterLabel == null) {
            return;
        }
        if (this.sapSsidField == null) {
            return;
        }
        if (this.sapPasswordField == null) {
            return;
        }
        if (this.sapWpaField == null) {
            return;
        }
        if (this.sapWpaKeyMgmtField == null) {
            return;
        }
        if (this.sapWpaPairwiseField == null) {
            return;
        }
        this.lockModifiedState();
        boolean alreadyModified = this.isModified();
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
        BDhcpdAdapterSettings dhcpdSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get("tiw_sap0");
        if (!cx.getFacets().equals((Object)this.pollFacets)) {
            this.sapChannel = this.settings.getSapChannel();
            this.mode = this.settings.getSapHwMode();
            this.cap = this.settings.getSapHtCapab();
            this.sapAdapterLabel.setText(wifiSettings.getSapAdapterName());
            this.sapAdapterIpFE.loadValue((BObject)BString.make((String)wifiSettings.getSapAdapterIp()));
            this.sapAdapterNetmaskFE.loadValue((BObject)BString.make((String)wifiSettings.getSapAdapterNetmask()));
            this.radioCfgTextInfo.setText(wifiSettings.getRadioConfigString());
            this.sapSsidField.setText(wifiSettings.getSapSsid());
            this.broadcastSsidCheckBox.setSelected(wifiSettings.getIgnoreBroadcastSsid() == 0);
            this.sapPasswordField.loadValue((BObject)BPassword.make((String)wifiSettings.getSapWpaPassphrase()));
            this.sapWpaField.loadValue((BObject)BHapdWpaConfigEnum.make((int)wifiSettings.getSapWpa()));
            this.sapWpaKeyMgmtField.loadValue((BObject)BHapdKeyManagementEnum.make((String)wifiSettings.getSapWpaKeyMgmt()));
            this.sapWpaPairwiseField.loadValue((BObject)BWifiSupportedEncryptionEnum.toEncryptionMethodEnum((String)wifiSettings.getSapWpaPairwise()));
            this.sapTimeoutField.loadValue((BObject)BInteger.make((int)wifiSettings.getSapTimeout()));
            if (dhcpdSettings != null) {
                BasicContext feContext = new BasicContext(cx, BDhcpdAdapterSettings.defaultLeaseTime.getFacets());
                this.sapDhcpdLeaseTimeField.loadValue((BObject)dhcpdSettings.getDefaultLeaseTime(), (Context)feContext);
                feContext = new BasicContext(cx, BDhcpdAdapterSettings.maxLeaseTime.getFacets());
                this.sapDhcpdMaxLeaseTimeField.loadValue((BObject)dhcpdSettings.getMaxLeaseTime(), (Context)feContext);
                this.sapDhcpdSubnetField.loadValue((BObject)BString.make((String)dhcpdSettings.getSubnet()));
                this.sapDhcpdNetmaskField.loadValue((BObject)BString.make((String)dhcpdSettings.getSubnetMask()));
                this.sapDhcpdRangeStartField.loadValue((BObject)BString.make((String)dhcpdSettings.getStartClientAddress()));
                BasicContext rangeContext = new BasicContext(cx, rangeFacet);
                this.sapDhcpdRangeSize.loadValue((BObject)BInteger.make((int)dhcpdSettings.getRange()), (Context)rangeContext);
            } else {
                this.setReadOnlyDhcpdPane(true);
            }
            this.useWhitelistCheckBox.setSelected(wifiSettings.getUseWhitelist());
        }
        this.unlockModifiedState();
        if (!alreadyModified) {
            this.clearModified();
        }
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        byte[] ipBytes;
        int lastOctet;
        int endLastOctet;
        String en1net;
        String en0net;
        if (!this.isModified()) {
            return value;
        }
        if (value == null) {
            return null;
        }
        BFacets saveFacets = BFacets.make((String)"savehostapd", (BIDataValue)BBoolean.TRUE);
        cx = new BasicContext(cx, saveFacets);
        BWifiSettings settings = (BWifiSettings)value;
        BDhcpdHostSettings dhcpdHostSettings = settings.getDhcpdHostSettings();
        BDhcpdAdapterSettings dhcpdSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get("tiw_sap0");
        settings.setSapChannel(this.sapChannel);
        if (this.sapChannel < 15) {
            settings.setSapFreqBand(BWifiFreqBandEnum.band24);
        } else {
            settings.setSapFreqBand(BWifiFreqBandEnum.band50);
        }
        settings.setSapHwMode(this.mode);
        settings.setSapHtCapab(this.cap);
        BString sapAddress = (BString)this.sapAdapterIpFE.saveValue(cx);
        BString sapMask = (BString)this.sapAdapterNetmaskFE.saveValue(cx);
        String sapAddressStr = sapAddress.getString().trim();
        String sapMaskStr = sapMask.getString().trim();
        String sapSubnetStr = IPAddressUtil.getIPv4NetworkPrefix((String)sapAddressStr, (String)sapMaskStr);
        if (sapAddressStr.length() == 0) {
            this.saveError(settings.getSapAdapterName(), "SapIpAdapterEditor.nullIpAddress");
        }
        if (sapSubnetStr.length() == 0) {
            this.saveError(settings.getSapAdapterName(), "SapIpAdapterEditor.nullSubnetMask");
        }
        if (!IPAddressUtil.isIpv4Address((String)sapAddressStr)) {
            this.saveError(settings.getSapAdapterName(), "SapIpAdapterEditor.invalidIPv4Address");
        }
        if (!IPAddressUtil.isIpv4SubnetMask((String)sapMaskStr)) {
            this.saveError(settings.getSapAdapterName(), "SapIpAdapterEditor.invalidSubnetMaskValue");
        }
        if (IPAddressUtil.isIpv4Address((String)settings.getEn0AdapterIp()) && IPAddressUtil.isIpv4SubnetMask((String)settings.getEn0AdapterNetmask()) && IPAddressUtil.compare((Object)sapSubnetStr, (Object)(en0net = IPAddressUtil.getIPv4NetworkPrefix((String)settings.getEn0AdapterIp(), (String)settings.getEn0AdapterNetmask()))) == 0) {
            this.saveError(settings.getSapAdapterName(), "SapIpAdaptereditor.duplicateSubnet");
        }
        if (IPAddressUtil.isIpv4Address((String)settings.getEn1AdapterIp()) && IPAddressUtil.isIpv4SubnetMask((String)settings.getEn1AdapterNetmask()) && IPAddressUtil.compare((Object)sapSubnetStr, (Object)(en1net = IPAddressUtil.getIPv4NetworkPrefix((String)settings.getEn1AdapterIp(), (String)settings.getEn1AdapterNetmask()))) == 0) {
            this.saveError(settings.getSapAdapterName(), "SapIpAdaptereditor.duplicateSubnet");
        }
        settings.setSapAdapterIp(sapAddressStr);
        settings.setSapAdapterNetmask(sapMaskStr);
        BPassword pw = (BPassword)this.sapPasswordField.saveValue();
        String pws = AccessController.doPrivileged(() -> ((BPassword)pw).getValue());
        if (pws.length() < 8 || pws.length() > 64) {
            this.saveError(settings.getSapAdapterName(), "SapWpaPasswordField.invalidPassword");
        }
        settings.setSapWpaPassphrase(pws);
        String ssid = this.sapSsidField.getText();
        if (ssid.length() < 1) {
            this.saveError(settings.getSapAdapterName(), "SapSSIDField.invalidSSID");
        }
        settings.setSapSsid(this.sapSsidField.getText());
        settings.setIgnoreBroadcastSsid(this.broadcastSsidCheckBox.getSelected() ? 0 : 1);
        settings.setSapWpa(((BHapdWpaConfigEnum)this.sapWpaField.saveValue(cx)).getOrdinal());
        settings.setSapWpaKeyMgmt(((BHapdKeyManagementEnum)this.sapWpaKeyMgmtField.saveValue(cx)).getTag());
        settings.setSapWpaPairwise(BWifiSupportedEncryptionEnum.getEncryptionString((BWifiSupportedEncryptionEnum)((BWifiSupportedEncryptionEnum)this.sapWpaPairwiseField.saveValue())));
        int timeout = ((BInteger)this.sapTimeoutField.saveValue(cx)).getInt();
        if (timeout < 0) {
            this.saveError(settings.getSapAdapterName(), "SapTimeoutField.badValue");
        }
        settings.setSapTimeout(timeout);
        settings.setUseWhitelist(this.useWhitelistCheckBox.getSelected());
        dhcpdSettings.setDefaultLeaseTime((BRelTime)this.sapDhcpdLeaseTimeField.saveValue(cx));
        dhcpdSettings.setMaxLeaseTime((BRelTime)this.sapDhcpdMaxLeaseTimeField.saveValue(cx));
        dhcpdSettings.setSubnet(this.sapDhcpdSubnetField.saveValue().toString(cx));
        String dhcpdMask = this.sapDhcpdNetmaskField.saveValue().toString(cx);
        if (IPAddressUtil.isIpv4SubnetMask((String)dhcpdMask) && dhcpdMask.equals(sapMaskStr)) {
            dhcpdSettings.setSubnetMask(this.sapDhcpdNetmaskField.saveValue().toString(cx));
        } else {
            this.saveError(settings.getSapAdapterName(), "SapDhcpdNetmask.invalidMask");
        }
        String startDhcpStr = this.sapDhcpdRangeStartField.saveValue().toString(cx);
        dhcpdSettings.setStartClientAddress(startDhcpStr);
        BInteger range = (BInteger)this.sapDhcpdRangeSize.saveValue();
        int r = range.getInt();
        if (r > 16) {
            this.saveError(settings.getSapAdapterName(), "SapDhcpdRange.rangeTooBig");
            r = 16;
        }
        if (r < 1) {
            this.saveError(settings.getSapAdapterName(), "SapDhcpdRange.rangeLessThanOne");
            r = 1;
        }
        if ((endLastOctet = (lastOctet = (ipBytes = IPAddressUtil.numericStringToByteArray((String)startDhcpStr))[3] & 0xFF) + r - 1) > 254) {
            this.saveError(settings.getSapAdapterName(), "SapDhcpdRange.endAddrToBig");
            endLastOctet = 254;
        }
        dhcpdSettings.setRange(r);
        String endDhcpStr = DhcpdUtil.getEndIpAddress((int)range.getInt(), (String)startDhcpStr);
        String dhcpStartAddrPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)startDhcpStr, (String)dhcpdMask);
        String dhcpEndAddrPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)endDhcpStr, (String)dhcpdMask);
        if (IPAddressUtil.compare((Object)dhcpStartAddrPrefix, (Object)sapSubnetStr) != 0 || IPAddressUtil.compare((Object)dhcpEndAddrPrefix, (Object)sapSubnetStr) != 0) {
            this.saveError(settings.getSapAdapterName(), "SapDhcpdRange.notInSubnet");
        }
        if (IPAddressUtil.compare((Object)sapAddressStr, (Object)startDhcpStr) != -1 && IPAddressUtil.compare((Object)sapAddressStr, (Object)endDhcpStr) != 1) {
            this.saveError(settings.getSapAdapterName(), "SapDhcpdRange.adapterInClientRange");
        }
        this.radioCfgTextInfo.setText(settings.getRadioConfigString());
        this.refreshSettings(settings, null);
        return value;
    }

    protected void saveError(String interfaceId, String messageTag) throws CannotSaveException {
        BDialog.error((BWidget)this, (String)this.getLexicon().getText("SapIpAdapterEditor.invalidDataTitle"), (Object)(interfaceId + ": " + this.getLexicon().getText(messageTag)));
        CannotSaveException cse = new CannotSaveException();
        cse.setSilent(true);
        throw cse;
    }

    private void saveParent(int section) throws Exception {
        BWifiAccessPointManager ancestor = this;
        BFacets saveFacets = section == 0 ? BFacets.make((String)"savetype", (String)"hostip") : (section == 1 ? BFacets.make((String)"savetype", (String)"hostapd") : (section == 2 ? BFacets.make((String)"savetype", (String)"dhcpd") : (section == 3 ? BFacets.make((String)"savetype", (String)"whitelist") : BFacets.make((String)"savetype", (String)"all"))));
        BasicContext saveContext = new BasicContext((Context)null, saveFacets);
        while ((ancestor = ancestor.getParent()) != null) {
            if (!(ancestor instanceof BWbComponentView)) continue;
            BWbComponentView plugin = ancestor;
            plugin.saveValue((Context)saveContext);
            return;
        }
        throw new CannotSaveException("Can not find eligible parent (BWbComponentView)");
    }

    public final void doWhitelistEnabled() {
        boolean useWhitelist = false;
        useWhitelist = this.useWhitelistCheckBox.getSelected();
        if (useWhitelist) {
            try {
                this.configWhiteListCommand.doInvoke();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void doAdapterAddressChanged() {
        int size;
        BString startIp;
        BString badapterMask;
        BString badapterIp;
        try {
            badapterIp = (BString)this.sapAdapterIpFE.saveValue();
            badapterMask = (BString)this.sapAdapterNetmaskFE.saveValue();
            startIp = (BString)this.sapDhcpdRangeStartField.saveValue();
            size = ((BInteger)this.sapDhcpdRangeSize.saveValue()).getInt();
        }
        catch (Exception e) {
            return;
        }
        String net = IPAddressUtil.getIPv4NetworkPrefix((String)badapterIp.toString(), (String)badapterMask.toString());
        this.sapDhcpdSubnetField.loadValue((BObject)BString.make((String)net));
        this.sapDhcpdNetmaskField.loadValue((BObject)badapterMask);
        this.sapDhcpdSubnetField.setModified();
        byte[] startaddr = IPAddressUtil.numericStringToByteArray((String)startIp.toString());
        byte[] mask = IPAddressUtil.numericStringToByteArray((String)badapterMask.toString());
        byte[] netbytes = IPAddressUtil.numericStringToByteArray((String)net);
        StringBuilder startAsString = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int quartet = (startaddr[i] & ~mask[i] | netbytes[i]) & 0xFF;
            startAsString.append(quartet);
            if (i == 3) continue;
            startAsString.append('.');
        }
        this.sapDhcpdRangeStartField.loadValue((BObject)BString.make((String)startAsString.toString()));
        if (netbytes[3] + size > 254) {
            size = 254 - netbytes[3];
        }
        this.sapDhcpdRangeSize.loadValue((BObject)BInteger.make((int)size));
    }

    public BDaemonSession getWifiDaemonSession() {
        return this.wifiDaemonSession;
    }

    public BWifiPlatformService getWifiPlatformService() {
        return this.wifiPlatformService;
    }

    public BWifiSettings getSettings() {
        return this.settings;
    }

    private class ConfigWhiteListCommand
    extends Command {
        public ConfigWhiteListCommand() {
            super((BWidget)BWifiAccessPointManager.this, BWifiAccessPointManager.this.getLexicon().get("whiteListDialog.description", "White List"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BWifiMacAddressVector macAddresses;
            try {
                macAddresses = this.promptEdit();
                if (macAddresses == null) {
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (macAddresses.getLength() == 0) {
                BWifiAccessPointManager.this.useWhitelistCheckBox.setSelected(false);
            }
            return null;
        }

        public BWifiMacAddressVector promptEdit() throws Exception {
            BWifiMacAddressVector whiteList = new BWifiMacAddressVector();
            String title = BWifiAccessPointManager.this.getLexicon().get("whiteListDialog.title", "Edit White List");
            BWifiWhiteListEditorDialog dialog = new BWifiWhiteListEditorDialog((BWidget)BWifiAccessPointManager.this, title, whiteList);
            dialog.setBoundsCenteredOnOwner();
            dialog.open();
            if (dialog.getResult() == 1) {
                return whiteList;
            }
            return null;
        }
    }

    private class ConfigChannelsCommand
    extends Command {
        public ConfigChannelsCommand() {
            super((BWidget)BWifiAccessPointManager.this, BWifiAccessPointManager.this.getLexicon().get("configChannelsCommand.description", "Config Channel"));
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                String title = BWifiAccessPointManager.this.getLexicon().get("radioConfig.dialog.title", "Config Radio");
                BWifiChannelListVectorEditorDialog dialog = new BWifiChannelListVectorEditorDialog((BWidget)BWifiAccessPointManager.this, title, BWifiAccessPointManager.this.settings);
                dialog.setBoundsCenteredOnOwner();
                dialog.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BWifiAccessPointManager.this.sapChannel = BWifiAccessPointManager.this.settings.getSapChannel();
            BWifiAccessPointManager.this.mode = BWifiAccessPointManager.this.settings.getSapHwMode();
            BWifiAccessPointManager.this.cap = BWifiAccessPointManager.this.settings.getSapHtCapab();
            return null;
        }
    }

    private class ShowClientsCommand
    extends Command {
        public ShowClientsCommand() {
            super((BWidget)BWifiAccessPointManager.this, BWifiAccessPointManager.this.getLexicon().get("showClientsDialog.description", "Show Clients"));
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                String title = BWifiAccessPointManager.this.getLexicon().get("clientListDialog.title", "Client List");
                BWifiClientListEditorDialog dialog = new BWifiClientListEditorDialog((BWidget)BWifiAccessPointManager.this, title);
                dialog.setBoundsCenteredOnOwner();
                dialog.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

