/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platwifi.BWifiMacAddress;
import com.tridium.ui.util.ValidatingTextController;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.text.TextController;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BMacAddressFE
extends BWbFieldEditor {
    public static final Action propagateFocusEvent = BMacAddressFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Action propagateKeyEvent = BMacAddressFE.newAction((int)4, (BValue)new BKeyEvent(), null);
    public static final Action propagateMouseEvent = BMacAddressFE.newAction((int)4, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BMacAddressFE.class);
    private BTextField field = new BTextField("", 17);

    public void propagateFocusEvent(BFocusEvent arg) {
        this.invoke(propagateFocusEvent, (BValue)arg, null);
    }

    public void propagateKeyEvent(BKeyEvent arg) {
        this.invoke(propagateKeyEvent, (BValue)arg, null);
    }

    public void propagateMouseEvent(BMouseEvent arg) {
        this.invoke(propagateMouseEvent, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMacAddressFE() {
        this.field.setController((TextController)new Controller());
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.field, (Slot)BTextField.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo("lk3", (BComponent)this.field, (Slot)BTextField.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo("lk4", (BComponent)this.field, (Slot)BTextField.mouseEvent, (Slot)propagateMouseEvent);
        this.setContent((BWidget)this.field);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BWifiMacAddress bmac = (BWifiMacAddress)value;
        this.field.setText(bmac.getMac());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BWifiMacAddress mac = (BWifiMacAddress)value;
        String text = this.field.getText();
        if (text.trim().length() == 0) {
            return value;
        }
        if (!text.matches("^([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F])$")) {
            throw new CannotSaveException("improper mac address format");
        }
        mac.setMac(text);
        return value;
    }

    public void setEnabled(boolean value) {
    }

    public void doPropagateFocusEvent(BFocusEvent evt) {
        this.fireFocusEvent(new BFocusEvent(evt.getId(), (BWidget)this, evt.isTemporary()));
    }

    public void doPropagateKeyEvent(BKeyEvent evt) {
        this.fireKeyEvent(new BKeyEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getKeyCode(), evt.getKeyChar()));
    }

    public void doPropagateMouseEvent(BMouseEvent evt) {
        if (evt instanceof BMouseWheelEvent) {
            this.fireMouseEvent((BMouseEvent)new BMouseWheelEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger(), ((BMouseWheelEvent)evt).getWheelRotation()));
        } else {
            this.fireMouseEvent(new BMouseEvent(evt.getId(), (BWidget)this, evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger()));
        }
    }

    private class Controller
    extends ValidatingTextController {
        private Controller() {
        }

        protected boolean valid(String address) {
            int length = address.trim().length();
            switch (length) {
                case 0: {
                    return true;
                }
                case 1: {
                    return address.matches("^[0-9a-fA-F]$");
                }
                case 2: {
                    return address.matches("^[0-9a-fA-F][0-9a-fA-F]$");
                }
                case 3: {
                    return address.matches("^[0-9a-fA-F][0-9a-fA-F]:$");
                }
                case 4: {
                    return address.matches("^[0-9a-fA-F][0-9a-fA-F]:[0-9a-fA-F]$");
                }
                case 5: {
                    return address.matches("^[0-9a-fA-F][0-9a-fA-F]:[0-9a-fA-F][0-9a-fA-F]$");
                }
                case 6: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){2}$");
                }
                case 7: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){2}[0-9a-fA-F]$");
                }
                case 8: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){2}[0-9a-fA-F][0-9a-fA-F]$");
                }
                case 9: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){3}$");
                }
                case 10: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){3}[0-9a-fA-F]$");
                }
                case 11: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){3}[0-9a-fA-F][0-9a-fA-F]$");
                }
                case 12: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){4}$");
                }
                case 13: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){4}[0-9a-fA-F]$");
                }
                case 14: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){4}[0-9a-fA-F][0-9a-fA-F]$");
                }
                case 15: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){5}$");
                }
                case 16: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){5}[0-9a-fA-F]$");
                }
                case 17: {
                    return address.matches("^([0-9a-fA-F][0-9a-fA-F]:){5}[0-9a-fA-F][0-9a-fA-F]$");
                }
            }
            return false;
        }
    }
}

