/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.util;

import com.prosysopc.ua.stack.cert.CertificateCheck;
import com.prosysopc.ua.stack.cert.DefaultCertificateValidatorListener;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.transport.security.Cert;
import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpcUaCertificateValidationListener
implements DefaultCertificateValidatorListener {
    Logger logger = Logger.getLogger("opcUaClient.certificateValidationListener");

    public ValidationResult onValidate(Cert certificate, ApplicationDescription applicationDescription, EnumSet<CertificateCheck> passedChecks) {
        if (!passedChecks.contains(CertificateCheck.Trusted) || !passedChecks.contains(CertificateCheck.Signature) || !passedChecks.contains(CertificateCheck.Validity) || passedChecks.contains(CertificateCheck.SelfSigned)) {
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, "*** The Server Certificate : ");
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, "Subject   : " + certificate.getCertificate().getSubjectX500Principal().toString());
            this.logger.log(Level.INFO, "Issued by : " + certificate.getCertificate().getIssuerX500Principal().toString());
            this.logger.log(Level.INFO, "Valid from: " + certificate.getCertificate().getNotBefore().toString());
            this.logger.log(Level.INFO, "        to: " + certificate.getCertificate().getNotAfter().toString());
            this.logger.log(Level.INFO, "");
        }
        if (!passedChecks.contains(CertificateCheck.Trusted)) {
            this.logger.log(Level.INFO, "* The certificate is NOT TRUSTED BY THE USER!");
            return ValidationResult.Reject;
        }
        if (!passedChecks.contains(CertificateCheck.Signature)) {
            this.logger.log(Level.INFO, "* The certificate is NOT SIGNED BY A TRUSTED SIGNER!");
            return ValidationResult.Reject;
        }
        if (!passedChecks.contains(CertificateCheck.Validity)) {
            boolean isOld;
            Date today = new Date();
            boolean isYoung = certificate.getCertificate().getNotBefore().compareTo(today) > 0;
            boolean bl = isOld = certificate.getCertificate().getNotAfter().compareTo(today) < 0;
            String oldOrYoung = isOld ? "(ANYMORE)" : (isYoung ? "(YET)" : "");
            this.logger.log(Level.INFO, "* The certificate time interval IS NOT VALID " + oldOrYoung + "!");
            return ValidationResult.Reject;
        }
        if (passedChecks.contains(CertificateCheck.SelfSigned)) {
            this.logger.log(Level.INFO, "* The certificate is self-signed.");
        }
        return ValidationResult.AcceptPermanently;
    }
}

