/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.AbstractOptionSetDataType;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.EventNotifierType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.tridium.ndriver.discover.BINDiscoveryIcon;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaLearnBase;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="UaNodeName", type="String", defaultValue="", flags=5), @NiagaraProperty(name="UaDisplayName", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaNodeId", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="NameSpaceUri", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="ArrayDimension", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="ArrayIndex", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="NodeClass", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="Description", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="TypeSpec", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaDataType", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaDataTypeIdentifier", type="long", defaultValue="-1", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaValue", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaInstanceType", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="WriteMask", type="long", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UserWriteMask", type="long", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="AccessLevel", type="int", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="userAccessLevel", type="int", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="EventNotifier", type="int", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="HasCondition", type="boolean", defaultValue="false", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="Historizing", type="boolean", defaultValue="false", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="Facets", type="BFacets", defaultValue="BFacets.NULL", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="IsProperty", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="IsEventType", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="HasAddableDescendant", type="boolean", defaultValue="false", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="test", flags=16), @NiagaraAction(name="showDetail", flags=16), @NiagaraAction(name="hideDetail", flags=16), @NiagaraAction(name="dumpHistory", flags=16), @NiagaraAction(name="subscribeForEvents", flags=16)})
public class BOpcUaNodeLearnEntry
extends BComponent
implements BINDiscoveryLeaf,
BINDiscoveryIcon,
BINDiscoveryObject {
    public static final Property UaNodeName = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", null);
    public static final Property UaDisplayName = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property UaNodeId = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property NameSpaceUri = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property ArrayDimension = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property ArrayIndex = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property NodeClass = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property Description = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property TypeSpec = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property UaDataType = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property UaDataTypeIdentifier = BOpcUaNodeLearnEntry.newProperty((int)5, (int)-1, (BFacets)SfUtil.incl());
    public static final Property UaValue = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property UaInstanceType = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property WriteMask = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    public static final Property UserWriteMask = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    public static final Property AccessLevel = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    public static final Property userAccessLevel = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    public static final Property EventNotifier = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    public static final Property HasCondition = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, (BFacets)SfUtil.incl());
    public static final Property Historizing = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, (BFacets)SfUtil.incl());
    public static final Property Facets = BOpcUaNodeLearnEntry.newProperty((int)5, (BValue)BFacets.NULL, (BFacets)SfUtil.incl());
    public static final Property IsProperty = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    public static final Property IsEventType = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    public static final Property HasAddableDescendant = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    public static final Action test = BOpcUaNodeLearnEntry.newAction((int)16, null);
    public static final Action showDetail = BOpcUaNodeLearnEntry.newAction((int)16, null);
    public static final Action hideDetail = BOpcUaNodeLearnEntry.newAction((int)16, null);
    public static final Action dumpHistory = BOpcUaNodeLearnEntry.newAction((int)16, null);
    public static final Action subscribeForEvents = BOpcUaNodeLearnEntry.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BOpcUaNodeLearnEntry.class);
    private static int level = 0;
    public static final Logger logger = Logger.getLogger("opcUaClient.point");
    private static final BIcon NC_OBJECT_ICON = BIcon.std((String)"folder.png");
    private static final BIcon NC_METHOD_ICON = BIcon.std((String)"gears.png");
    private static final BIcon NUMERIC_ICON = BIcon.std((String)"control/numericPoint.png");
    private static final BIcon BOOLEAN_ICON = BIcon.std((String)"control/booleanPoint.png");
    private static final BIcon ENUM_ICON = BIcon.std((String)"control/enumPoint.png");
    private static final BIcon STRING_ICON = BIcon.std((String)"control/stringPoint.png");
    private static final BIcon HISTORY_ICON = BIcon.std((String)"badges/history.png");
    private static final String lBracket = "\\[";
    private static final TypeInfo[] NO_TYPES = new TypeInfo[0];
    private static final TypeInfo[] RD_NUMERIC_TYPE = new TypeInfo[]{BNumericPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_BOOLEAN_TYPE = new TypeInfo[]{BBooleanPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_ENUM_TYPE = new TypeInfo[]{BEnumPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_STRING_TYPE = new TypeInfo[]{BStringPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_NUMERIC_TYPE = new TypeInfo[]{BNumericWritable.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_BOOLEAN_TYPE = new TypeInfo[]{BBooleanWritable.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_ENUM_TYPE = new TypeInfo[]{BEnumWritable.TYPE.getTypeInfo(), BEnumPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_STRING_TYPE = new TypeInfo[]{BStringWritable.TYPE.getTypeInfo(), BStringPoint.TYPE.getTypeInfo()};
    private static int NODECLASS = 0;
    private static int BROWSENAME = 1;
    private static int VALUE = 3;
    private static int DISPLAYNAME = 2;
    private static int DATATYPE = 4;
    private static int DESCRIPTION = 5;
    private static int WRITEMASK = 6;
    private static int USERWRITEMASK = 7;
    private static int ACCESSLEVEL = 8;
    private static int USERACCESSLEVEL = 9;
    private static int EVENTNOTIFIER = 10;
    private static int HISTORIZING = 11;

    public String getUaNodeName() {
        return this.getString(UaNodeName);
    }

    public void setUaNodeName(String v) {
        this.setString(UaNodeName, v, null);
    }

    public String getUaDisplayName() {
        return this.getString(UaDisplayName);
    }

    public void setUaDisplayName(String v) {
        this.setString(UaDisplayName, v, null);
    }

    public String getUaNodeId() {
        return this.getString(UaNodeId);
    }

    public void setUaNodeId(String v) {
        this.setString(UaNodeId, v, null);
    }

    public String getNameSpaceUri() {
        return this.getString(NameSpaceUri);
    }

    public void setNameSpaceUri(String v) {
        this.setString(NameSpaceUri, v, null);
    }

    public String getArrayDimension() {
        return this.getString(ArrayDimension);
    }

    public void setArrayDimension(String v) {
        this.setString(ArrayDimension, v, null);
    }

    public String getArrayIndex() {
        return this.getString(ArrayIndex);
    }

    public void setArrayIndex(String v) {
        this.setString(ArrayIndex, v, null);
    }

    public String getNodeClass() {
        return this.getString(NodeClass);
    }

    public void setNodeClass(String v) {
        this.setString(NodeClass, v, null);
    }

    public String getDescription() {
        return this.getString(Description);
    }

    public void setDescription(String v) {
        this.setString(Description, v, null);
    }

    public String getTypeSpec() {
        return this.getString(TypeSpec);
    }

    public void setTypeSpec(String v) {
        this.setString(TypeSpec, v, null);
    }

    public String getUaDataType() {
        return this.getString(UaDataType);
    }

    public void setUaDataType(String v) {
        this.setString(UaDataType, v, null);
    }

    public long getUaDataTypeIdentifier() {
        return this.getLong(UaDataTypeIdentifier);
    }

    public void setUaDataTypeIdentifier(long v) {
        this.setLong(UaDataTypeIdentifier, v, null);
    }

    public String getUaValue() {
        return this.getString(UaValue);
    }

    public void setUaValue(String v) {
        this.setString(UaValue, v, null);
    }

    public String getUaInstanceType() {
        return this.getString(UaInstanceType);
    }

    public void setUaInstanceType(String v) {
        this.setString(UaInstanceType, v, null);
    }

    public long getWriteMask() {
        return this.getLong(WriteMask);
    }

    public void setWriteMask(long v) {
        this.setLong(WriteMask, v, null);
    }

    public long getUserWriteMask() {
        return this.getLong(UserWriteMask);
    }

    public void setUserWriteMask(long v) {
        this.setLong(UserWriteMask, v, null);
    }

    public int getAccessLevel() {
        return this.getInt(AccessLevel);
    }

    public void setAccessLevel(int v) {
        this.setInt(AccessLevel, v, null);
    }

    public int getUserAccessLevel() {
        return this.getInt(userAccessLevel);
    }

    public void setUserAccessLevel(int v) {
        this.setInt(userAccessLevel, v, null);
    }

    public int getEventNotifier() {
        return this.getInt(EventNotifier);
    }

    public void setEventNotifier(int v) {
        this.setInt(EventNotifier, v, null);
    }

    public boolean getHasCondition() {
        return this.getBoolean(HasCondition);
    }

    public void setHasCondition(boolean v) {
        this.setBoolean(HasCondition, v, null);
    }

    public boolean getHistorizing() {
        return this.getBoolean(Historizing);
    }

    public void setHistorizing(boolean v) {
        this.setBoolean(Historizing, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(Facets);
    }

    public void setFacets(BFacets v) {
        this.set(Facets, (BValue)v, null);
    }

    public boolean getIsProperty() {
        return this.getBoolean(IsProperty);
    }

    public void setIsProperty(boolean v) {
        this.setBoolean(IsProperty, v, null);
    }

    public boolean getIsEventType() {
        return this.getBoolean(IsEventType);
    }

    public void setIsEventType(boolean v) {
        this.setBoolean(IsEventType, v, null);
    }

    public boolean getHasAddableDescendant() {
        return this.getBoolean(HasAddableDescendant);
    }

    public void setHasAddableDescendant(boolean v) {
        this.setBoolean(HasAddableDescendant, v, null);
    }

    public void test() {
        this.invoke(test, null, null);
    }

    public void showDetail() {
        this.invoke(showDetail, null, null);
    }

    public void hideDetail() {
        this.invoke(hideDetail, null, null);
    }

    public void dumpHistory() {
        this.invoke(dumpHistory, null, null);
    }

    public void subscribeForEvents() {
        this.invoke(subscribeForEvents, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOpcUaNodeLearnEntry() {
    }

    public BOpcUaNodeLearnEntry(String nodeName, String nodeId, String nodeClass, String uaDataType, BTypeSpec typeSpec) {
        this.setUaNodeName(nodeName);
        this.setUaDisplayName(nodeName);
        this.setUaNodeId(nodeId);
        this.setNodeClass(nodeClass);
        this.setUaDataType(uaDataType);
        if (!typeSpec.isNull()) {
            this.setTypeSpec(typeSpec.toString());
        }
    }

    public static BOpcUaNodeLearnEntry make(AddressSpace addressSpace, ReferenceDescription reference, NodeId thisNodeId, UaClient client) {
        try {
            BOpcUaNodeLearnEntry learnEntry = AccessController.doPrivileged(() -> {
                BOpcUaNodeLearnEntry retEntry = new BOpcUaNodeLearnEntry();
                boolean isProperty = reference.getReferenceTypeId().equals((Object)Identifiers.HasProperty);
                UnsignedInteger[] nodeAttriBs = new UnsignedInteger[]{Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName, Attributes.Value, Attributes.DataType, Attributes.Description, Attributes.WriteMask, Attributes.UserWriteMask, Attributes.AccessLevel, Attributes.UserAccessLevel, Attributes.EventNotifier, Attributes.Historizing};
                DataValue[] arrayOfNodes = null;
                boolean hasCondition = false;
                try {
                    List nodeRefDes = addressSpace.browse(thisNodeId, BrowseDirection.Forward, Identifiers.HasCondition, true, new NodeClass[]{com.prosysopc.ua.stack.core.NodeClass.Unspecified});
                    for (ReferenceDescription nodeRef : nodeRefDes) {
                        hasCondition = nodeRef.getReferenceTypeId().equals((Object)Identifiers.HasCondition);
                    }
                }
                catch (Exception stsEx) {
                    logger.fine(stsEx.getMessage());
                }
                try {
                    arrayOfNodes = client.readAttributes(thisNodeId, nodeAttriBs);
                }
                catch (ServiceException sEx) {
                    logger.info(sEx.getMessage());
                    return retEntry;
                }
                try {
                    Object oValue;
                    String nodeName = arrayOfNodes[BROWSENAME].getStatusCode().isNotBad() && arrayOfNodes[BROWSENAME].getValue() != null ? OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[BROWSENAME]) : reference.getDisplayName().getText();
                    DataValue dataValue = arrayOfNodes[VALUE];
                    String displayName = arrayOfNodes[DISPLAYNAME].getStatusCode().isNotBad() && arrayOfNodes[DISPLAYNAME].getValue() != null ? OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[DISPLAYNAME]) : reference.getDisplayName().getText();
                    String dataType = "";
                    long dtIdentifier = -1L;
                    try {
                        DataValue dtUaNode;
                        Optional<DataValue> nodeOptional = OpcUaClientUtil.getNodeDataTypeNode(arrayOfNodes[DATATYPE]);
                        if (nodeOptional.isPresent() && (dtUaNode = nodeOptional.get()) != null && dtUaNode.getValue() != null && dtUaNode.getValue().getValue() != null) {
                            NodeId nodeId = (NodeId)dtUaNode.getValue().getValue();
                            dataType = ((Class)BuiltinsMap.ID_CLASS_MAP.getRight((Object)nodeId)).getSimpleName();
                            if (nodeId.getValue() != null) {
                                dtIdentifier = Long.valueOf(nodeId.getValue().toString());
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.fine("Error while fetching dataType and Identifier details for " + displayName + ". Error:" + e.getLocalizedMessage());
                    }
                    Object dataValueValue = OpcUaClientUtil.getDataValueValue(dataValue);
                    String description = OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[DESCRIPTION]);
                    BTypeSpec typeSpec = OpcUaClientUtil.getTypeSpec(dataValue.getValue(), dataType);
                    DataValue wmdv = arrayOfNodes[WRITEMASK];
                    DataValue uwmdv = arrayOfNodes[USERWRITEMASK];
                    DataValue al = arrayOfNodes[ACCESSLEVEL];
                    DataValue ual = arrayOfNodes[USERACCESSLEVEL];
                    DataValue eventNotifier = arrayOfNodes[EVENTNOTIFIER];
                    DataValue historizing = arrayOfNodes[HISTORIZING];
                    retEntry.setUaNodeName(nodeName);
                    retEntry.setUaDisplayName(displayName);
                    retEntry.setUaNodeId(thisNodeId.toString());
                    retEntry.setNameSpaceUri(addressSpace.getNamespaceTable().toExpandedNodeId(thisNodeId).getNamespaceUri());
                    retEntry.setNodeClass(arrayOfNodes[NODECLASS].getStatusCode().isNotBad() ? com.prosysopc.ua.stack.core.NodeClass.valueOf((int)arrayOfNodes[NODECLASS].getValue().toNumber().intValue()).toString() : com.prosysopc.ua.stack.core.NodeClass.valueOf((int)reference.getNodeClass().getValue()).toString());
                    retEntry.setUaDataType(dataType);
                    retEntry.setUaDataTypeIdentifier(dtIdentifier);
                    retEntry.setTypeSpec(typeSpec.isNull() ? "" : typeSpec.toString());
                    retEntry.setDescription(description);
                    retEntry.setIsProperty(isProperty);
                    retEntry.setIsEventType(false);
                    if (!wmdv.isNull()) {
                        oValue = wmdv.getValue().getValue();
                        retEntry.setWriteMask(((UnsignedInteger)oValue).getValue());
                    }
                    if (!uwmdv.isNull()) {
                        oValue = uwmdv.getValue().getValue();
                        retEntry.setUserWriteMask(((UnsignedInteger)oValue).getValue());
                    }
                    oValue = al.isNull() ? UnsignedByte.valueOf((int)0) : al.getValue().getValue();
                    int accessLvl = ((UnsignedByte)oValue).getValue();
                    retEntry.setAccessLevel(accessLvl);
                    oValue = ual.isNull() ? UnsignedByte.valueOf((int)0) : ual.getValue().getValue();
                    retEntry.setUserAccessLevel(((UnsignedByte)oValue).getValue());
                    oValue = !historizing.isNull() && historizing.getValue().booleanValue();
                    String userBit = Integer.toBinaryString(accessLvl);
                    boolean hasHistory = userBit.length() > 2 && userBit.charAt(2) == '1' || userBit.length() > 3 && userBit.charAt(3) == '1' || (Boolean)oValue != false;
                    retEntry.setHistorizing(hasHistory);
                    oValue = eventNotifier.isNull() ? -1 : eventNotifier.getValue().intValue();
                    retEntry.setEventNotifier((Integer)oValue);
                    retEntry.setHasCondition(hasCondition);
                    if (dataValueValue != null) {
                        retEntry.setUaValue(dataValueValue.toString());
                        retEntry.setUaInstanceType(dataValue.getValue().getCompositeClass().getSimpleName());
                    }
                    if (!dataValue.isNull() && dataValue.getValue().isArray()) {
                        retEntry.initArrayInfo(dataValue);
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Error instantiating BOpcUaNodeLearnEntry: ", ex);
                }
                return retEntry;
            });
            return learnEntry;
        }
        catch (Exception e) {
            logger.fine("While error instantiating BOpcUaNodeLearnEntry : " + e.getMessage());
            return null;
        }
    }

    public BOpcUaLearnBase toDiscoveryTree(boolean showAddableOnly) {
        BOpcUaLearnBase root = BOpcUaLearnBase.make(this);
        this.buildDiscoveryTree(this, root, showAddableOnly);
        return root;
    }

    private void buildDiscoveryTree(BOpcUaNodeLearnEntry entry, BOpcUaLearnBase root, boolean showAddableOnly) {
        for (BOpcUaNodeLearnEntry pointEntry : (BOpcUaNodeLearnEntry[])entry.getChildren(BOpcUaNodeLearnEntry.class)) {
            if (pointEntry.getIsProperty() || pointEntry.getIsEventType() || !"Method".equals(pointEntry.getNodeClass()) && pointEntry.getTypeSpec().isEmpty() && showAddableOnly && !pointEntry.getHasAddableDescendant()) continue;
            Property prop = root.add("le?", (BValue)BOpcUaLearnBase.make(pointEntry));
            BOpcUaLearnBase addChild = (BOpcUaLearnBase)root.get(prop);
            ++level;
            this.buildDiscoveryTree(pointEntry, addChild, showAddableOnly);
            --level;
        }
    }

    public String getDefaultName() {
        return this.getUaNodeId();
    }

    public void doDumpHistory() {
        if (!this.getHistorizing()) {
            logger.info(this.getUaNodeName() + " is not Historizing");
        } else {
            BOpcUaDevice device = this.getDevice();
            UaClient client = device.uaClient;
            NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
            try {
                DataValue[] result;
                for (DataValue dataValue : result = client.historyReadRaw(nodeId, DateTime.MIN_VALUE, DateTime.currentTime(), UnsignedInteger.MAX_VALUE, Boolean.valueOf(true), null, TimestampsToReturn.Source)) {
                    System.out.println(dataValue);
                }
            }
            catch (Exception e) {
                logger.fine("While dumping History :" + e.getMessage());
            }
        }
    }

    public void doShowDetail() {
        for (Property property : this.getFrozenPropertiesArray()) {
            this.setFlags((Slot)property, this.getFlags((Slot)property) & 0xFFFFFFFB);
        }
    }

    public void doHideDetail() {
        for (Property property : this.getFrozenPropertiesArray()) {
            this.setFlags((Slot)property, this.getFlags((Slot)property) | 4);
        }
    }

    public void added(Property property, Context context) {
        BValue bValue = this.get(property);
        if (bValue instanceof BOpcUaNodeLearnEntry && "EnumStrings".equals(property.getName())) {
            this.setTypeSpec(BTypeSpec.make((Type)BEnum.TYPE).toString(null));
        }
        super.added(property, context);
    }

    public void initArrayInfo(DataValue dataValue) {
        try {
            AccessController.doPrivileged(() -> {
                if (dataValue.isNull()) {
                    System.out.println("dataValue is null!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    return null;
                }
                if (!dataValue.getValue().isArray()) {
                    return null;
                }
                int[] arrayDimensions = dataValue.getValue().getArrayDimensions();
                int dimension = dataValue.getValue().getDimension();
                if (arrayDimensions != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append('[');
                    for (int i = 0; i < arrayDimensions.length; ++i) {
                        sb.append(arrayDimensions[i]);
                        if (i + 1 >= arrayDimensions.length) continue;
                        sb.append(",");
                    }
                    sb.append(']');
                    this.setArrayDimension(sb.toString());
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.fine("while initiating ArrayInfo :" + e.getMessage());
        }
    }

    public boolean isEventNotifier(EventNotifierType value) {
        int enValue = this.getEventNotifier();
        if (enValue <= 0) {
            return false;
        }
        EventNotifierType type = null;
        for (EventNotifierType.Options field : EventNotifierType.Options.values()) {
            if (field.getBitPosition() != enValue) continue;
            type = EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{field});
            break;
        }
        if (type == null) {
            return false;
        }
        return type.containsAll((AbstractOptionSetDataType)value);
    }

    public boolean isEventSubscribable() {
        return this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.SubscribeToEvents}));
    }

    public boolean isArray() {
        return !this.getArrayDimension().isEmpty();
    }

    public long[] getArrayDimensions() {
        String s = this.getArrayDimension();
        int il = s.indexOf(91);
        int ir = s.indexOf(93);
        if (il >= 0 && ir > il) {
            s = s.substring(il + 1, ir);
        }
        String[] split = s.split(",");
        long[] dimensions = new long[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                dimensions[i] = Long.parseLong(split[i].trim());
                continue;
            }
            catch (Exception e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        return dimensions;
    }

    public void initHasAddableDescendant() {
        boolean childAddable;
        boolean addableDescendant = childAddable = this.isAddable();
        for (BComplex complex = this.getParent(); complex != null && complex instanceof BOpcUaNodeLearnEntry; complex = complex.getParent()) {
            BOpcUaNodeLearnEntry thisEntry = (BOpcUaNodeLearnEntry)complex;
            if (childAddable) {
                thisEntry.setHasAddableDescendant(true);
            }
            if (addableDescendant) continue;
            addableDescendant = childAddable = thisEntry.isAddable();
        }
    }

    public boolean isAddable() {
        logger.fine("OPC UA Client discovered point: " + this.getUaNodeName() + " - NodeClass:" + this.getNodeClass() + ", IsProperty:" + this.getIsProperty() + ", TypeSpec:" + this.getTypeSpec() + ", EventType:" + this.getIsEventType() + ".");
        return "Variable".equals(this.getNodeClass()) && !this.getIsProperty() && !this.getTypeSpec().isEmpty() && !this.getIsEventType();
    }

    public void doSubscribeForEvents() {
        try {
            NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
            BOpcUaDevice device = this.getDevice();
            if (device == null) {
                return;
            }
            BOpcUaClientAlarmDeviceExt eventListener = device.getAlarmExt();
            eventListener.addMonitorEvent(nodeId);
        }
        catch (Exception e) {
            logger.info("Error for the action SubscribeForEvent:" + e.getMessage());
        }
    }

    public void doTest() {
        block20: {
            try {
                NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
                Object value1 = nodeId.getValue();
                BOpcUaDevice device = this.getDevice();
                if (device == null) {
                    logger.finest("BOpcUaDevice not found");
                    break block20;
                }
                logger.finest("nodeId.getValue().class = " + value1.getClass().getName());
                logger.finest("NodeId = " + nodeId);
                logger.finest("NodeId.getValue() = " + value1);
                UaClient uaClient = device.uaClient;
                AddressSpace addressSpace = uaClient.getAddressSpace();
                UaNode node = addressSpace.getNode(nodeId);
                NodeClass nodeClass = node.getNodeClass();
                logger.finest("NodeClass = " + nodeClass);
                logger.finest("node = " + node);
                NodeAttributes attributes = node.getAttributes();
                logger.finest("attributes = " + attributes);
                try {
                    DataValue dataValue = node.readAttribute(Attributes.Value);
                    if (dataValue != null) {
                        UaProperty[] variantValue = dataValue.getValue();
                        Object value = variantValue.getValue();
                        if (value instanceof EUInformation) {
                            EUInformation eui = (EUInformation)value;
                            logger.finest(eui.getDisplayName().toString() + ", UnitId = " + eui.getUnitId());
                        }
                        logger.finest("dataValue = " + variantValue.toString(true));
                        if (variantValue.getCompositeClass() != null) {
                            logger.finest("dataValue.type = " + variantValue.getCompositeClass().getSimpleName());
                        }
                    } else {
                        logger.info("No data value");
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
                UaProperty[] properties = node.getProperties();
                if (properties != null) {
                    for (UaProperty uaProperty : properties) {
                        String propName = uaProperty.getDisplayName().getText();
                        Variant value = uaProperty.getValue().getValue();
                        logger.info("(" + propName + "=" + value + ")");
                    }
                } else {
                    logger.info("No properties defined");
                }
                BFacets pointFacet = this.makePointFacets();
                this.setFacets(pointFacet);
                logger.info("pointFacets = " + pointFacet);
                logger.info("isArray = " + this.isArray());
                StringBuilder sb = new StringBuilder();
                for (long l : this.getArrayDimensions()) {
                    sb.append('[');
                    if (l >= 0L) {
                        sb.append(l);
                    }
                    sb.append(']');
                }
                logger.info("ArrayDimensions = " + sb.toString());
                int accessLevel = this.getAccessLevel();
                AccessLevelType accessLevelType = null;
                for (AccessLevelType.Options field : AccessLevelType.Options.values()) {
                    if (field.getBitPosition() != accessLevel) continue;
                    accessLevelType = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{field});
                    break;
                }
                if (accessLevelType != null) {
                    logger.info("AccessLevel = " + accessLevelType.toString());
                } else {
                    logger.info("AccessLevel = null");
                }
                AttributeWriteMask writeMasks = null;
                for (AttributeWriteMask.Options field : AttributeWriteMask.Options.values()) {
                    if (field.getBitPosition() != (int)this.getWriteMask()) continue;
                    writeMasks = AttributeWriteMask.of((AttributeWriteMask.Options[])new AttributeWriteMask.Options[]{field});
                    break;
                }
                if (writeMasks != null) {
                    logger.info("WriteMask = " + writeMasks);
                } else {
                    logger.info("WriteMask = null");
                }
                logger.info("EventNotifier = " + this.getEventNotifier());
                logger.info("isEventNotifierSubscribeToEvents = " + this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.SubscribeToEvents})));
                logger.info("isEventNotifierHistoryRead  = " + this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.HistoryRead})));
                logger.info("isEventNotifierHistoryWrite = " + this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.HistoryWrite})));
            }
            catch (Exception e) {
                logger.fine("Exception while doing test :" + e.getMessage());
            }
        }
    }

    BOpcUaDevice getDevice() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BOpcUaDevice)) continue;
            return (BOpcUaDevice)parent;
        }
        return null;
    }

    public TypeInfo[] getValidDatabaseTypes() {
        String spec;
        AccessLevelType levels = null;
        for (AccessLevelType.Options field : AccessLevelType.Options.values()) {
            if (field.getBitPosition() != this.getAccessLevel()) continue;
            levels = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{field});
            break;
        }
        boolean canWrite = false;
        if (levels != null) {
            canWrite = levels.contains(new OptionSpecification[]{AccessLevelType.Options.CurrentWrite});
        }
        if ((spec = this.getTypeSpec()).isEmpty()) {
            return NO_TYPES;
        }
        TypeInfo typeInfo = BTypeSpec.make((String)spec).getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            return canWrite ? RD_WR_NUMERIC_TYPE : RD_NUMERIC_TYPE;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            return canWrite ? RD_WR_BOOLEAN_TYPE : RD_BOOLEAN_TYPE;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            return canWrite ? RD_WR_ENUM_TYPE : RD_ENUM_TYPE;
        }
        if (typeInfo.is(BString.TYPE)) {
            return canWrite ? RD_WR_STRING_TYPE : RD_STRING_TYPE;
        }
        return NO_TYPES;
    }

    public void updateTarget(BComponent target) {
    }

    public boolean isExisting(BComponent component) {
        return false;
    }

    public String getDiscoveryName() {
        return SlotPath.escape((String)this.getUaNodeName());
    }

    public boolean isNumeric() {
        String specType = this.getTypeSpec();
        if ("".equals(specType)) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)specType);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BNumber.TYPE);
    }

    public boolean isBoolean() {
        String specType = this.getTypeSpec();
        if ("".equals(specType)) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)specType);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BBoolean.TYPE);
    }

    public BIcon getDiscoveryIcon() {
        String specType = this.getTypeSpec();
        if ("".equals(specType)) {
            if ("Method".equals(this.getNodeClass())) {
                return NC_METHOD_ICON;
            }
            return null;
        }
        BTypeSpec ts = BTypeSpec.make((String)specType);
        if (ts.isNull()) {
            return null;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)NUMERIC_ICON, (BIcon)HISTORY_ICON);
            }
            return NUMERIC_ICON;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)BOOLEAN_ICON, (BIcon)HISTORY_ICON);
            }
            return BOOLEAN_ICON;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)ENUM_ICON, (BIcon)HISTORY_ICON);
            }
            return ENUM_ICON;
        }
        if (typeInfo.is(BString.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)STRING_ICON, (BIcon)HISTORY_ICON);
            }
            return STRING_ICON;
        }
        return null;
    }

    public void defaultTargetUpdate(BComponent target) {
    }

    public void updateFacets() {
        this.setFacets(this.makePointFacets());
    }

    public BFacets makePointFacets() {
        BTypeSpec ts;
        BFacets rtnFacets = BFacets.DEFAULT;
        String typeSpec = this.getTypeSpec();
        if (!typeSpec.equals("") && !(ts = BTypeSpec.make((String)typeSpec)).isNull()) {
            TypeInfo typeInfo = ts.getTypeInfo();
            if (this.hasEnumStringProperty()) {
                rtnFacets = this.makeEnumFacets();
            }
            if (this.hasTrueStateProperty()) {
                rtnFacets = this.makeBooleanFacets();
            } else if (typeInfo.is(BNumber.TYPE)) {
                rtnFacets = this.makeNumericFacets();
            }
        }
        return rtnFacets;
    }

    public boolean hasEnumStringProperty() {
        BValue enumStrings = this.get("EnumStrings");
        return enumStrings != null;
    }

    public boolean hasTrueStateProperty() {
        return this.get("TrueState") != null && this.get("FalseState") != null;
    }

    public BFacets makeEnumFacets() {
        try {
            BOpcUaNodeLearnEntry enumStrings = (BOpcUaNodeLearnEntry)this.get("EnumStrings");
            String values = enumStrings.getUaValue();
            String[] split = values.split(",");
            BEnumRange enumRange = BEnumRange.make((String[])split);
            return BFacets.makeEnum((BEnumRange)enumRange);
        }
        catch (Exception e) {
            return BFacets.makeEnum();
        }
    }

    public BFacets makeBooleanFacets() {
        try {
            BOpcUaNodeLearnEntry trueState = (BOpcUaNodeLearnEntry)this.get("TrueState");
            String trueText = trueState.getUaValue();
            BOpcUaNodeLearnEntry falseState = (BOpcUaNodeLearnEntry)this.get("FalseState");
            String falseText = falseState.getUaValue();
            return BFacets.makeBoolean((String)trueText, (String)falseText);
        }
        catch (Exception e) {
            return BFacets.makeBoolean();
        }
    }

    public BFacets makeNumericFacets() {
        try {
            BFacets rtnFacets = this.makeNumericFacets(this.getUaInstanceType());
            BOpcUaNodeLearnEntry[] children = (BOpcUaNodeLearnEntry[])this.getChildren(BOpcUaNodeLearnEntry.class);
            if (children.length == 0) {
                return rtnFacets;
            }
            BDouble maxValue = (BDouble)rtnFacets.get("max", (BObject)BDouble.POSITIVE_INFINITY);
            BDouble minValue = (BDouble)rtnFacets.get("min", (BObject)BDouble.NEGATIVE_INFINITY);
            BUnit units = (BUnit)rtnFacets.get("units", (BObject)BUnit.DEFAULT);
            int precision = rtnFacets.geti("precision", 2);
            for (BOpcUaNodeLearnEntry child : children) {
                String uaValue;
                if (child.getUaDataType().equals("Range")) {
                    String rangeValue = child.getUaValue();
                    String[] values = rangeValue.split(",");
                    if (values.length != 2) continue;
                    minValue = BDouble.make((String)values[0]);
                    maxValue = BDouble.make((String)values[1]);
                    continue;
                }
                if (!child.getUaDataType().equals("EUInformation") || !(uaValue = child.getUaValue()).startsWith("() ")) continue;
                uaValue = uaValue.substring(3);
                try {
                    units = BUnit.getUnit((String)uaValue);
                }
                catch (Exception e) {
                    logger.info(e.getLocalizedMessage() + " for: " + this.getUaNodeName());
                }
            }
            return BFacets.makeNumeric((BUnit)units, (int)precision, (double)minValue.getDouble(), (double)maxValue.getDouble());
        }
        catch (Exception e) {
            return BFacets.makeNumeric();
        }
    }

    private BFacets makeNumericFacets(String uaInstanceType) {
        switch (uaInstanceType) {
            case "SByte": 
            case "Byte": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-128.0, (double)127.0);
            }
            case "UByte": 
            case "UnsignedByte": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)0.0, (double)255.0);
            }
            case "Int16": 
            case "Short": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-32768.0, (double)32767.0);
            }
            case "UInt16": 
            case "UnsignedShort": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedShort.L_MIN_VALUE, (double)UnsignedShort.L_MAX_VALUE);
            }
            case "Int32": 
            case "Integer": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-2.147483648E9, (double)2.147483647E9);
            }
            case "UInt32": 
            case "UInteger": 
            case "UnsignedInteger": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedInteger.MIN_VALUE.doubleValue(), (double)UnsignedInteger.MAX_VALUE.doubleValue());
            }
            case "Int64": 
            case "Long": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-9.223372036854776E18, (double)9.223372036854776E18);
            }
            case "UInt64": 
            case "ULong": 
            case "UnsignedLong": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedLong.MIN_VALUE.doubleValue(), (double)UnsignedLong.MAX_VALUE.doubleValue());
            }
            case "Float": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)2, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
            }
        }
        return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)2, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
    }

    public String toString(Context cx) {
        return this.getUaValue();
    }

    public BIcon getIcon() {
        if (this.getNodeClass().equals("Object")) {
            return NC_OBJECT_ICON;
        }
        if (this.getNodeClass().equals("Variable")) {
            return this.getDiscoveryIcon();
        }
        if (this.getNodeClass().equals("Method")) {
            return NC_METHOD_ICON;
        }
        return super.getIcon();
    }
}

