/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Argument;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaCore.BUaArgument;
import com.tridium.opcUaCore.BUaArgumentVector;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="String", defaultValue=""), @NiagaraProperty(name="inputArgs", type="BUaArgumentVector", defaultValue="new BUaArgumentVector()"), @NiagaraProperty(name="results", type="BUaArgumentVector", defaultValue="new BUaArgumentVector()")})
@NiagaraAction(name="learnDetail", flags=20)
public class BOpcUaMethodProxyExt
extends BOpcUaClientProxyExt {
    public static final Property objectId = BOpcUaMethodProxyExt.newProperty((int)0, (String)"", null);
    public static final Property inputArgs = BOpcUaMethodProxyExt.newProperty((int)0, (BValue)new BUaArgumentVector(), null);
    public static final Property results = BOpcUaMethodProxyExt.newProperty((int)0, (BValue)new BUaArgumentVector(), null);
    public static final Action learnDetail = BOpcUaMethodProxyExt.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BOpcUaMethodProxyExt.class);
    public static final String LEARNED = "learned";
    public static final Logger logger = Logger.getLogger("opcUaClient.point");

    public String getObjectId() {
        return this.getString(objectId);
    }

    public void setObjectId(String v) {
        this.setString(objectId, v, null);
    }

    public BUaArgumentVector getInputArgs() {
        return (BUaArgumentVector)this.get(inputArgs);
    }

    public void setInputArgs(BUaArgumentVector v) {
        this.set(inputArgs, (BValue)v, null);
    }

    public BUaArgumentVector getResults() {
        return (BUaArgumentVector)this.get(results);
    }

    public void setResults(BUaArgumentVector v) {
        this.set(results, (BValue)v, null);
    }

    public void learnDetail() {
        this.invoke(learnDetail, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || cx == null || cx != Context.decoding) {
            // empty if block
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        BOpcUaDevice device = this.getBOpcUaClientDevice();
        if (device != null) {
            return device.postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    public void doLearnDetail() {
        UaClient uaClient;
        BOpcUaDevice device = this.getBOpcUaClientDevice();
        if (device != null && (uaClient = device.uaClient).isConnected()) {
            AddressSpace addressSpace = uaClient.getAddressSpace();
            try {
                UaNode node = OpcUaClientUtil.getAddressspaceNode(addressSpace, NodeId.parseNodeId((String)this.getUaNodeId()));
                if (node instanceof UaMethod) {
                    BUaArgument argument;
                    UaMethod method = (UaMethod)node;
                    Boolean executable = method.getExecutable();
                    Argument[] inputArguments = method.getInputArguments();
                    Argument[] outputArguments = method.getOutputArguments();
                    this.getInputArgs().removeAll();
                    this.getResults().removeAll();
                    this.getInputArgs().add(LEARNED, (BValue)BBoolean.make((boolean)true), 5);
                    for (Argument input : inputArguments) {
                        argument = OpcUaClientUtil.makeUaArgument(input);
                        this.getInputArgs().add("arg?", (BValue)argument, 1);
                    }
                    for (Argument output : outputArguments) {
                        argument = OpcUaClientUtil.makeUaArgument(output);
                        this.getResults().add("result?", (BValue)argument, 1);
                    }
                }
            }
            catch (MethodArgumentException e) {
                logger.info("Error in the action Learn Details:" + e.getMessage());
            }
        }
    }

    public BVector makeDefaultInputArgs() {
        BVector vector = new BVector();
        this.lease(2);
        int index = 0;
        for (BUaArgument argument : (BUaArgument[])this.getInputArgs().getChildren(BUaArgument.class)) {
            String description = argument.getDescription();
            int length = description.length();
            BFacets editFacet = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)(length > 64 ? 64 : length)));
            BObject instance = argument.getArgType().getInstance();
            vector.add("desc" + index, (BValue)BString.make((String)description), 1, editFacet, null);
            vector.add("value" + index, instance.asValue());
            ++index;
        }
        return vector;
    }

    @Override
    public void readSubscribed(Context cx) throws Exception {
        if (this.getInputArgs().get(LEARNED) == null) {
            this.learnDetail();
        }
        this.readOk(this.getReadValue());
    }

    @Override
    public void readUnsubscribed(Context cx) throws Exception {
    }

    @Override
    public void doPoll() {
    }

    protected void convertDeviceToProxy(BStatusValue deviceValue, BStatusValue proxyValue) {
        proxyValue.copyFrom((BComplex)deviceValue);
    }

    @Override
    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }
}

