/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.tridium.ndriver.discover.BINDiscoveryIcon;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaClient.history.BImportHistoryExt;
import com.tridium.opcUaClient.history.BNumericImportHistoryExt;
import com.tridium.opcUaClient.point.BOpcUaClientPointFolder;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.point.BOpcUaMethod;
import com.tridium.opcUaClient.point.BOpcUaMethodProxyExt;
import com.tridium.opcUaClient.point.BOpcUaNodeLearnEntry;
import com.tridium.opcUaClient.point.BOpcUaObject;
import com.tridium.opcUaClient.util.MatrixUtil;
import com.tridium.opcUaCore.BUaAccessLevel;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.history.BCapacity;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="uaNodeName", type="String", defaultValue="", flags=5), @NiagaraProperty(name="uaDisplayName", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="uaNodeId", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="nameSpaceUri", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="accessLevel", type="BUaAccessLevel", defaultValue="BUaAccessLevel.DEFAULT", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="arrayDimension", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="arrayIndex", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="uaDataType", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="uaDataTypeIdentifier", type="long", defaultValue="-1", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="historizing", type="boolean", defaultValue="false", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.NULL", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="nodeClass", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="typeSpec", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")})})
public class BOpcUaLearnBase
extends BComponent
implements BINDiscoveryLeaf,
BINDiscoveryIcon,
BINDiscoveryObject {
    public static final Property uaNodeName = BOpcUaLearnBase.newProperty((int)5, (String)"", null);
    public static final Property uaDisplayName = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property uaNodeId = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property nameSpaceUri = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property accessLevel = BOpcUaLearnBase.newProperty((int)5, (BValue)BUaAccessLevel.DEFAULT, (BFacets)SfUtil.incl());
    public static final Property arrayDimension = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property arrayIndex = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property uaDataType = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property uaDataTypeIdentifier = BOpcUaLearnBase.newProperty((int)5, (int)-1, (BFacets)SfUtil.incl());
    public static final Property historizing = BOpcUaLearnBase.newProperty((int)5, (boolean)false, (BFacets)SfUtil.incl());
    public static final Property facets = BOpcUaLearnBase.newProperty((int)5, (BValue)BFacets.NULL, (BFacets)SfUtil.incl());
    public static final Property nodeClass = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Property typeSpec = BOpcUaLearnBase.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    public static final Type TYPE = Sys.loadType(BOpcUaLearnBase.class);
    public static final Lexicon lex = Lexicon.make(BOpcUaLearnBase.class);
    private static final int MAX_ARRAY_SIZE = 200;
    private static final BIcon NC_OBJECT_ICON = BIcon.std((String)"folder.png");
    private static final BIcon NC_METHOD_ICON = BIcon.std((String)"gears.png");
    private static final BIcon NUMERIC_ICON = BIcon.std((String)"control/numericPoint.png");
    private static final BIcon BOOLEAN_ICON = BIcon.std((String)"control/booleanPoint.png");
    private static final BIcon ENUM_ICON = BIcon.std((String)"control/enumPoint.png");
    private static final BIcon STRING_ICON = BIcon.std((String)"control/stringPoint.png");
    private static final BIcon HISTORY_ICON = BIcon.std((String)"badges/history.png");
    private static final BIcon ARRAY_ICON = BIcon.std((String)"layers.png");
    private static final TypeInfo[] NO_TYPES = new TypeInfo[0];
    private static final TypeInfo[] RD_NUMERIC_TYPE = new TypeInfo[]{BNumericPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_BOOLEAN_TYPE = new TypeInfo[]{BBooleanPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_ENUM_TYPE = new TypeInfo[]{BEnumPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_STRING_TYPE = new TypeInfo[]{BStringPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_NUMERIC_TYPE = new TypeInfo[]{BNumericWritable.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_BOOLEAN_TYPE = new TypeInfo[]{BBooleanWritable.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_ENUM_TYPE = new TypeInfo[]{BEnumWritable.TYPE.getTypeInfo(), BEnumPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_STRING_TYPE = new TypeInfo[]{BStringWritable.TYPE.getTypeInfo(), BStringPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] POINT_FOLDER_TYPE = new TypeInfo[]{BOpcUaObject.TYPE.getTypeInfo()};
    private static final TypeInfo[] METHOD_TYPE = new TypeInfo[]{BOpcUaMethod.TYPE.getTypeInfo()};

    public String getUaNodeName() {
        return this.getString(uaNodeName);
    }

    public void setUaNodeName(String v) {
        this.setString(uaNodeName, v, null);
    }

    public String getUaDisplayName() {
        return this.getString(uaDisplayName);
    }

    public void setUaDisplayName(String v) {
        this.setString(uaDisplayName, v, null);
    }

    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    public String getNameSpaceUri() {
        return this.getString(nameSpaceUri);
    }

    public void setNameSpaceUri(String v) {
        this.setString(nameSpaceUri, v, null);
    }

    public BUaAccessLevel getAccessLevel() {
        return (BUaAccessLevel)this.get(accessLevel);
    }

    public void setAccessLevel(BUaAccessLevel v) {
        this.set(accessLevel, (BValue)v, null);
    }

    public String getArrayDimension() {
        return this.getString(arrayDimension);
    }

    public void setArrayDimension(String v) {
        this.setString(arrayDimension, v, null);
    }

    public String getArrayIndex() {
        return this.getString(arrayIndex);
    }

    public void setArrayIndex(String v) {
        this.setString(arrayIndex, v, null);
    }

    public String getUaDataType() {
        return this.getString(uaDataType);
    }

    public void setUaDataType(String v) {
        this.setString(uaDataType, v, null);
    }

    public long getUaDataTypeIdentifier() {
        return this.getLong(uaDataTypeIdentifier);
    }

    public void setUaDataTypeIdentifier(long v) {
        this.setLong(uaDataTypeIdentifier, v, null);
    }

    public boolean getHistorizing() {
        return this.getBoolean(historizing);
    }

    public void setHistorizing(boolean v) {
        this.setBoolean(historizing, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public String getNodeClass() {
        return this.getString(nodeClass);
    }

    public void setNodeClass(String v) {
        this.setString(nodeClass, v, null);
    }

    public String getTypeSpec() {
        return this.getString(typeSpec);
    }

    public void setTypeSpec(String v) {
        this.setString(typeSpec, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOpcUaLearnBase() {
    }

    public BOpcUaLearnBase(String uaName, String nodeId, String arrayDimensions, String index) {
        this.setUaNodeName(uaName);
        this.setUaNodeId(nodeId);
        this.setArrayDimension(arrayDimensions);
        this.setArrayIndex(index);
    }

    public static BOpcUaLearnBase make(BOpcUaNodeLearnEntry entry, long[] indexes) {
        BOpcUaLearnBase learnBase = new BOpcUaLearnBase();
        learnBase.setUaDisplayName(entry.getUaDisplayName());
        learnBase.setUaNodeName(entry.getUaNodeName());
        learnBase.setUaNodeId(entry.getUaNodeId());
        learnBase.setNameSpaceUri(entry.getNameSpaceUri());
        learnBase.setArrayDimension(entry.getArrayDimension());
        learnBase.setArrayIndex(entry.getArrayIndex());
        learnBase.setHistorizing(entry.getHistorizing());
        learnBase.setUaDataType(entry.getUaInstanceType());
        learnBase.setUaDataTypeIdentifier(entry.getUaDataTypeIdentifier());
        learnBase.setTypeSpec(entry.getTypeSpec());
        learnBase.setNodeClass(entry.getNodeClass());
        learnBase.setFacets(entry.getFacets());
        learnBase.setAccessLevel(BUaAccessLevel.make((int)entry.getAccessLevel()));
        if (indexes.length > 0) {
            learnBase.setArrayIndex(MatrixUtil.indexesToString(indexes));
            learnBase.setUaNodeName(MatrixUtil.makeAddName(entry.getUaNodeName(), indexes));
            learnBase.setUaDisplayName(learnBase.getUaNodeName());
        }
        return learnBase;
    }

    public static BOpcUaLearnBase make(BOpcUaNodeLearnEntry entry) {
        if (entry.isArray()) {
            BOpcUaLearnBase learnBase = new BOpcUaLearnBase();
            learnBase.setUaDisplayName(entry.getUaDisplayName());
            learnBase.setUaNodeName(entry.getUaNodeName());
            learnBase.setUaNodeId(entry.getUaNodeId());
            learnBase.setNameSpaceUri(entry.getNameSpaceUri());
            learnBase.setArrayDimension(entry.getArrayDimension());
            learnBase.setNodeClass(entry.getNodeClass());
            long[] arrayDims = entry.getArrayDimensions();
            long arraySize = 1L;
            for (int i = 0; i < arrayDims.length; ++i) {
                arraySize *= arrayDims[i];
            }
            long[] indexes = new long[arrayDims.length];
            boolean done = false;
            int maxArraySize = 200;
            int size = 0;
            while (!done && size < maxArraySize) {
                String addName = MatrixUtil.makeAddName(entry.getUaNodeName(), indexes);
                learnBase.add(SlotPath.escape((String)addName), (BValue)BOpcUaLearnBase.make(entry, indexes));
                if (++size == 200) {
                    BOpcUaNodeLearnEntry.logger.info(lex.getText("clientPointLearn.maxArrayLearn", new Object[]{addName, new Integer(200)}));
                }
                done = MatrixUtil.indexToNext(indexes, arrayDims);
            }
            return learnBase;
        }
        return BOpcUaLearnBase.make(entry, new long[0]);
    }

    public BOpcUaLearnBase[] getArray() {
        if (this.isArray()) {
            return (BOpcUaLearnBase[])this.getChildren(BOpcUaLearnBase.class);
        }
        return new BOpcUaLearnBase[0];
    }

    public BControlPoint makePoint() {
        TypeInfo[] validDatabaseTypes;
        if (this.isAddable() && (validDatabaseTypes = this.getValidDatabaseTypes()).length > 0) {
            BComplex instance = validDatabaseTypes[0].getInstance().asComplex();
            BOpcUaClientProxyExt proxyExt = new BOpcUaClientProxyExt();
            if (instance instanceof BOpcUaMethod) {
                proxyExt = new BOpcUaMethodProxyExt();
                BComplex parent = this.getParent();
                if (parent instanceof BOpcUaLearnBase) {
                    String parentNodeId = ((BOpcUaLearnBase)parent).getUaNodeId();
                    ((BOpcUaMethodProxyExt)proxyExt).setObjectId(parentNodeId);
                }
            }
            if (instance instanceof BControlPoint) {
                BControlPoint point = (BControlPoint)instance;
                point.setProxyExt((BAbstractProxyExt)proxyExt);
                this.updateTarget((BComponent)point);
                return point;
            }
        }
        return null;
    }

    public BOpcUaClientPointFolder makePointFolder() {
        if (this.getNodeClass().equals("Object")) {
            return new BOpcUaClientPointFolder();
        }
        return null;
    }

    public boolean isAddable() {
        return true;
    }

    public boolean getHasAddableDescendant() {
        return false;
    }

    public boolean isArray() {
        return !this.getArrayDimension().isEmpty() && this.getArrayIndex().isEmpty();
    }

    public String getDiscoveryName() {
        return this.getUaDisplayName();
    }

    public TypeInfo[] getValidDatabaseTypes() {
        boolean canWrite;
        boolean bl = canWrite = (this.getAccessLevel().getBits() & 2) != 0;
        if (this.getNodeClass().equals("Object")) {
            return POINT_FOLDER_TYPE;
        }
        if (this.getNodeClass().equals("Method")) {
            return METHOD_TYPE;
        }
        String spec = this.getTypeSpec();
        if (spec.isEmpty()) {
            return NO_TYPES;
        }
        TypeInfo typeInfo = BTypeSpec.make((String)spec).getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            return canWrite ? RD_WR_NUMERIC_TYPE : RD_NUMERIC_TYPE;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            return canWrite ? RD_WR_BOOLEAN_TYPE : RD_BOOLEAN_TYPE;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            return canWrite ? RD_WR_ENUM_TYPE : RD_ENUM_TYPE;
        }
        if (typeInfo.is(BString.TYPE)) {
            return canWrite ? RD_WR_STRING_TYPE : RD_STRING_TYPE;
        }
        return NO_TYPES;
    }

    public void updateTarget(BComponent target) {
        if (target instanceof BOpcUaObject) {
            ((BOpcUaObject)target).setUaNodeId(this.getUaNodeId());
        } else if (target instanceof BControlPoint) {
            BImportHistoryExt[] exts;
            BComplex parent;
            BAbstractProxyExt proxyExt = ((BControlPoint)target).getProxyExt();
            if (proxyExt instanceof BOpcUaClientProxyExt) {
                BOpcUaClientProxyExt opcProxyExt = (BOpcUaClientProxyExt)proxyExt;
                ((BControlPoint)target).setFacets(this.getFacets());
                opcProxyExt.setDeviceFacets(this.getFacets());
                opcProxyExt.setUaNodeId(this.getUaNodeId());
                opcProxyExt.setNameSpaceUri(this.getNameSpaceUri());
                opcProxyExt.setArrayDimensions(this.getArrayDimension());
                opcProxyExt.setArrayIndex(this.getArrayIndex());
                opcProxyExt.setUaDataType(this.getUaDataType());
                opcProxyExt.setUaDataTypeIdentifier(this.getUaDataTypeIdentifier());
            }
            if (proxyExt instanceof BOpcUaMethodProxyExt && (parent = this.getParent()) instanceof BOpcUaLearnBase) {
                String uaNodeId = ((BOpcUaLearnBase)parent).getUaNodeId();
                ((BOpcUaMethodProxyExt)proxyExt).setObjectId(uaNodeId);
            }
            if (this.getHistorizing() && ((exts = (BImportHistoryExt[])target.getChildren(BImportHistoryExt.class)) == null || exts.length == 0)) {
                BImportHistoryExt historyExt;
                if (this.isNumeric()) {
                    historyExt = new BNumericImportHistoryExt();
                    this.initHistories(historyExt);
                    target.add("hist", (BValue)historyExt);
                } else if (this.isBoolean() || this.isEnum() || this.isString()) {
                    historyExt = new BImportHistoryExt();
                    this.initHistories(historyExt);
                    target.add("hist", (BValue)historyExt);
                }
            }
        }
    }

    private void initHistories(BImportHistoryExt histExt) {
        histExt.getHistoryConfig().setCapacity(BCapacity.makeByRecordCount((int)500));
        histExt.getExecutionTime().setTriggerMode((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)10)));
        histExt.setEnabled(true);
    }

    public boolean isNumeric() {
        String typeSpec = this.getTypeSpec();
        if (typeSpec.equals("")) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)typeSpec);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BNumber.TYPE);
    }

    public boolean isBoolean() {
        String typeSpec = this.getTypeSpec();
        if (typeSpec.equals("")) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)typeSpec);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BBoolean.TYPE);
    }

    public boolean isEnum() {
        String typeSpec = this.getTypeSpec();
        if (typeSpec.equals("")) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)typeSpec);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BEnum.TYPE);
    }

    public boolean isString() {
        String typeSpec = this.getTypeSpec();
        if (typeSpec.equals("")) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)typeSpec);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BString.TYPE);
    }

    public boolean isExisting(BComponent component) {
        if (component instanceof BOpcUaClientPointFolder) {
            String s = component.getName();
            return s != null && s.equals(this.getUaDisplayName());
        }
        if (!(component instanceof BControlPoint)) {
            return false;
        }
        BAbstractProxyExt proxyExt = ((BControlPoint)component).getProxyExt();
        if (!(proxyExt instanceof BOpcUaClientProxyExt)) {
            return false;
        }
        BOpcUaClientProxyExt opcProxyExt = (BOpcUaClientProxyExt)proxyExt;
        if (opcProxyExt.getUaNodeId().equals(this.getUaNodeId()) && opcProxyExt.getArrayDimensions().equals(this.getArrayDimension())) {
            return this.getArrayDimension().isEmpty() || opcProxyExt.getArrayIndex().equals(this.getArrayIndex());
        }
        return false;
    }

    public void defaultTargetUpdate(BComponent target) {
        BComplex parent = this.getParent();
        if (parent instanceof BOpcUaNodeLearnEntry) {
            ((BOpcUaNodeLearnEntry)parent).defaultTargetUpdate(target);
        }
    }

    public BIcon getDiscoveryIcon() {
        String typeSpec = this.getTypeSpec();
        if (typeSpec.equals("")) {
            if (this.getNodeClass().equals("Method")) {
                return NC_METHOD_ICON;
            }
            if (this.getNodeClass().equals("Object")) {
                return NC_OBJECT_ICON;
            }
            if (this.isArray()) {
                return ARRAY_ICON;
            }
            return null;
        }
        BTypeSpec ts = BTypeSpec.make((String)typeSpec);
        if (ts.isNull()) {
            return null;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)NUMERIC_ICON, (BIcon)HISTORY_ICON);
            }
            return NUMERIC_ICON;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)BOOLEAN_ICON, (BIcon)HISTORY_ICON);
            }
            return BOOLEAN_ICON;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)ENUM_ICON, (BIcon)HISTORY_ICON);
            }
            return ENUM_ICON;
        }
        if (typeInfo.is(BString.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)STRING_ICON, (BIcon)HISTORY_ICON);
            }
            return STRING_ICON;
        }
        return null;
    }

    public BIcon getIcon() {
        if (this.getNodeClass().equals("Object")) {
            return NC_OBJECT_ICON;
        }
        if (this.getNodeClass().equals("Variable")) {
            return this.getDiscoveryIcon();
        }
        if (this.getNodeClass().equals("Method")) {
            return NC_METHOD_ICON;
        }
        return super.getIcon();
    }
}

