/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.history;

import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaCore.enums.BServerState;
import java.util.logging.Logger;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="localHistoryName", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}, flags=64), @NiagaraProperty(name="uaNodeName", type="String", defaultValue="", flags=1, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="uaNodeId", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="typeSpec", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.NULL")})
public class BOpcUaClientHistoryImport
extends BHistoryImport {
    public static final Property localHistoryName = BOpcUaClientHistoryImport.newProperty((int)64, (String)"", (BFacets)SfUtil.incl());
    public static final Property uaNodeName = BOpcUaClientHistoryImport.newProperty((int)1, (String)"", (BFacets)SfUtil.incl());
    public static final Property uaNodeId = BOpcUaClientHistoryImport.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Property typeSpec = BOpcUaClientHistoryImport.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Property facets = BOpcUaClientHistoryImport.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Type TYPE = Sys.loadType(BOpcUaClientHistoryImport.class);
    private BIHistory pointHistory;
    private HistoryDatabaseConnection dbConnection;
    public static final Logger logger = Logger.getLogger("opcUaClient.history");
    private static final String VALUE_FACETS = "valueFacets";

    public String getLocalHistoryName() {
        return this.getString(localHistoryName);
    }

    public void setLocalHistoryName(String v) {
        this.setString(localHistoryName, v, null);
    }

    public String getUaNodeName() {
        return this.getString(uaNodeName);
    }

    public void setUaNodeName(String v) {
        this.setString(uaNodeName, v, null);
    }

    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    public String getTypeSpec() {
        return this.getString(typeSpec);
    }

    public void setTypeSpec(String v) {
        this.setString(typeSpec, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BOpcUaDevice device() {
        return (BOpcUaDevice)this.getDeviceExt().getDevice();
    }

    public void started() throws Exception {
        BHistoryService service;
        BHistoryDatabase db;
        super.started();
        Type rcdType = this.getHistoryRecordType();
        BHistoryId histId = BHistoryId.make((String)this.getDevice().getName(), (String)this.getDefaultName());
        this.setHistoryId(histId);
        Slot slot = this.getSlot("historyConfig");
        if (slot == null) {
            BHistoryConfig histConfig = new BHistoryConfig(histId, BTypeSpec.make((Type)rcdType));
            histConfig = this.makeLocalConfig(histConfig);
            try {
                this.add("historyConfig", (BValue)histConfig);
            }
            catch (Exception e) {
                logger.severe("Error while adding history records :" + e.getMessage());
            }
        }
        if ((db = (service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase()) == null) {
            return;
        }
        this.dbConnection = db.getDbConnection(null);
        if (this.dbConnection == null) {
            return;
        }
        this.initHistory(histId);
    }

    private void initHistory(BHistoryId histId) {
        try {
            BHistoryConfig histConfig = (BHistoryConfig)this.get("historyConfig");
            histConfig.setTimeZone(BTimeZone.getLocal());
            BFacets f = (BFacets)histConfig.get(VALUE_FACETS);
            if (f != null) {
                histConfig.set(VALUE_FACETS, (BValue)this.getFacets());
            } else {
                histConfig.add(VALUE_FACETS, (BValue)this.getFacets());
            }
            if (!this.dbConnection.exists(histId)) {
                this.dbConnection.createHistory(histConfig);
            } else {
                this.dbConnection.reconfigureHistory(histConfig);
            }
            this.pointHistory = this.dbConnection.getHistory(histId);
        }
        catch (Exception e) {
            logger.severe("Error while creating history records :" + e.getMessage());
        }
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        if (!this.isRunning()) {
            return null;
        }
        return ((BOpcUaNetwork)this.getNetwork()).postAsync((Runnable)new Invocation((BComponent)this, execute, arg, cx));
    }

    public void doExecute() throws ArchiveException {
        DataValue[] result;
        BOpcUaDevice device = this.device();
        DateTime startTime = DateTime.MIN_VALUE;
        if (!device.getServerState().equals((Object)BServerState.Running)) {
            this.executeFail("Server not running");
            return;
        }
        this.executeInProgress();
        try {
            BAbsTime lastTimestamp = this.dbConnection.getLastTimestamp(this.pointHistory);
            startTime = DateTime.fromMillis((long)OpcUaClientUtil.getModifiedStartTime(lastTimestamp, ((BOpcUaDevice)this.getDevice()).getInitialHistoryArchiveFromDate()).getMillis());
        }
        catch (Exception ex) {
            logger.fine("Exception while getting the lastTimestamp for PointHistory  - " + ex);
        }
        try {
            UaClient client = device.uaClient;
            NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
            BHistoryId historyId = this.pointHistory.getId();
            if (this.dbConnection.getHistory(historyId) == null) {
                this.initHistory(historyId);
            }
            result = OpcUaClientUtil.historyReadRaw(client, nodeId, startTime, DateTime.currentTime(), UnsignedInteger.MAX_VALUE, true, null, TimestampsToReturn.Source);
        }
        catch (Exception e) {
            logger.info("OpcUaClientHistoryImport readhistory exception - " + e);
            this.executeFail(e);
            return;
        }
        if (result != null) {
            for (DataValue aResult : result) {
                try {
                    this.appendHistoryDataValue(aResult);
                }
                catch (Exception ex) {
                    logger.info("Exception while adding history data:" + ex.getMessage());
                }
            }
        }
        this.executeOk();
    }

    private void appendHistoryDataValue(DataValue dataValue) {
        DateTime sourceTimestamp = dataValue.getSourceTimestamp();
        BAbsTime sampleTime = OpcUaClientUtil.dateTimeToAbsTime(sourceTimestamp);
        BTrendRecord histRecord = (BTrendRecord)this.pointHistory.getRecordType().getInstance();
        BStatusValue histValue = OpcUaClientUtil.makeStatusValue(dataValue, histRecord);
        BAbsTime lastTimestamp = this.dbConnection.getLastTimestamp(this.pointHistory);
        if (this.dbConnection.getRecordCount(this.pointHistory) == 0 || sampleTime.isAfter(lastTimestamp)) {
            if (histRecord instanceof BNumericTrendRecord) {
                double value = ((BStatusNumeric)histValue).getValue();
                ((BNumericTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else if (histRecord instanceof BBooleanTrendRecord) {
                boolean value = ((BStatusBoolean)histValue).getValue();
                ((BBooleanTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else if (histRecord instanceof BEnumTrendRecord) {
                BDynamicEnum value = ((BStatusEnum)histValue).getValue();
                ((BEnumTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else if (histRecord instanceof BStringTrendRecord) {
                String value = ((BStatusString)histValue).getValue();
                ((BStringTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else {
                return;
            }
            this.dbConnection.append(this.pointHistory, (BIHistoryRecordSet)histRecord);
        }
    }

    private Type getHistoryRecordType() {
        String spec = this.getTypeSpec();
        if (spec.isEmpty()) {
            return null;
        }
        TypeInfo typeInfo = BTypeSpec.make((String)spec).getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            return BNumericTrendRecord.TYPE;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            return BBooleanTrendRecord.TYPE;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            return BEnumTrendRecord.TYPE;
        }
        if (typeInfo.is(BString.TYPE)) {
            return BStringTrendRecord.TYPE;
        }
        return null;
    }

    private String getDefaultName() {
        return this.getUaNodeName().replace('/', '_');
    }
}

