/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.alarm;

import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmDeviceExt;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="uaNodeId", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="subscribed", type="boolean", defaultValue="false", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="lastEvent", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="new BAlarmSourceInfo()"), @NiagaraProperty(name="lastSubscribed", type="BAbsTime", defaultValue="BAbsTime.NULL")})
@NiagaraActions(value={@NiagaraAction(name="subscribeForEvents", flags=20), @NiagaraAction(name="unsubscribeForEvents", flags=20)})
public class BOpcUaClientAlarmSource
extends BComponent
implements BIAlarmSource,
BIStatus {
    public static final Property status = BOpcUaClientAlarmSource.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl());
    public static final Property enabled = BOpcUaClientAlarmSource.newProperty((int)0, (boolean)true, null);
    public static final Property uaNodeId = BOpcUaClientAlarmSource.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Property subscribed = BOpcUaClientAlarmSource.newProperty((int)0, (boolean)false, (BFacets)SfUtil.incl());
    public static final Property lastEvent = BOpcUaClientAlarmSource.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Property alarmSourceInfo = BOpcUaClientAlarmSource.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    public static final Property lastSubscribed = BOpcUaClientAlarmSource.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Action subscribeForEvents = BOpcUaClientAlarmSource.newAction((int)20, null);
    public static final Action unsubscribeForEvents = BOpcUaClientAlarmSource.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BOpcUaClientAlarmSource.class);
    private AlarmSupport alarmSupport;
    private int oldStatus = 0;
    private BOpcUaDevice device;
    private static final Logger logger = Logger.getLogger("opcUaClient.alarm");

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    public boolean getSubscribed() {
        return this.getBoolean(subscribed);
    }

    public void setSubscribed(boolean v) {
        this.setBoolean(subscribed, v, null);
    }

    public String getLastEvent() {
        return this.getString(lastEvent);
    }

    public void setLastEvent(String v) {
        this.setString(lastEvent, v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BAbsTime getLastSubscribed() {
        return (BAbsTime)this.get(lastSubscribed);
    }

    public void setLastSubscribed(BAbsTime v) {
        this.set(lastSubscribed, (BValue)v, null);
    }

    public void subscribeForEvents() {
        this.invoke(subscribeForEvents, null, null);
    }

    public void unsubscribeForEvents() {
        this.invoke(unsubscribeForEvents, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.device = this.getDevice();
        if (this.needsSubscription()) {
            this.doSubscribeForEvents();
            this.setLastSubscribed(BAbsTime.now());
        }
    }

    public AlarmSupport getAlarmSupport() {
        return this.alarmSupport;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || Context.decoding.equals(cx)) {
            super.changed(p, cx);
            return;
        }
        if (p.equals(enabled)) {
            this.updateEventAndStatus(this.getEnabled());
        } else if (p.equals(subscribed)) {
            this.updateEventAndStatus(this.getSubscribed());
        }
    }

    private void updateEventAndStatus(boolean isSubscribeForEvents) {
        if (isSubscribeForEvents) {
            this.doSubscribeForEvents();
        } else {
            this.doUnsubscribeForEvents();
        }
        this.updateStatus();
    }

    public BOpcUaDevice getDevice() {
        if (this.device != null) {
            return this.device;
        }
        BDevice dvc = this.getAlarmDeviceExt().getDevice();
        if (dvc instanceof BOpcUaDevice) {
            this.device = (BOpcUaDevice)dvc;
        }
        return this.device;
    }

    public BOpcUaClientAlarmDeviceExt getAlarmDeviceExt() {
        BComplex parent = this.getParent();
        if (parent instanceof BOpcUaClientAlarmDeviceExt) {
            return (BOpcUaClientAlarmDeviceExt)parent;
        }
        return null;
    }

    public void doSubscribeForEvents() {
        try {
            NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
            Object value1 = nodeId.getValue();
            BOpcUaDevice device = this.getDevice();
            if (device == null) {
                return;
            }
            BOpcUaClientAlarmDeviceExt eventListener = device.getAlarmExt();
            eventListener.addMonitorEvent(nodeId);
            this.setSubscribed(eventListener.isSubscribed(nodeId));
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred when subscribing to an alarm event", e);
            }
            logger.log(Level.SEVERE, "Exception occurred when subscribing to an alarm event: " + e);
        }
    }

    public void doUnsubscribeForEvents() {
        try {
            NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
            Object value1 = nodeId.getValue();
            BOpcUaDevice device = this.getDevice();
            if (device == null) {
                return;
            }
            BOpcUaClientAlarmDeviceExt eventListener = device.getAlarmExt();
            eventListener.removeMonitorEvent(nodeId);
            this.setSubscribed(eventListener.isSubscribed(nodeId));
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred when unsubscribing to an alarm event", e);
            }
            logger.log(Level.SEVERE, "Exception occurred when unsubscribing to an alarm event: " + e);
        }
    }

    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        try {
            return this.getAlarmDeviceExt().doAckAlarm(ackRequest);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred when acknowledging an alarm event", e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred when acknowledging an alarm event: " + e);
            }
            return BBoolean.FALSE;
        }
    }

    public void setLastEvent(BOpcUaClientAlarmEntry lastEvent) {
        this.setLastEvent(BAbsTime.now() + " " + lastEvent.getAlarmMessage());
    }

    public void updateStatus() {
        BStatus device;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = device = this.device == null ? BStatus.ok : this.device.getStatus();
        newStatus = !this.getEnabled() || device.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = device.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    private boolean needsSubscription() {
        boolean subscribed = this.getSubscribed();
        if (!subscribed && this.getLastSubscribed() == BAbsTime.NULL) {
            BOpcUaClientAlarmDeviceExt alarmExt = this.device.getAlarmExt();
            subscribed = alarmExt.getAutoSubscribeEnable();
        }
        return subscribed;
    }
}

