/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.ServerListException;
import com.prosysopc.ua.client.ServerStatusListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.UaClientListener;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.ObjectIdentifiers;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.VariableIdentifiers;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nre.security.SecretChars;
import com.tridium.opcUaClient.BOpcUaBuildInfo;
import com.tridium.opcUaClient.BOpcUaNetwork;
import com.tridium.opcUaClient.BOpcUserAuthenticationMode;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmDeviceExt;
import com.tridium.opcUaClient.history.BOpcUaClientHistoryDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaClientPointDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaClientPointDiscoveryPreferences;
import com.tridium.opcUaClient.point.BOpcUaClientProxyExt;
import com.tridium.opcUaClient.point.BOpcUaLearnBase;
import com.tridium.opcUaClient.point.BOpcUaNodeLearnEntry;
import com.tridium.opcUaClient.util.OpcUaCertificateValidator;
import com.tridium.opcUaClient.util.OpcUaClientListener;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaClient.util.OpcUaServerStatusListener;
import com.tridium.opcUaCore.enums.BSecurityMode;
import com.tridium.opcUaCore.enums.BServerState;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true), @NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="serverEndpointUrl", type="String", defaultValue=""), @NiagaraProperty(name="securityMode", type="BSecurityMode", defaultValue="BSecurityMode.DEFAULT", flags=64), @NiagaraProperty(name="certificate", type="String", defaultValue="tridium", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(\"purposeId\", BString.make(\"CLIENT_CERT\"))")}), @NiagaraProperty(name="userAuthenticationMode", type="BOpcUserAuthenticationMode", defaultValue="BOpcUserAuthenticationMode.DEFAULT", flags=64), @NiagaraProperty(name="userName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT", flags=64), @NiagaraProperty(name="serverState", type="BServerState", defaultValue="BServerState.Unknown", flags=67), @NiagaraProperty(name="serverCurrentTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="serverStartTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="timeoutInterval", type="BRelTime", defaultValue="BRelTime.make(30*1000)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.make(1)")}), @NiagaraProperty(name="statusCheckTimeout", type="BRelTime", defaultValue="BRelTime.make(10*1000)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.make(1)")}), @NiagaraProperty(name="serverInfo", type="BOpcUaBuildInfo", defaultValue="new BOpcUaBuildInfo()", flags=1), @NiagaraProperty(name="AlarmExt", type="BOpcUaClientAlarmDeviceExt", defaultValue="new BOpcUaClientAlarmDeviceExt()", flags=1), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal", flags=4), @NiagaraProperty(name="points", type="BOpcUaClientPointDeviceExt", defaultValue="new BOpcUaClientPointDeviceExt()"), @NiagaraProperty(name="histories", type="BOpcUaClientHistoryDeviceExt", defaultValue="new BOpcUaClientHistoryDeviceExt()"), @NiagaraProperty(name="lastLearnedInfo", type="String", defaultValue="", flags=7), @NiagaraProperty(name="initialHistoryArchiveFromDate", type="BAbsTime", defaultValue="BAbsTime.DEFAULT")})
@NiagaraActions(value={@NiagaraAction(name="learn", flags=16), @NiagaraAction(name="resetComm", parameterType="BInteger", defaultValue="BInteger.make(60)", flags=16), @NiagaraAction(name="updateNamespaceUri", flags=20), @NiagaraAction(name="resetDelay", flags=20)})
public class BOpcUaDevice
extends BNDevice
implements BINPollable,
IPropertyValidator {
    public static final Property status = BOpcUaDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property pollScheduler = BOpcUaDevice.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    public static final Property serverEndpointUrl = BOpcUaDevice.newProperty((int)0, (String)"", null);
    public static final Property securityMode = BOpcUaDevice.newProperty((int)64, (BValue)BSecurityMode.DEFAULT, null);
    public static final Property certificate = BOpcUaDevice.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)"CLIENT_CERT"))));
    public static final Property userAuthenticationMode = BOpcUaDevice.newProperty((int)64, (BValue)BOpcUserAuthenticationMode.DEFAULT, null);
    public static final Property userName = BOpcUaDevice.newProperty((int)64, (String)"", null);
    public static final Property password = BOpcUaDevice.newProperty((int)64, (BValue)BPassword.DEFAULT, null);
    public static final Property serverState = BOpcUaDevice.newProperty((int)67, (BValue)BServerState.Unknown, null);
    public static final Property serverCurrentTime = BOpcUaDevice.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property serverStartTime = BOpcUaDevice.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property timeoutInterval = BOpcUaDevice.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L))));
    public static final Property statusCheckTimeout = BOpcUaDevice.newProperty((int)0, (BValue)BRelTime.make((long)10000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L))));
    public static final Property serverInfo = BOpcUaDevice.newProperty((int)1, (BValue)new BOpcUaBuildInfo(), null);
    public static final Property AlarmExt = BOpcUaDevice.newProperty((int)1, (BValue)new BOpcUaClientAlarmDeviceExt(), null);
    public static final Property pollFrequency = BOpcUaDevice.newProperty((int)4, (BValue)BPollFrequency.normal, null);
    public static final Property points = BOpcUaDevice.newProperty((int)0, (BValue)new BOpcUaClientPointDeviceExt(), null);
    public static final Property histories = BOpcUaDevice.newProperty((int)0, (BValue)new BOpcUaClientHistoryDeviceExt(), null);
    public static final Property lastLearnedInfo = BOpcUaDevice.newProperty((int)7, (String)"", null);
    public static final Property initialHistoryArchiveFromDate = BOpcUaDevice.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Action learn = BOpcUaDevice.newAction((int)16, null);
    public static final Action resetComm = BOpcUaDevice.newAction((int)16, (BValue)BInteger.make((int)60), null);
    public static final Action updateNamespaceUri = BOpcUaDevice.newAction((int)20, null);
    public static final Action resetDelay = BOpcUaDevice.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BOpcUaDevice.class);
    protected final UaClientListener clientListener = new OpcUaClientListener();
    protected final OpcUaServerStatusListener serverStatusListener = new OpcUaServerStatusListener(this);
    public UaClient uaClient;
    private int lastLearnCount = 0;
    private Clock.Ticket commResetTicket;
    private BOpcUaNodeLearnEntry[] descendants;
    public static final Logger logger = Logger.getLogger("opcUaClient.client");
    public static final Lexicon lex = Lexicon.make(BOpcUaDevice.class);
    public static final String SERVER_ROOT = "serverRoot";
    public static final String APP_NAME = "NiagaraOpcUaClient";
    public static final Pattern OPCUA_IPV4_PATTERN = Pattern.compile("\\b((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.|$)){4}\\b");
    private static final String OPC_TCP = "opc.tcp";
    public static final String SERVER_KEY_PASSWORD_SLOT_NAME = "serverKeyPassword";

    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public String getServerEndpointUrl() {
        return this.getString(serverEndpointUrl);
    }

    public void setServerEndpointUrl(String v) {
        this.setString(serverEndpointUrl, v, null);
    }

    public BSecurityMode getSecurityMode() {
        return (BSecurityMode)this.get(securityMode);
    }

    public void setSecurityMode(BSecurityMode v) {
        this.set(securityMode, (BValue)v, null);
    }

    public String getCertificate() {
        return this.getString(certificate);
    }

    public void setCertificate(String v) {
        this.setString(certificate, v, null);
    }

    public BOpcUserAuthenticationMode getUserAuthenticationMode() {
        return (BOpcUserAuthenticationMode)this.get(userAuthenticationMode);
    }

    public void setUserAuthenticationMode(BOpcUserAuthenticationMode v) {
        this.set(userAuthenticationMode, (BValue)v, null);
    }

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public BServerState getServerState() {
        return (BServerState)this.get(serverState);
    }

    public void setServerState(BServerState v) {
        this.set(serverState, (BValue)v, null);
    }

    public BAbsTime getServerCurrentTime() {
        return (BAbsTime)this.get(serverCurrentTime);
    }

    public void setServerCurrentTime(BAbsTime v) {
        this.set(serverCurrentTime, (BValue)v, null);
    }

    public BAbsTime getServerStartTime() {
        return (BAbsTime)this.get(serverStartTime);
    }

    public void setServerStartTime(BAbsTime v) {
        this.set(serverStartTime, (BValue)v, null);
    }

    public BRelTime getTimeoutInterval() {
        return (BRelTime)this.get(timeoutInterval);
    }

    public void setTimeoutInterval(BRelTime v) {
        this.set(timeoutInterval, (BValue)v, null);
    }

    public BRelTime getStatusCheckTimeout() {
        return (BRelTime)this.get(statusCheckTimeout);
    }

    public void setStatusCheckTimeout(BRelTime v) {
        this.set(statusCheckTimeout, (BValue)v, null);
    }

    public BOpcUaBuildInfo getServerInfo() {
        return (BOpcUaBuildInfo)this.get(serverInfo);
    }

    public void setServerInfo(BOpcUaBuildInfo v) {
        this.set(serverInfo, (BValue)v, null);
    }

    public BOpcUaClientAlarmDeviceExt getAlarmExt() {
        return (BOpcUaClientAlarmDeviceExt)this.get(AlarmExt);
    }

    public void setAlarmExt(BOpcUaClientAlarmDeviceExt v) {
        this.set(AlarmExt, (BValue)v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BOpcUaClientPointDeviceExt getPoints() {
        return (BOpcUaClientPointDeviceExt)this.get(points);
    }

    public void setPoints(BOpcUaClientPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BOpcUaClientHistoryDeviceExt getHistories() {
        return (BOpcUaClientHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BOpcUaClientHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    public String getLastLearnedInfo() {
        return this.getString(lastLearnedInfo);
    }

    public void setLastLearnedInfo(String v) {
        this.setString(lastLearnedInfo, v, null);
    }

    public BAbsTime getInitialHistoryArchiveFromDate() {
        return (BAbsTime)this.get(initialHistoryArchiveFromDate);
    }

    public void setInitialHistoryArchiveFromDate(BAbsTime v) {
        this.set(initialHistoryArchiveFromDate, (BValue)v, null);
    }

    public void learn() {
        this.invoke(learn, null, null);
    }

    public void resetComm(BInteger parameter) {
        this.invoke(resetComm, (BValue)parameter, null);
    }

    public void updateNamespaceUri() {
        this.invoke(updateNamespaceUri, null, null);
    }

    public void resetDelay() {
        this.invoke(resetDelay, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BOpcUaNetwork.TYPE;
    }

    public void started() throws Exception {
        BOpcUaNetwork opcUaNetwork = this.getOpcUaClientNetwork();
        if (opcUaNetwork.isDisabled() || opcUaNetwork.isDown() || opcUaNetwork.isFault()) {
            return;
        }
        super.started();
        if (this.getUserAuthenticationMode().equals((Object)BOpcUserAuthenticationMode.userNameAndPassword)) {
            this.setFlags((Slot)userName, this.getFlags((Slot)userName) & 0xFFFFFFFB);
            this.setFlags((Slot)password, this.getFlags((Slot)password) & 0xFFFFFFFB);
        }
        try {
            OpcUaClientUtil.connect(this);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred while connecting: " + e);
        }
        this.initDeviceAfterConnect(null);
    }

    public void stopped() throws Exception {
        try {
            if (this.commResetTicket != null) {
                this.commResetTicket.cancel();
                this.commResetTicket = null;
            }
            OpcUaClientUtil.disconnect(this);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        super.stopped();
    }

    public void changed(Property p, Context cx) {
        boolean subsPoints = false;
        if (!this.isRunning() || Context.decoding.equals(cx)) {
            super.changed(p, cx);
            return;
        }
        if (!this.getNetwork().getEnabled()) {
            try {
                OpcUaClientUtil.disconnect(this);
            }
            catch (PrivilegedActionException e) {
                logger.log(Level.WARNING, "Unable to disconnect client when network is disabled");
            }
            super.changed(p, cx);
            return;
        }
        if (SERVER_KEY_PASSWORD_SLOT_NAME.equals(p.getName())) {
            try {
                OpcUaClientUtil.disconnect(this);
                OpcUaClientUtil.connect(this);
                subsPoints = true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while changing server key password", e);
            }
        }
        if (p.equals(securityMode) || p.equals(timeoutInterval) || p.equals(statusCheckTimeout) || p.equals(userName) || p.equals(password) || p.equals(certificate)) {
            try {
                OpcUaClientUtil.disconnect(this);
                OpcUaClientUtil.connect(this);
                subsPoints = true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while changing security mode", e);
            }
        }
        if (p.equals(serverEndpointUrl)) {
            try {
                OpcUaClientUtil.disconnect(this);
                OpcUaClientUtil.connect(this);
                subsPoints = true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while changing endpoint URL", e);
            }
        }
        if (p == userAuthenticationMode) {
            if (this.getUserAuthenticationMode() == BOpcUserAuthenticationMode.anonymous) {
                this.setFlags((Slot)userName, this.getFlags((Slot)userName) | 4, cx);
                this.setFlags((Slot)password, this.getFlags((Slot)password) | 4, cx);
            } else if (this.getUserAuthenticationMode() == BOpcUserAuthenticationMode.userNameAndPassword) {
                this.setUserName("");
                this.setPassword(BPassword.DEFAULT);
                this.setFlags((Slot)userName, this.getFlags((Slot)userName) & 0xFFFFFFFB, cx);
                this.setFlags((Slot)password, this.getFlags((Slot)password) & 0xFFFFFFFB, cx);
            }
            try {
                OpcUaClientUtil.disconnect(this);
                OpcUaClientUtil.connect(this);
                subsPoints = true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while changing user authentication mode", e);
            }
        }
        if (p.equals(serverState)) {
            BServerState state = this.getServerState();
            if (state.equals((Object)BServerState.Running)) {
                if (this.uaClient == null || !this.uaClient.isConnected()) {
                    try {
                        OpcUaClientUtil.connect(this);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception occurred while changing server State", e);
                    }
                }
                subsPoints = true;
            } else {
                this.pingFail("ServerState is " + state.getTag());
                for (BOpcUaClientProxyExt proxyExt : (BOpcUaClientProxyExt[])CompUtil.getDescendants((BComponent)this.getPoints(), BOpcUaClientProxyExt.class)) {
                    proxyExt.setUaStatusCode(StatusCode.BAD.toString());
                }
            }
        }
        if (p.equals(enabled)) {
            try {
                if (!this.getEnabled()) {
                    OpcUaClientUtil.disconnect(this);
                } else {
                    OpcUaClientUtil.connect(this);
                    subsPoints = true;
                }
            }
            catch (Exception e) {
                this.setServerState(BServerState.Unknown);
                logger.log(Level.SEVERE, "Exception occurred while changing enabled state", e);
            }
        }
        if (subsPoints) {
            this.initDeviceAfterConnect(cx);
        }
        super.changed(p, cx);
    }

    private void initDeviceAfterConnect(Context cx) {
        this.doPing();
        for (BOpcUaClientProxyExt proxyExt : (BOpcUaClientProxyExt[])CompUtil.getDescendants((BComponent)this.getPoints(), BOpcUaClientProxyExt.class)) {
            if (!proxyExt.getParentPoint().isSubscribed()) continue;
            try {
                proxyExt.readSubscribed(cx);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while subscribing to node: " + proxyExt.getUaNodeId(), e);
            }
        }
        this.getAlarmExt().init();
    }

    public void setCertificateValidator() {
        OpcUaCertificateValidator validator = new OpcUaCertificateValidator(this.uaClient.getAddress());
        this.uaClient.setCertificateValidator((CertificateValidator)validator);
    }

    public void initialize() throws URISyntaxException, SecureIdentityException, IOException, SessionActivationException, ServerListException {
        long startMillis = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("OpcUaDevice initializing for " + this.getServerEndpointUrl());
        }
        this.uaClient.setSessionName(APP_NAME);
        this.uaClient.getEndpointConfiguration().setMaxByteStringLength(Integer.valueOf(Integer.MAX_VALUE));
        this.uaClient.getEndpointConfiguration().setMaxArrayLength(Integer.valueOf(Integer.MAX_VALUE));
        this.uaClient.setLocale(Locale.ENGLISH);
        this.uaClient.setTimeout(this.getTimeoutInterval().getMillis());
        this.uaClient.setStatusCheckTimeout(this.getStatusCheckTimeout().getMillis());
        this.uaClient.setListener(this.clientListener);
        this.uaClient.addServerStatusListener((ServerStatusListener)this.serverStatusListener);
        this.setCertificateValidator();
        SecurityMode securityMode = this.getSecurityMode().getSecurityMode();
        this.uaClient.setSecurityMode(securityMode);
        if (!securityMode.equals((Object)SecurityMode.NONE)) {
            this.uaClient.getHttpsSettings().setHttpsSecurityPolicies(new HttpsSecurityPolicy[]{HttpsSecurityPolicy.TLS_1_0, HttpsSecurityPolicy.TLS_1_1, HttpsSecurityPolicy.TLS_1_2});
            try {
                AccessController.doPrivileged(() -> {
                    String certAlias = this.getCertificate();
                    ICryptoManager cryptoManager = CertManagerFactory.getInstance();
                    IKeyStore keyStore = cryptoManager.getKeyStore();
                    X509Certificate clientCert = keyStore.getCertificate(certAlias);
                    PrivKey privKey = new PrivKey(this.getServerPrivateKey(keyStore, certAlias));
                    ApplicationIdentity applicationIdentity = new ApplicationIdentity(new Cert(clientCert), privKey);
                    ApplicationDescription appDescription = new ApplicationDescription();
                    appDescription.setApplicationName(new LocalizedText("NiagaraOpcUaClient@localhost"));
                    appDescription.setApplicationUri("urn:localhost:OPCUA:NiagaraOpcUaClient");
                    appDescription.setProductUri("urn:tridium.com:OPCUA:NiagaraOpcUaClient");
                    appDescription.setApplicationType(ApplicationType.Client);
                    applicationIdentity.setApplicationDescription(appDescription, true);
                    this.uaClient.setApplicationIdentity(applicationIdentity);
                    UserIdentity userIdentity = new UserIdentity(new Cert(clientCert), privKey);
                    this.uaClient.setUserIdentity(userIdentity);
                    return null;
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while creating OPCUA identity", e);
            }
        }
        this.checkAuthenticationMode(this.uaClient);
        if (logger.isLoggable(Level.FINE)) {
            long endMillis = System.currentTimeMillis();
            logger.fine("OpcUaDevice initialization complete for " + this.getServerEndpointUrl() + " (" + (endMillis - startMillis) + "ms)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAuthenticationMode(UaClient client) throws SessionActivationException {
        if (this.getUserAuthenticationMode() == BOpcUserAuthenticationMode.userNameAndPassword) {
            String userName = this.getUserName().trim();
            String pws = this.getPassword().getValue().trim();
            if (userName == null || userName.length() == 0 || pws == null || pws.length() == 0) throw new RuntimeException(lex.getText("opcUaClientUserPassAuth.NoUserNoPass"));
            client.setUserIdentity(new UserIdentity(userName, pws));
            return;
        } else {
            if (this.getUserAuthenticationMode() != BOpcUserAuthenticationMode.anonymous) return;
            client.setUserIdentity(new UserIdentity());
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
    }

    public synchronized void doPing() {
        block14: {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("OpcUaDevice doPing() to " + this.getServerEndpointUrl());
                }
                if (!this.getNetwork().getEnabled()) {
                    this.pingFail(lex.getText("opcUaClient.pingFailNetworkDisable"));
                    return;
                }
                if (!this.getEnabled()) {
                    this.pingFail("Device disabled");
                    return;
                }
                if (this.commResetTicket != null) {
                    this.pingFail("Currently resetting connection to server");
                    return;
                }
                if (this.getServerState().equals((Object)BServerState.Shutdown)) {
                    return;
                }
                if (this.uaClient == null) {
                    this.pingFail("OPCUA client is not initialized");
                    break block14;
                }
                try {
                    AccessController.doPrivileged(() -> {
                        this.checkAuthenticationMode(this.uaClient);
                        if (this.uaClient == null || !this.uaClient.isConnected()) {
                            long startMillis = System.currentTimeMillis();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("OpcUaDevice connecting to " + this.getServerEndpointUrl());
                            }
                            this.uaClient.connect();
                            if (logger.isLoggable(Level.FINE)) {
                                long endMillis = System.currentTimeMillis();
                                logger.fine("OpcUaDevice connection complete to " + this.getServerEndpointUrl() + " (" + (endMillis - startMillis) + "ms)");
                            }
                        }
                        DataValue value = this.uaClient.readValue(VariableIdentifiers.Server_ServerStatus_State);
                        DataValue curTime = this.uaClient.readValue(VariableIdentifiers.Server_ServerStatus_CurrentTime);
                        DataValue startTime = this.uaClient.readValue(VariableIdentifiers.Server_ServerStatus_StartTime);
                        this.setServerCurrentTime(OpcUaClientUtil.dataValueToAbsTime(curTime));
                        this.setServerStartTime(OpcUaClientUtil.dataValueToAbsTime(startTime));
                        this.pingOk();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("ping successful with appURI " + this.uaClient.getApplicationIdentity().getApplicationDescription().getApplicationUri());
                        }
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (Exception e) {
                String appUri = null;
                try {
                    appUri = this.uaClient.getApplicationIdentity().getApplicationDescription().getApplicationUri();
                }
                catch (Exception e2) {
                    appUri = "<unknown>";
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, "Exception occurred during ping for device " + this.getName() + " with appURI " + appUri, e);
                } else {
                    logger.severe("Exception occurred during ping for device " + this.getName() + " with appURI " + appUri + ": " + e);
                }
                this.pingFail(e.getLocalizedMessage());
            }
        }
    }

    public void doPoll() {
    }

    public void doResetComm(BInteger delay) {
        try {
            if (this.commResetTicket == null) {
                this.commResetTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)delay.getInt()), (Action)resetDelay, null);
                OpcUaClientUtil.disconnect(this);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while resetting communications for device " + this.getName(), e);
            }
            logger.severe("Exception occurred while resetting communications for device " + this.getName() + ": " + e);
        }
    }

    public void doResetDelay() {
        this.commResetTicket = null;
        try {
            OpcUaClientUtil.connect(this);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while resetting delay for device " + this.getName(), e);
            }
            logger.severe("Exception occurred while resetting delay for device " + this.getName() + ": " + e);
        }
    }

    public void doLearn() throws PrivilegedActionException {
        this.doLearn(null);
    }

    public void doLearn(BNDiscoveryJob job) throws PrivilegedActionException {
        String failCause;
        this.getPoints().setDiscoveryFailCause("");
        try {
            if (this.uaClient == null || !this.uaClient.isConnected()) {
                OpcUaClientUtil.connect(this);
            }
            AddressSpace addressSpace = this.uaClient.getAddressSpace();
            addressSpace.setMaxReferencesPerNode(1000);
            addressSpace.setReferenceTypeId(ReferenceTypeIdentifiers.HierarchicalReferences);
            NodeId uaObjectRootId = ObjectIdentifiers.RootFolder;
            if (uaObjectRootId == null) {
                if (job != null) {
                    job.log().message(BOpcUaNetwork.lex.getText("clientPointLearn.noRootObject"));
                }
            } else {
                addressSpace.setReferenceTypeId(ReferenceTypeIdentifiers.HierarchicalReferences);
                BOpcUaNodeLearnEntry learnRoot = new BOpcUaNodeLearnEntry("root", uaObjectRootId.toString(), "", "", BTypeSpec.DEFAULT);
                if (this.get(SERVER_ROOT) != null) {
                    this.remove(SERVER_ROOT);
                }
                this.add(SERVER_ROOT, (BValue)learnRoot);
                int expectedCount = this.lastLearnCount <= 0 ? 3000 : this.lastLearnCount;
                this.lastLearnCount = OpcUaClientUtil.learn(this, learnRoot, uaObjectRootId, job, 0, expectedCount);
                for (BOpcUaNodeLearnEntry descendant : this.descendants = (BOpcUaNodeLearnEntry[])CompUtil.getDescendants((BComponent)learnRoot, BOpcUaNodeLearnEntry.class)) {
                    descendant.updateFacets();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred during learn for device " + this.getName(), e);
            throw e;
        }
        if (!(failCause = this.getPoints().getDiscoveryFailCause()).isEmpty()) {
            throw new RuntimeException(failCause);
        }
    }

    public void doUpdateNamespaceUri() throws PrivilegedActionException {
        this.doLearn(this.getPoints().getDiscoveryPreferences().getJob());
        for (BOpcUaClientProxyExt proxyExt : (BOpcUaClientProxyExt[])CompUtil.getDescendants((BComponent)this.getPoints(), BOpcUaClientProxyExt.class)) {
            this.updateNamespaceUri(proxyExt, this.descendants);
        }
    }

    private void updateNamespaceUri(BOpcUaClientProxyExt proxyExt, BOpcUaNodeLearnEntry[] descendants) {
        if (proxyExt.getNameSpaceUri().isEmpty() || proxyExt.getNameSpaceUri() == null) {
            try {
                for (BOpcUaNodeLearnEntry descendant : descendants) {
                    if (!descendant.getUaNodeId().equals(proxyExt.getUaNodeId())) continue;
                    proxyExt.setNameSpaceUri(descendant.getNameSpaceUri());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while setting NamespaceUri to node: " + proxyExt.getUaNodeId(), e);
            }
        }
    }

    public BOpcUaLearnBase[] getLearnedPoints() {
        BNDiscoveryPreferences prefs = this.getPoints().getDiscoveryPreferences();
        boolean showAddableOnly = prefs instanceof BOpcUaClientPointDiscoveryPreferences ? ((BOpcUaClientPointDiscoveryPreferences)prefs).getShowAddableOnly() : false;
        return this.getLearnedPoints(showAddableOnly);
    }

    public BOpcUaLearnBase[] getLearnedPoints(boolean showAddableOnly) {
        BComponent root = this.get(SERVER_ROOT).asComponent();
        if (!(root instanceof BOpcUaNodeLearnEntry)) {
            return new BOpcUaLearnBase[0];
        }
        return new BOpcUaLearnBase[]{((BOpcUaNodeLearnEntry)root).toDiscoveryTree(showAddableOnly)};
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (!this.isRunning() || this.uaClient == null) {
            return;
        }
        out.startProps();
        out.trTitle((Object)"uaClient subscriptions ", 2);
        for (Subscription subscription : this.uaClient.getSubscriptions()) {
            out.prop((Object)"subscription", subscription.getPublishingInterval());
            for (MonitoredItemBase monitoredItem : subscription.getItems()) {
                out.prop((Object)"", (Object)monitoredItem.toString());
            }
        }
        out.endProps();
    }

    public final BOpcUaNetwork getOpcUaClientNetwork() {
        return (BOpcUaNetwork)this.getNetwork();
    }

    public boolean isCommReset() {
        return this.commResetTicket != null;
    }

    public void cancelCommReset() {
        if (this.commResetTicket != null) {
            this.commResetTicket.cancel();
            this.commResetTicket = null;
        }
    }

    public void validateSet(Validatable validatable, Context context) {
        BString proposedValue = (BString)validatable.getProposedValue(serverEndpointUrl);
        if (!(proposedValue == null || proposedValue.getString().startsWith(OPC_TCP) || OPCUA_IPV4_PATTERN.matcher(proposedValue.getString()).matches() || proposedValue.getString().isEmpty())) {
            throw new LocalizableRuntimeException("opcUaClient", "opcUaClient.endPoint", new Object[]{proposedValue.getString(), this.getName()});
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (property != null && property.equals(serverEndpointUrl) && newValue != null && !((BString)newValue).getString().startsWith(OPC_TCP) && !OPCUA_IPV4_PATTERN.matcher(((BString)newValue).getString()).matches() && !((BString)newValue).getString().isEmpty()) {
            throw new LocalizableRuntimeException("opcUaClient", "opcUaClient.endPoint", new Object[]{((BString)newValue).getString(), this.getName()});
        }
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    private RSAPrivateKey getServerPrivateKey(IKeyStore keyStore, String certAlias) throws Exception {
        BPassword serverKeyPassword = null;
        try {
            serverKeyPassword = (BPassword)this.get(SERVER_KEY_PASSWORD_SLOT_NAME);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error retrieving serverKeyPassword", e);
        }
        Key key = null;
        if (serverKeyPassword == null) {
            key = keyStore.getKey(certAlias, null);
        } else {
            try (SecretChars passwordChars = serverKeyPassword.getSecretChars();){
                key = keyStore.getKey(certAlias, passwordChars.get());
            }
        }
        return (RSAPrivateKey)key;
    }
}

