/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.tab;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.IFinishable;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.Tab;
import java.text.MessageFormat;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XWriter;

public abstract class HxTabUtil {
    public static boolean CALL_NOW = true;
    public static String KEY_UP = "keyup";
    public static String KEY_DOWN = "keydown";
    public static String CHANGE = "change";
    public static String CLICK = "click";
    public static String DOUBLE_CLICK = "dblclick";
    public static String FOCUS = "focus";
    public static String BLUR = "blur";
    public static String SHOW_ELEM = "smartTable.showElem";
    public static String HIDE_ELEM = "smartTable.hideElem";
    public static String HIDE_LESS_THAN_ELEM = "smartTable.hideLessThanElem";
    public static String HIDE_CHECKED = "smartTable.hideChecked";
    public static String DISABLE_CHECKED = "smartTable.disableChecked";
    public static String FIRE_EVENT = "smartTable.fireEvent";
    public static String FIRE_ROW_EVENT = "smartTable.fireRowEvent";
    public static String MATCH_VALUE = "smartTable.matchValue";
    public static String MATCH_CHECKED = "smartTable.matchChecked";
    public static final String handlePrefix = "station:|h:";
    public static final String NONE_TEXT = "noneText";
    public static final String CONFIRM_CLEAR = "confirmClear";
    public static final String SET_MODIFIED = "setModified";
    public static final String SHOW_PREVIEW = "showPreview";
    public static final String FIRE_EVENT_ON_SAVE = "fireEventOnSave";

    public static void setTitle(String title, String entry, HxOp op) {
        HxTabUtil.setTitle(title, entry, true, op);
    }

    public static void setTitle(String title, String entry, boolean profile, HxOp op) {
        StringBuffer b = new StringBuffer();
        b.append("document.title = &quot;");
        title = TextUtil.replace((String)title, (String)"\"", (String)"'");
        b.append(HxTabUtil.safe(title));
        if (entry != null && entry.length() > 0) {
            entry = TextUtil.replace((String)entry, (String)"\"", (String)"'");
            b.append(": ").append(HxTabUtil.safe(entry));
        }
        b.append("&quot;;");
        op.addOnload(b.toString());
    }

    public static void writeTitle(String title, HxOp op) throws Exception {
        HxTabUtil.writeHeader(title, op);
        HxTabUtil.setTitle(title, null, op);
    }

    public static void writeHeader(String title, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<h3 class='smartTable-header' ");
        HxTabUtil.scope("title", out, op);
        out.w((Object)">").safe((Object)title);
        out.w((Object)"</h3>");
    }

    public static void writeHeaderTab(Tab tab, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table ");
        out.attr("class", "setup-tab");
        out.attr(" width", "100%");
        out.w((Object)">");
        out.w((Object)"<tr ");
        out.w((Object)"><td ");
        out.attr("class", "smartTable-setup-label");
        out.w((Object)">");
        out.safe((Object)tab.title);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        tab.write();
        out.w((Object)"</td>");
        out.w((Object)"<td ");
        out.w((Object)"class='smartTable-setup-label' style='width: 100%'>&nbsp;</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
    }

    public static void writeHeader(String title, SmartCommand[] commands, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div ");
        out.attr("class", "smartTable-setup-panel").w((Object)">");
        if (op.getPath().equals("")) {
            HxTabUtil.writeTitle(title, op);
        } else {
            HxTabUtil.writeHeader(title, op);
        }
        HxTabUtil.writeCommands(commands, true, op);
        out.w((Object)"</div>");
    }

    public static void writeCommand(SmartCommand command, HxOp op) throws Exception {
        HxTabUtil.writeCommand(command, true, op);
    }

    public static void writeCommands(SmartCommand[] commands, boolean useLabel, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div ");
        out.attr("class", "smartTable-commands");
        out.attr(" id", op.scope("commands"));
        out.attr(" name", op.scope("commands"));
        out.w((Object)">");
        if (commands != null && commands.length > 0) {
            for (int i = 0; i < commands.length; ++i) {
                if (commands[i] instanceof SaveCommand && HxUtil.isPost((HxOp)op) || !commands[i].isVisible(op)) continue;
                if (commands[i].isDefaultAction() && commands[i].startsEnabled(op)) {
                    BHxSmartTableView.writeFormValue("doubleClick", op.getPath() + "|" + commands[i].getId(), op);
                }
                HxTabUtil.writeCommand(commands[i], useLabel, op);
            }
        }
        out.w((Object)"</div>");
    }

    public static void writeCommand(SmartCommand command, boolean useLabel, HxOp op) throws Exception {
        boolean disabled;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<button type='button' ");
        out.w((Object)"class='ux-btn-tb ");
        if (command.isDefaultAction()) {
            out.w((Object)" ux-btn-tb-default");
        }
        boolean bl = disabled = command.getEnablePolicy() != BCommandEnablePolicy.always && command.getEnablePolicy() != BCommandEnablePolicy.alwaysOrAnySelection || !command.startsEnabled(op);
        if (disabled) {
            out.w((Object)" ux-disabled");
        }
        out.safe((Object)(" " + HxTabUtil.classScope(command.getEnablePolicy().getTag(), op)));
        out.w((Object)"'");
        if (disabled) {
            out.w((Object)" disabled ");
        }
        command.addOnload(op);
        if (command instanceof SaveCommand) {
            SaveCommand saveCommand = (SaveCommand)command;
            out.attr(" id", saveCommand.getHtmlElementName(op));
            out.attr(" name", saveCommand.getHtmlElementName(op));
        } else {
            out.attr(" id", op.scope(command.getName(op)));
            out.attr(" name", op.scope(command.getName(op)));
        }
        String displayName = command.getDisplayName(op);
        out.attr(" title", displayName);
        String enablePolicyInvokeCode = command.getEnablePolicyInvokeCode(op);
        if (enablePolicyInvokeCode != null) {
            out.w((Object)" enablePolicy='").w((Object)enablePolicyInvokeCode).w((Object)"'");
        }
        out.w((Object)" ondblclick='return smartTable.disableSelection(e);'");
        out.w((Object)" onclick='").w((Object)command.getInvokeCode(op)).w((Object)"'>");
        out.w((Object)"<span class='display'>");
        out.w((Object)"<span class='icon'>");
        BImage image = command.getIcon(op);
        if (image != null) {
            HxUtil.makeImageJS((BImage)image, null, (String)displayName, null, (HxOp)op);
        }
        out.w((Object)"</span><span class='displayName'>");
        if (useLabel || image == null) {
            out.safe((Object)displayName);
        }
        out.w((Object)"</span></span>");
        out.w((Object)"</button> ");
    }

    public static String classScope(String text, HxOp op) {
        return TextUtil.replace((String)op.scope(text), (String)".", (String)"-");
    }

    public static void writeImageCommand(SmartCommand command, HxOp op) throws Exception {
        HxTabUtil.writeImageCommand(command, true, op);
    }

    public static void writeImageCommand(SmartCommand command, boolean display, HxOp op) throws Exception {
        command.addOnload(op);
        HxTabUtil.writeImageCommand(command, display, null, op);
    }

    public static void writeImageCommand(SmartCommand command, boolean display, String extraInvokeCode, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        command.addOnload(op);
        out.w((Object)"<span ");
        out.attr("style", "cursor:pointer;" + (display ? "" : "display:none;"));
        out.attr(" id", op.scope(command.getName(op)));
        out.attr(" name", op.scope(command.getName(op)));
        String displayName = command.getDisplayName(op);
        out.attr(" title", displayName);
        out.w((Object)" onclick='");
        if (extraInvokeCode != null && extraInvokeCode.length() > 0) {
            out.w((Object)extraInvokeCode).w((Object)";");
        }
        out.w((Object)command.getInvokeCode(op)).w((Object)"'");
        String enablePolicyInvokeCode = command.getEnablePolicyInvokeCode(op);
        if (enablePolicyInvokeCode != null) {
            out.w((Object)" enablePolicy='").w((Object)enablePolicyInvokeCode).w((Object)"'");
        }
        out.w((Object)">");
        out.w((Object)"<span>");
        BImage image = command.getIcon(op);
        if (image != null) {
            HxUtil.makeImageJS((BImage)image, null, (String)displayName, null, (HxOp)op);
        } else {
            out.w((Object)" ").safe((Object)displayName);
        }
        out.w((Object)"</span> ");
        out.w((Object)"</span>");
    }

    public static int startTabs(Tab[] tabs, SmartCommand[] commands, HxOp op) throws Exception {
        if (tabs == null || tabs.length == 0) {
            return -1;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='ux-tab-container'");
        out.attr(" id", op.scope("container"));
        out.w((Object)">");
        out.w((Object)"<table ").attr("class", "ux-tab");
        out.w((Object)">");
        out.w((Object)"<tr>");
        int defaultTabNumber = BHxTabbedView.getDefaultTabIndex(tabs, op);
        for (int i = 0; i < tabs.length; ++i) {
            String title = tabs[i].title;
            String escapedTitle = SlotPath.escape((String)title);
            boolean isDefaultPage = i == defaultTabNumber;
            out.w((Object)"<td ");
            HxTabUtil.scope("label" + escapedTitle, out, op);
            out.w((Object)" onclick='");
            out.w((Object)"tab.swapTab(&quot;").safe((Object)escapedTitle).w((Object)"&quot;,&quot;").safe((Object)op.scope("")).w((Object)"&quot;);");
            if (tabs[i].view instanceof IFinishable && ((IFinishable)tabs[i].view).requiresFinishing(tabs[i].op)) {
                if (isDefaultPage) {
                    op.addOnload(((IFinishable)tabs[i].view).getFinishInvokeCode(tabs[i].op));
                } else {
                    out.w((Object)((IFinishable)tabs[i].view).getFinishInvokeCode(tabs[i].op));
                }
            }
            out.w((Object)"' ");
            if (isDefaultPage) {
                out.attr("class", "ux-tab-title ux-highlight ux-tab-title-highlight");
            } else {
                out.attr("class", "ux-tab-title");
            }
            out.w((Object)"> ").safe((Object)title).w((Object)" </td>");
        }
        out.w((Object)"<td ").attr("class", "ux-tab-title-end").w((Object)">");
        out.w((Object)"<div class = 'ux-tab-commands'>");
        HxTabUtil.writeCommands(commands, false, op);
        out.w((Object)"</div>");
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr>");
        return defaultTabNumber;
    }

    public static void startTab(Tab tab, boolean show, int tabCount, HtmlWriter out, HxOp op) throws Exception {
        BHxView view = tab.view;
        HxOp fieldOp = tab.op;
        out.w((Object)"<td ").attr("class", "ux-tab-content");
        if (!show) {
            out.attr(" style", "display:none;");
        } else {
            out.attr(" style", "display: table-cell;");
        }
        out.w((Object)" colspan='").w(tabCount + 1).w((Object)"'>");
        out.w((Object)"<div ").attr("class", "ux-tab-inner-content").w((Object)">");
    }

    public static void endTab(HtmlWriter out, HxOp op) {
        out.w((Object)"</div>");
        out.w((Object)"</td>");
    }

    public static void endTabs(HtmlWriter out, HxOp op) {
        out.w((Object)"</tr></table></div>");
    }

    public static void startTable(HtmlWriter out, HxOp op) {
        out.w((Object)"<div ");
        out.attr("width", "100%");
        out.attr(" class", "setup-tab");
        out.w((Object)">");
        out.w((Object)"<table ");
        out.w((Object)">");
    }

    public static void endTable(HtmlWriter out, HxOp op) {
        out.w((Object)"</table>");
        out.w((Object)"</div>");
    }

    public static void startRow(HtmlWriter out, HxOp op) {
        out.w((Object)"<tr><td>");
    }

    public static void nextColumn(HtmlWriter out, HxOp op) {
        out.w((Object)"</td><td>");
    }

    public static void startRow(String title, HtmlWriter out, HxOp op) {
        out.w((Object)"<tr ");
        HxTabUtil.scope(title, out, op);
        out.w((Object)"><td class='smartTable-setup-label'>");
        out.safe((Object)title);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
    }

    public static void endRow(HtmlWriter out, HxOp op) {
        out.w((Object)"</td></tr>");
    }

    public static String getParam(ViewQuery query, String name) {
        return query == null ? null : query.getParameter(name, null);
    }

    public static void getSpacerDiv(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='smartTable-spacer'></div>");
    }

    public static void getSpacerRow(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<tr><td>&nbsp;</td></tr>");
    }

    public static void getHyperLinkRow(BComponent o, HxOp op) throws Exception {
        HxTabUtil.getHyperLinkRow(o, 0, op);
    }

    public static void getHyperLinkRow(BComponent o, int spaces, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<tr><td ");
        out.w((Object)">");
        for (int i = 0; i < spaces; ++i) {
            out.w((Object)"&nbsp;");
        }
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)o.getIcon()), null, null, null, (HxOp)op);
        HxUtil.writeSafeAnchor((BOrd)o.getOrdInSpace(), (String)o.toString((Context)op), (HxOp)op);
        out.w((Object)"</td></tr>");
    }

    public static void selectMinWidthFix(int pixels, HtmlWriter out, HxOp op) {
        out.attr("style", "width: " + pixels + "px");
    }

    public static HtmlWriter scope(String name, HtmlWriter out, HxOp op) {
        out.w((Object)" name='").w((Object)op.scope(HxTabUtil.safe(name))).w((Object)"'");
        out.w((Object)" id='").w((Object)op.scope(HxTabUtil.safe(name))).w((Object)"' ");
        return out;
    }

    public static String string(Object object) {
        if (object == null) {
            return "&nbsp;";
        }
        String s = object.toString();
        if (s == null || s.equals("") || s.equals("null")) {
            return "&nbsp;";
        }
        return XWriter.safeToString((String)s, (boolean)true);
    }

    public static String safeForFormValue(String s) {
        s = TextUtil.replace((String)s, (String)"'", (String)"`");
        return s;
    }

    public static String safe(String s) {
        return XWriter.safeToString((String)s, (boolean)true);
    }

    public static String safeWithBreaksForJavascript(String s) {
        s = TextUtil.replace((String)s, (String)" ", (String)"&nbsp;");
        return HxTabUtil.safeWithBreaks(s);
    }

    public static String safeWithBreaks(String s) {
        String value = XWriter.safeToString((String)s, (boolean)true);
        return TextUtil.replace((String)value, (String)"&lt;br/&gt;", (String)"<br/>");
    }

    public static void safeString(HtmlWriter out, Object object) {
        if (object == null) {
            out.w((Object)"&nbsp;");
        } else {
            String s = object.toString();
            if (s == null) {
                out.w((Object)"&nbsp;");
            }
            if (s.equals("") || s.equals(" ") || s.equals("&nbsp;")) {
                out.w((Object)"&nbsp;");
                return;
            }
            out.safe((Object)s);
        }
    }

    public static String blobDisplay(String encoded) {
        try {
            BBlob blob = (BBlob)BBlob.DEFAULT.decodeFromString(encoded);
            byte[] temp = blob.copyBytes();
            byte[] bytes = new byte[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                bytes[temp.length - 1 - i] = temp[i];
            }
            return ByteArrayUtil.toHexString((byte[])bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return encoded;
        }
    }

    public static String statusValueDisplay(BStatusValue sv, HxOp op) {
        BStatusValue copy = (BStatusValue)sv.newCopy();
        BFacets facets = copy.getStatus().getFacets();
        facets = BFacets.makeRemove((BFacets)facets, (String)"activeLevel");
        BStatus status = BStatus.make((int)copy.getStatus().getBits(), (BFacets)facets);
        copy.setStatus(status);
        return copy.toString((Context)op);
    }

    public static BComponent getComponent(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BComponent)) {
            o = t.get();
            t = t.getBaseOrdTarget();
        }
        return (BComponent)t.get();
    }

    public static BComponent getComponent(String handle) {
        if (handle == null) {
            return null;
        }
        String ordString = handlePrefix + handle;
        try {
            BObject object = BOrd.make((String)ordString).get();
            if (object.isComponent()) {
                return (BComponent)object;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void addEvent(String eventName, String functionName, boolean callNow, String sourceId, String param1, String param2, HxOp op) {
        op.addOnload(HxTabUtil.getAddEventInvokeCode(eventName, functionName, callNow, sourceId, param1, param2, op));
    }

    public static String getAddEventInvokeCode(String eventName, String functionName, boolean callNow, String sourceId, String param1, String param2, HxOp op) {
        String quote = HxUtil.getInnerQuote((HxOp)op);
        StringBuffer b = new StringBuffer();
        b.append("smartTable.addEvent(");
        b.append(quote);
        b.append(eventName);
        b.append(quote);
        b.append(",");
        b.append(functionName);
        b.append(",");
        b.append(callNow);
        b.append(",");
        b.append(quote).append(sourceId).append(quote);
        b.append(",");
        b.append(quote).append(param1).append(quote);
        b.append(",");
        b.append(quote).append(param2).append(quote);
        b.append(");");
        return b.toString();
    }

    public static void fireSaveEventInFacets(HxOp op) throws Exception {
        if (op.getFacets().gets(FIRE_EVENT_ON_SAVE, null) != null) {
            op.getHtmlWriter().w((Object)op.getFacets().gets(FIRE_EVENT_ON_SAVE, null));
        }
    }

    public static String getDisplayName(String entryText, String defaultText, Object[] args, Lexicon lexicon, Lexicon childLexicon, HxOp op) {
        String displayName = "";
        displayName = lexicon != null && lexicon.get(entryText) != null ? lexicon.getText(entryText, args) : (childLexicon != null && childLexicon.get(entryText) != null ? childLexicon.getText(entryText, args) : (HxTabUtil.getLexiconText(entryText) != null ? HxTabUtil.getLexiconText(entryText, args) : (defaultText != null ? defaultText : entryText)));
        return displayName;
    }

    public static String getLexiconText(String lexiconKey) {
        return Sys.getRegistry().getDef("manageDevices.lexicon." + lexiconKey);
    }

    public static String getLexiconText(String lexiconKey, Object[] args) {
        String value = Sys.getRegistry().getDef("manageDevices.lexicon." + lexiconKey);
        if (value == null) {
            return lexiconKey;
        }
        return MessageFormat.format(value, args);
    }

    public static Lexicon getLexicon(Class<?> c) {
        return HxTabUtil.getLexicon(c, null);
    }

    public static Lexicon getLexicon(Class<?> c, Context cx) {
        return Lexicon.make((String)Sys.getModuleForClass(c).getModuleName(), (Context)cx);
    }

    public static String getPluralDisplayName(Type type, Context cx) {
        Lexicon lex = Lexicon.make((String)Sys.getModuleForClass((Class)type.getTypeClass()).getModuleName(), (Context)cx);
        String displayName = type.getDisplayName(cx);
        displayName = displayName.endsWith("s") ? displayName + "es" : displayName + "s";
        return lex.get(type.getTypeName() + ".displayName.plural", displayName);
    }

    public static String getDisplayDuration(BAbsTime from) {
        BAbsTime to = Clock.time();
        return HxTabUtil.getDisplayDuration(from.delta(to));
    }

    public static String getDisplayDuration(BRelTime duration) {
        return HxTabUtil.getDisplayDuration(duration, true);
    }

    public static String getDisplayDuration(BRelTime duration, boolean displayAgo) {
        StringBuffer b = new StringBuffer();
        long ms = duration.getMillis();
        if (ms < 60000L) {
            b.append("< 1min");
        } else if (ms < 3600000L) {
            long mins = ms / 60000L;
            ms %= 60000L;
            b.append(mins).append(mins == 1L ? "min" : "mins");
        } else if (ms < 86400000L) {
            long hours = ms / 3600000L;
            b.append(hours).append(hours == 1L ? "hour" : "hours");
            long mins = (ms %= 3600000L) / 60000L;
            if (mins > 0L) {
                b.append(" ").append(mins).append(mins == 1L ? "min" : "mins");
            }
        } else {
            long mins;
            long days = ms / 86400000L;
            b.append(days).append(days == 1L ? "day" : "days");
            long hours = (ms %= 86400000L) / 3600000L;
            if (hours > 0L) {
                b.append(" ").append(hours).append(hours == 1L ? "hour" : "hours");
            }
            if ((mins = (ms %= 3600000L) / 60000L) > 0L) {
                b.append(" ").append(mins).append(mins == 1L ? "min" : "mins");
            }
        }
        if (displayAgo) {
            b.append(" ago");
        }
        return b.toString();
    }

    public static String getNoneText(Context cx) {
        return cx.getFacets().gets(NONE_TEXT, SmartCommand.smartTableHxLexModule.get("none", cx));
    }
}

