/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.fieldeditors;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.fieldeditors.BComponentNamePickerFE;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public abstract class BSmartComponentNamePickerFE
extends BComponentNamePickerFE {
    public static final Type TYPE = Sys.loadType(BSmartComponentNamePickerFE.class);
    BTextDropDown smartField;
    SmartItem[] smartItems;

    public Type getType() {
        return TYPE;
    }

    public BSmartComponentNamePickerFE() {
        int width = 20;
        if (this.showSlotPath()) {
            width = 60;
        }
        this.smartField = new BTextDropDown("", width, true);
        this.setContent((BWidget)this.smartField);
        this.linkTo("a", (BComponent)this.smartField, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("b", (BComponent)this.smartField, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    public abstract Type getServiceType();

    public abstract Type getTargetType();

    public boolean showSlotPath() {
        return false;
    }

    public String getNoItemName() {
        return Lexicon.make(((Object)((Object)this)).getClass()).getText("none");
    }

    public Type getFolderType() {
        return BFolder.TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.loadName(value.toString(), cx);
        if (this.getNoItemName() != null) {
            this.smartField.getList().insertItem(0, (Object)this.getNoItemName());
        }
    }

    public BComponent[] list() throws Exception {
        return this.list(null);
    }

    public BComponent[] list(Context cx) throws Exception {
        try {
            Object service = null;
            if (this.getServiceType() != null) {
                if (cx instanceof OrdTarget) {
                    BFoxSession session = null;
                    for (OrdTarget op = (OrdTarget)cx; op != null && session == null; op = op.getBaseOrdTarget()) {
                        if (!(op.get() instanceof BComponent) || !(((BComponent)op.get()).getSession() instanceof BFoxSession)) continue;
                        session = (BFoxSession)((BComponent)op.get()).getSession();
                    }
                    if (session != null) {
                        service = session.getService(this.getServiceType());
                    }
                }
                if (service == null) {
                    service = Sys.getStation() != null ? Sys.getService((Type)this.getServiceType()) : this.loadService(this.getServiceType());
                }
            } else {
                service = Sys.getStation() != null ? Sys.getStation() : this.loadStation();
            }
            BComponent[] picks = this.loadFromFolder((BComponent)service);
            return picks;
        }
        catch (ServiceNotFoundException e) {
            return new BComponent[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final BComponent loadStation() {
        BWbShell shell = this.getWbShell();
        BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)"station:|slot:/");
        return (BComponent)ord.get();
    }

    public BComponent[] loadFromFolder(BComponent folder) {
        ArrayList<BComponent> components = new ArrayList<BComponent>();
        folder.lease();
        BComponent[] direct = (BComponent[])folder.getChildren(this.getTargetType().getTypeClass());
        for (int i = 0; i < direct.length; ++i) {
            components.add(direct[i]);
        }
        BComponent[] folders = (BComponent[])folder.getChildren(this.getFolderType().getTypeClass());
        for (int j = 0; j < folders.length; ++j) {
            BComponent[] indirect = this.loadFromFolder(folders[j]);
            for (int i = 0; i < indirect.length; ++i) {
                components.add(indirect[i]);
            }
        }
        return components.toArray(new BComponent[components.size()]);
    }

    public void loadName(String name) {
        this.loadName(name, null);
    }

    public void loadName(String name, Context cx) {
        this.smartField.setText(name);
        this.smartField.getList().removeAllItems();
        this.smartItems = null;
        try {
            BComponent[] components = this.list(cx);
            try {
                components = (BComponent[])Arrays.stream(components).filter(c -> {
                    BComplex parent = c.getParent();
                    return parent == null || !Flags.isHidden((BComplex)parent, (Slot)c.getPropertyInParent());
                }).toArray(BComponent[]::new);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.smartItems = new SmartItem[components.length];
            SmartItem match = null;
            for (int i = 0; i < this.smartItems.length; ++i) {
                SmartItem item = this.smartItems[i] = new SmartItem(components[i]);
                if (!this.showSlotPath() && item.name.equals(name) || this.showSlotPath() && item.slotPath.equals(name)) {
                    match = item;
                }
                this.smartField.getList().addItem(item.icon, (Object)item);
            }
            if (match != null) {
                if (this.showSlotPath()) {
                    this.smartField.setText(match.slotPath);
                } else {
                    this.smartField.setText(match.displayName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        String savename = this.saveName();
        return BString.make((String)savename);
    }

    public String saveName() {
        String name = this.smartField.getText();
        if (this.smartItems != null) {
            for (int i = 0; i < this.smartItems.length; ++i) {
                if (!this.showSlotPath() && this.smartItems[i].displayName.equals(name)) {
                    name = this.smartItems[i].name;
                    break;
                }
                if (!this.showSlotPath() || !this.smartItems[i].slotPath.equals(name)) continue;
                name = this.smartItems[i].slotPath;
                break;
            }
        }
        return name;
    }

    public class SmartItem {
        String name;
        String displayName;
        String slotPath;
        BImage icon;

        SmartItem(BComponent c) {
            this.name = c.getName();
            this.displayName = c.getDisplayName(null);
            this.icon = BImage.make((BIcon)c.getIcon());
            this.slotPath = c.toDisplayPathString(null);
        }

        public String toString() {
            if (BSmartComponentNamePickerFE.this.showSlotPath()) {
                return this.slotPath;
            }
            return this.displayName;
        }
    }
}

