/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.fieldeditors;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.FinishTableThread;
import com.tridium.smartTableHx.IFinishable;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.Tab;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public abstract class BHxAssignmentFE
extends BHxTabbedView
implements IFinishable {
    private static final LexiconModule lex = LexiconModule.make(BHxAssignmentFE.class);
    public static final Type TYPE = Sys.loadType(BHxAssignmentFE.class);
    public static final char SEP = '|';
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_HEIGHT = 300;
    public static final int DEFAULT_DISABLED_HEIGHT = 125;
    public static final String IS_MOUNTED = "HxAssignmentFE.isMounted";

    @Override
    public Type getType() {
        return TYPE;
    }

    public abstract BHxSmartTableView getAssignedView(HxOp var1);

    public abstract BHxSmartTableView getUnassignedView(HxOp var1);

    public abstract void saveNewlyAssigned(String var1, HxOp var2) throws Exception;

    public abstract void saveNewlyUnassigned(String var1, HxOp var2) throws Exception;

    public abstract BObject getAssignedTable(BComponent var1, HxOp var2);

    public abstract BObject getUnassignedTable(BComponent var1, HxOp var2);

    @Override
    public boolean requiresFinishing(HxOp op) {
        return this.getAssignedView(op).requiresFinishing(op) || this.getUnassignedView(op).requiresFinishing(op);
    }

    @Override
    public String getFinishInvokeCode(HxOp op) {
        return this.getAssignedView(op).getFinishInvokeCode(op.make("assigned", op.get(), op.getFacets())) + this.getUnassignedView(op).getFinishInvokeCode(op.make("potentials", op.get(), op.getFacets()));
    }

    @Override
    public Tab[] getTabs(HxOp op) {
        BComponent target = this.getComponent(op);
        HxOp assignedOp = op.make("assigned", this.getAssignedTable(target, op), op.getFacets());
        SmartCommand.matchReadonly(assignedOp, op);
        assignedOp.mergeFacets(op.getFacets());
        if (this.isUnassignMode(op)) {
            assignedOp.mergeFacets(BHxSmartTableView.makeHeightFacets(125));
        } else {
            assignedOp.mergeFacets(BHxSmartTableView.makeHeightFacets(300));
        }
        HxOp unassignedOp = op.make("potentials", this.getUnassignedTable(target, op), op.getFacets());
        SmartCommand.matchReadonly(unassignedOp, op);
        unassignedOp.mergeFacets(op.getFacets());
        if (this.isUnassignMode(op)) {
            unassignedOp.mergeFacets(BHxSmartTableView.makeHeightFacets(300));
        } else {
            unassignedOp.mergeFacets(BHxSmartTableView.makeHeightFacets(125));
        }
        Tab[] tabs = new Tab[]{new Tab(this.getAssignedView(op), assignedOp), new Tab(this.getUnassignedView(op), unassignedOp)};
        return tabs;
    }

    public void init(HxOp op) {
        op.setAttribute(op.scope("potentials.parentOp"), (Object)op);
        op.setAttribute(op.scope("assigned.parentOp"), (Object)op);
        op.setAttribute(op.scope("parentView"), (Object)this);
    }

    public void addOnload(HxOp op) {
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/join.js"));
        String quote = HxUtil.getInnerQuote((HxOp)op);
        op.addOnload("join.confirmMessageLine1=" + quote + lex.getText("join.confirmMessage.line1", (Context)op) + quote + ";");
        op.addOnload("join.confirmMessageLine2=" + quote + lex.getText("join.confirmMessage.line2", (Context)op) + quote + ";");
        op.addOnload("join.confirmMessageLine3=" + quote + lex.getText("join.confirmMessage.line3", (Context)op) + quote + ";");
    }

    @Override
    public void write(HxOp op) throws Exception {
        this.init(op);
        this.addOnload(op);
        this.setIsMounted(op);
        HtmlWriter out = op.getHtmlWriter();
        BComponent target = this.getComponent(op);
        this.setUnassignMode(false, op);
        out.w((Object)"<div ");
        out.attr("style", "display:none");
        out.w((Object)">");
        out.w((Object)"<select ");
        out.attr("name", op.scope("value"));
        out.attr("id", op.scope("value"));
        SaveCommand.exemptInputFromSaveRegistration(out);
        out.w((Object)">");
        out.w((Object)"</select>");
        out.w((Object)"</div>");
        Tab[] tabs = this.getTabs(op);
        tabs[0].write();
        out.w((Object)"<div ");
        out.attr("id", op.scope("discoverDiv"));
        out.attr("class", "smartTable-row1");
        if (!this.isUnassignMode(op)) {
            out.attr("style", "display:none");
        }
        out.w((Object)">");
        tabs[1].write();
        out.w((Object)"</div>");
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        this.init(op);
        return super.process(op);
    }

    @Override
    public void update(HxOp op) throws Exception {
        this.init(op);
        super.update(op);
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        this.init(op);
        String values = op.getUnsafeFormValue("valueAll");
        String[] selectOptions = new String[]{};
        if (values != null) {
            selectOptions = TextUtil.split((String)values, (char)'|');
        }
        this.save(selectOptions, op);
        Tab[] tabs = this.getTabs(op);
        FinishTableThread.remove(tabs[0].op);
        FinishTableThread.remove(tabs[1].op);
        return op.get();
    }

    public void save(String[] selectOptions, HxOp op) throws Exception {
        if (!this.isUnassignMode(op)) {
            for (int i = 0; i < selectOptions.length; ++i) {
                this.saveNewlyUnassigned(selectOptions[i], op);
            }
        } else {
            for (int i = 0; i < selectOptions.length; ++i) {
                this.saveNewlyAssigned(selectOptions[i], op);
            }
        }
    }

    public void unassign(BOrd scopedOrd, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String ord = BHxSmartTableView.unscopeId(scopedOrd.toString());
        boolean unassignMode = this.isUnassignMode(op);
        if (!unassignMode) {
            out.w((Object)("if(join.addToSelect('" + op.scope("value") + "','" + ord + "','" + ord + "','" + op.getPath() + "'," + unassignMode + ")){"));
            out.w((Object)("join.allSelect('" + op.scope("value") + "');"));
            SaveCommand.setModified(op);
            out.w((Object)"}");
            BHxAssignmentFE.showDiv(op);
        } else {
            out.w((Object)("join.removeFromSelect('" + op.scope("value") + "','" + ord + "','" + op.getPath() + "'," + unassignMode + ");"));
            out.w((Object)("join.allSelect('" + op.scope("value") + "');"));
            SaveCommand.setModified(op);
        }
    }

    public void assign(BOrd scopedOrd, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String ord = BHxSmartTableView.unscopeId(scopedOrd.toString());
        boolean unassignMode = this.isUnassignMode(op);
        if (unassignMode) {
            if (this.isSingleAssignment(op)) {
                out.w((Object)("join.clearSelect('" + op.scope("value") + "','" + op.getPath() + "'," + unassignMode + ");"));
            }
            out.w((Object)("if(join.addToSelect('" + op.scope("value") + "','" + ord + "','" + ord + "','" + op.getPath() + "'," + unassignMode + ")){"));
            out.w((Object)("join.allSelect('" + op.scope("value") + "');"));
            SaveCommand.setModified(op);
            out.w((Object)"}");
        } else {
            out.w((Object)("join.removeFromSelect('" + op.scope("value") + "','" + ord + "','" + op.getPath() + "'," + unassignMode + ");"));
            out.w((Object)("join.allSelect('" + op.scope("value") + "');"));
            SaveCommand.setModified(op);
        }
    }

    public boolean isUnassignMode(HxOp op) {
        String mode = (String)op.getRequest().getSession().getAttribute(op.scope("learnMode"));
        return mode != null && mode.equals("true");
    }

    public boolean isSingleAssignment(HxOp op) {
        return false;
    }

    public void setUnassignMode(boolean mode, HxOp op) {
        op.getRequest().getSession().setAttribute(op.scope("learnMode"), (Object)("" + mode));
    }

    public static void showDiv(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"hx.$('").w((Object)op.scope("discoverDiv")).w((Object)"').style.display='';");
    }

    public BComponent getComponent(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BComponent)) {
            o = t.get();
            t = t.getBaseOrdTarget();
        }
        return (BComponent)t.get();
    }

    public boolean getIsMounted(HxOp op) {
        BBoolean isMounted = (BBoolean)op.getRequest().getSession().getAttribute(op.scope(IS_MOUNTED));
        if (isMounted == null) {
            return false;
        }
        return isMounted.getBoolean();
    }

    public void setIsMounted(HxOp op) {
        BComponent c = this.getComponent(op);
        op.getRequest().getSession().setAttribute(op.scope(IS_MOUNTED), (Object)BBoolean.make((boolean)c.isMounted()));
    }

    public static HxOp getParentOp(HxOp op) {
        return (HxOp)op.getAttribute(op.scope("parentOp"));
    }

    public static BHxAssignmentFE getHxAssignmentFE(HxOp op) {
        return (BHxAssignmentFE)op.getAttribute(op.scope("parentView"));
    }

    public static TableContents updateContents(TableContents contents, HxOp op) throws Exception {
        String value;
        HxOp parentOp = BHxAssignmentFE.getParentOp(op);
        String[] values = null;
        if (HxUtil.isPost((HxOp)op) && (value = parentOp.getUnsafeFormValue("valueAll")) != null) {
            values = TextUtil.split((String)value, (char)'|');
        }
        for (int i = 0; i < contents.tr.size(); ++i) {
            TableContents.Tr tr = contents.tr.get(i);
            for (int j = 0; values != null && j < values.length; ++j) {
                if (!BHxSmartTableView.scopeId(values[j], op).equals(tr.id)) continue;
                for (int k = 0; k < tr.td.size(); ++k) {
                    tr.td.get((int)k).additionalClassName = "row-disabled";
                }
            }
        }
        return contents;
    }

    public static class Assign
    extends SmartCommand {
        public Assign(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "assign";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            HxOp parentOp = BHxAssignmentFE.getParentOp(op);
            BHxAssignmentFE assignmentFE = BHxAssignmentFE.getHxAssignmentFE(parentOp);
            String[] selectionList = SmartCommand.getSelectionList(op);
            for (int i = 0; i < selectionList.length; ++i) {
                assignmentFE.assign(BOrd.make((String)selectionList[i]), parentOp);
            }
        }
    }

    public static class Unassign
    extends SmartCommand {
        private ToggleCommand learnModeCommand;

        public Unassign(BHxView view, ToggleCommand learnModeCommand) {
            super(view);
            this.learnModeCommand = learnModeCommand;
        }

        @Override
        public String getName(HxOp op) {
            return "unassign";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            HxOp parentOp = BHxAssignmentFE.getParentOp(op);
            BHxAssignmentFE assignmentFE = BHxAssignmentFE.getHxAssignmentFE(parentOp);
            String[] selectionList = SmartCommand.getSelectionList(op);
            for (int i = 0; i < selectionList.length; ++i) {
                assignmentFE.unassign(BOrd.make((String)selectionList[i]), parentOp);
            }
        }
    }

    public static class AssignmentMode
    extends ToggleCommand {
        public AssignmentMode(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "learnMode";
        }

        @Override
        public boolean isTableCommand(HxOp op) {
            return true;
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            HxOp parentOp = BHxAssignmentFE.getParentOp(op);
            StringBuffer b = new StringBuffer();
            b.append("var all = smartTable.$$(").append(quote).append(parentOp.scope("valueAll")).append(quote).append(");");
            b.append("if(all == null || all.value.length == 0 || confirm(");
            b.append("join.getConfirmMessage()");
            b.append("))");
            b.append("{");
            b.append(super.getEnabledInvokeCode(op));
            b.append("}");
            return b.toString();
        }

        @Override
        public boolean isSelected(HxOp op) {
            HxOp parentOp = BHxAssignmentFE.getParentOp(op);
            return BHxAssignmentFE.getHxAssignmentFE(parentOp).isUnassignMode(parentOp);
        }

        @Override
        public boolean handle(boolean selected, HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            HxOp parentOp = BHxAssignmentFE.getParentOp(op);
            BHxAssignmentFE assignmentFE = BHxAssignmentFE.getHxAssignmentFE(parentOp);
            assignmentFE.setUnassignMode(!selected, parentOp);
            Tab[] tabs = assignmentFE.getTabs(parentOp);
            for (int i = 0; i < tabs.length; ++i) {
                if (!(tabs[i].view instanceof BHxSmartTableView)) continue;
                ((BHxSmartTableView)tabs[i].view).reloadTable(tabs[i].op);
                String title = ((BHxSmartTableView)tabs[i].view).getPageTitle(tabs[i].op);
                out.w((Object)"smartTable.setTitle('").safe((Object)title).w((Object)"','").w((Object)tabs[i].op.getPath()).w((Object)"');");
                int height = 300;
                if (!((BHxSmartTableView)tabs[i].view).isEnabled(tabs[i].op)) {
                    height = 125;
                    out.w((Object)"smartTable.resetTable('").w((Object)tabs[i].op.getPath()).w((Object)"');");
                    out.w((Object)"hx.$('").w((Object)tabs[i].op.scope("paginationBar")).w((Object)"').style.display='none';");
                    out.w((Object)"var loading = hx.$('").w((Object)tabs[i].op.scope("loading")).w((Object)"'); loading.innerHTML='&nbsp;'; loading.style.color='black';");
                }
                out.w((Object)"hx.$('").w((Object)tabs[i].op.scope("records")).w((Object)("').parentNode.style.height='" + height + "px';"));
            }
            out.w((Object)("join.clearAllSelect('" + parentOp.scope("value") + "','" + parentOp.getPath() + "');"));
            SmartCommand.setFormValue(parentOp.scope("valueAll"), "", parentOp);
            BHxAssignmentFE.showDiv(parentOp);
            return !selected;
        }
    }
}

