/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import java.util.HashSet;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BFont;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

public class BHxFontFE
extends BHxFieldEditor {
    private static final LexiconModule lex = LexiconModule.make(BHxFontFE.class);
    public static final BHxFontFE INSTANCE = new BHxFontFE();
    public static final Type TYPE = Sys.loadType(BHxFontFE.class);
    public String fontsLocation = "module://fonts/microFont";
    private static int[] fontSizes = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};

    public Type getType() {
        return TYPE;
    }

    protected BHxFontFE() {
    }

    public BFont getFont(HxOp op) throws Exception {
        BValue value = (BValue)op.get();
        if (value instanceof BString) {
            return (BFont)BFont.DEFAULT.decodeFromString(((BString)value).getString());
        }
        return (BFont)value;
    }

    public void write(HxOp op) throws Exception {
        int i;
        BFont value = this.getFont(op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table style='border: 1px solid black'><tr><td>");
        out.w((Object)"<select ");
        this.scope("name", out, op);
        if (!op.canWrite()) {
            out.attr(" disabled", "disabled");
        }
        out.w((Object)" onmouseover='document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontFamily=this.value;'");
        out.w((Object)"onkeypress='document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontFamily=this.value;'");
        out.w((Object)"onchange='document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontFamily=this.value;'");
        out.w((Object)">");
        String[] fontNames = this.getFontNames();
        for (i = 0; i < fontNames.length; ++i) {
            out.w((Object)"<option style='font-family: ").safe((Object)fontNames[i]).w((Object)"'");
            if (fontNames[i].equals(value.getName())) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)"value='").safe((Object)fontNames[i]).w((Object)"'");
            out.w((Object)">").safe((Object)fontNames[i]).w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"<select ");
        this.scope("size", out, op);
        if (!op.canWrite()) {
            out.attr(" disabled", "disabled");
        }
        out.w((Object)"onmouseover='document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontSize=this.value+&quot;px&quot;;'");
        out.w((Object)"onkeypress='document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontSize=this.value+&quot;px&quot;;'");
        out.w((Object)"onchange='document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontSize=this.value+&quot;px&quot;;'");
        out.w((Object)">");
        for (i = 0; i < fontSizes.length; ++i) {
            out.w((Object)"<option ");
            if ((double)fontSizes[i] == value.getSize()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)"value='").w(fontSizes[i]).w((Object)"'");
            out.w((Object)">").w(fontSizes[i]).w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"</td><td ");
        this.scope("preview", out, op);
        out.w((Object)"rowspan='2'style='");
        if (value.isUnderline()) {
            out.w((Object)"text-decoration: underline ;");
        }
        out.w((Object)"font: ");
        if (value.isBold()) {
            out.w((Object)"bold ");
        }
        if (value.isItalic()) {
            out.w((Object)"italic ");
        }
        out.w(value.getSize()).w((Object)"px ").w((Object)value.getName()).w((Object)" '>");
        out.w((Object)lex.getHtmlSafeText("aaBbYyZz", (Context)op));
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td valign='top'>");
        out.w((Object)"&nbsp;<b>B</b>");
        out.w((Object)"<input type='checkbox' ");
        this.scope("bold", out, op);
        if (!op.canWrite()) {
            out.attr(" disabled", "disabled");
        }
        if (value.isBold()) {
            out.w((Object)"checked");
        }
        out.w((Object)" onclick='var x=&quot;&quot;;if (this.checked) x=&quot;bold&quot;;");
        out.w((Object)"document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontWeight=x;'");
        out.w((Object)"/>");
        out.w((Object)"&nbsp;<i>I</i>");
        out.w((Object)"<input type='checkbox' ");
        this.scope("italic", out, op);
        if (!op.canWrite()) {
            out.attr(" disabled", "disabled");
        }
        if (value.isItalic()) {
            out.w((Object)"checked");
        }
        out.w((Object)" onclick='var x=&quot;&quot;; if (this.checked) x=&quot;italic&quot;;");
        out.w((Object)"document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.fontStyle=x;'");
        out.w((Object)"/>");
        out.w((Object)"&nbsp;<u>U</u>");
        out.w((Object)"<input type='checkbox' ");
        this.scope("underline", out, op);
        if (!op.canWrite()) {
            out.attr(" disabled", "disabled");
        }
        if (value.isUnderline()) {
            out.w((Object)"checked");
        }
        out.w((Object)" onclick='var x=&quot;&quot;;if (this.checked) x=&quot;underline&quot;;");
        out.w((Object)"document.getElementById(&quot;");
        out.w((Object)op.scope("preview")).w((Object)"&quot;).style.textDecoration=x;'");
        out.w((Object)"/>");
        out.w((Object)"</td></tr></table>");
    }

    public BObject save(HxOp op) throws Exception {
        String underline;
        String italic;
        String name = op.getFormValue("name");
        String sizeForm = op.getFormValue("size");
        if (sizeForm == null) {
            return op.get();
        }
        int size = Integer.parseInt(sizeForm);
        int style = 0;
        String bold = op.getFormValue("bold");
        if (bold != null) {
            style |= 1;
        }
        if ((italic = op.getFormValue("italic")) != null) {
            style |= 2;
        }
        if ((underline = op.getFormValue("underline")) != null) {
            style |= 4;
        }
        BFont font = BFont.make((String)name, (double)size, (int)style);
        if (op.get() instanceof BFont) {
            return font;
        }
        return BString.make((String)font.encodeToString());
    }

    public HtmlWriter scope(String name, HtmlWriter out, HxOp op) {
        out.w((Object)" name='").w((Object)op.scope(name)).w((Object)"'");
        out.w((Object)" id='").w((Object)op.scope(name)).w((Object)"' ");
        return out;
    }

    private String[] getFontNames() {
        HashSet<String> fonts = new HashSet<String>();
        BOrd fontsOrd = BOrd.make((String)this.fontsLocation);
        BIDirectory dir = (BIDirectory)fontsOrd.resolve().get();
        BIFile[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getFileName();
            int index = name.indexOf("pt ");
            name = name.substring(index + 3);
            index = name.indexOf(".");
            name = name.substring(0, index);
            fonts.add(name);
        }
        return fonts.toArray(new String[fonts.size()]);
    }
}

