/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.sys.Nre;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BExportFileWrapper
extends BStruct
implements BINavNode {
    public static final Property uuid = BExportFileWrapper.newProperty((int)0, (BValue)BUuid.DEFAULT, null);
    public static final Property fileName = BExportFileWrapper.newProperty((int)0, (String)"", null);
    public static final Property contentType = BExportFileWrapper.newProperty((int)0, (String)"", null);
    public static final Property timestamp = BExportFileWrapper.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BExportFileWrapper.class);
    private OutputStream outputStream;
    private InputStream inputStream;
    private File tempFile;
    private int length;

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    public String getFileName() {
        return this.getString(fileName);
    }

    public void setFileName(String v) {
        this.setString(fileName, v, null);
    }

    public String getContentType() {
        return this.getString(contentType);
    }

    public void setContentType(String v) {
        this.setString(contentType, v, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BExportFileWrapper() {
        this.setUuid(BUuid.make());
    }

    public BExportFileWrapper(String fileName) {
        this();
        this.setFileName(fileName);
        try {
            String fileExt = FileUtil.getExtension((String)fileName);
            TypeInfo info = Sys.getRegistry().getFileTypeForExtension(fileExt);
            BIFile file = (BIFile)info.getTypeSpec().getInstance();
            this.setContentType(file.getMimeType());
        }
        catch (Exception e) {
            this.setContentType(new BDataFile().getMimeType());
        }
    }

    public OutputStream getOutputStream() throws Exception {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.tempFile != null) {
            this.outputStream = new FileOutputStream(this.tempFile);
            return this.outputStream;
        }
        this.outputStream = new ByteArrayOutputStream();
        return this.outputStream;
    }

    public byte[] getBytes() throws Exception {
        byte[] bytes = new byte[this.length];
        this.getInputStream().read(bytes);
        return bytes;
    }

    public File getFile() {
        return this.tempFile;
    }

    public void closeOutput() throws Exception {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
            if (this.outputStream instanceof ByteArrayOutputStream) {
                this.length = ((ByteArrayOutputStream)this.outputStream).size();
            }
        }
        if (this.tempFile != null) {
            this.length = (int)this.tempFile.length();
        }
    }

    public void closeInput() throws Exception {
        boolean canDelete;
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.tempFile != null && !(canDelete = this.tempFile.delete())) {
            this.tempFile.deleteOnExit();
        }
    }

    public InputStream getInputStream() throws Exception {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.tempFile != null) {
            this.inputStream = new FileInputStream(this.tempFile);
            return this.inputStream;
        }
        byte[] bytes = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        this.length = bytes.length;
        this.inputStream = new ByteArrayInputStream(bytes);
        return this.inputStream;
    }

    public void init() throws Exception {
        String hostModel = Nre.getHostModel();
        if (hostModel.equals("Workstation")) {
            this.initTempFile();
        } else {
            this.initBuffer();
        }
    }

    public void initBuffer() throws Exception {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
    }

    public void initTempFile() throws Exception {
        if (this.tempFile == null) {
            this.tempFile = File.createTempFile("" + this.getUuid(), ".tempExport");
        }
    }

    public String getNavName() {
        return this.getFileName();
    }

    public String getNavDisplayName(Context cx) {
        return this.getNavName();
    }

    public BINavNode getNavParent() {
        BComponent parent = (BComponent)this.getParent();
        if (parent != null) {
            return parent;
        }
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode getNavChild(String navName) {
        return null;
    }

    public BINavNode resolveNavChild(String navName) {
        throw new UnresolvedException(navName);
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public boolean isNavChild() {
        return true;
    }

    public String getNavDescription(Context cx) {
        return this.getType().toString();
    }

    public BOrd getNavOrd() {
        return BOrd.make((String)("exportFile:/" + this.getUuid() + "|view:?fullScreen=true;"));
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }
}

