/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.smartTableHx.export.BExportFileWrapper;
import com.tridium.smartTableHx.export.ExportFileQuery;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BExportFileScheme
extends BOrdScheme {
    public static final BExportFileScheme INSTANCE = new BExportFileScheme();
    public static final Type TYPE = Sys.loadType(BExportFileScheme.class);
    private static Map<String, BExportFileWrapper> hashMap = new HashMap<String, BExportFileWrapper>();
    static long THIRTY_SECONDS = 30000L;
    static long FIVE_MINUTES = 300000L;
    private static TempCleaner tempCleaner;
    public static final BExportFileWrapper errorWrapper;

    public Type getType() {
        return TYPE;
    }

    private BExportFileScheme() {
        super("exportFile");
    }

    public OrdQuery parse(String queryBody) {
        return new ExportFileQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        ExportFileQuery sq = (ExportFileQuery)query;
        String uuid = sq.nameAt(0);
        BExportFileWrapper found = hashMap.get(uuid);
        if (found == null) {
            return new OrdTarget(base, (BObject)errorWrapper);
        }
        found.setTimestamp(BAbsTime.now().subtract(BRelTime.make((long)(FIVE_MINUTES - THIRTY_SECONDS))));
        return new OrdTarget(base, (BObject)found);
    }

    public static void addWrapper(BExportFileWrapper wrapper) {
        wrapper.setTimestamp(BAbsTime.now());
        hashMap.put(wrapper.getUuid().toString(), wrapper);
        BExportFileScheme.startTempCleaner();
    }

    static void startTempCleaner() {
        if (tempCleaner == null) {
            tempCleaner = new TempCleaner();
            tempCleaner.start();
        }
    }

    static void removeTempCleaner() {
        tempCleaner = null;
    }

    static {
        errorWrapper = new BExportFileWrapper();
    }

    static class TempCleaner
    extends Thread {
        TempCleaner() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    boolean keepAlive;
                    do {
                        Thread.sleep(THIRTY_SECONDS);
                        Object[] values = hashMap.values().toArray();
                        keepAlive = false;
                        for (int i = 0; i < values.length; ++i) {
                            BExportFileWrapper wrapper = (BExportFileWrapper)((Object)values[i]);
                            if (wrapper.getTimestamp().getMillis() < BAbsTime.now().getMillis() - FIVE_MINUTES) {
                                hashMap.remove(wrapper.getUuid().toString());
                                continue;
                            }
                            keepAlive = true;
                        }
                    } while (keepAlive);
                    BExportFileScheme.removeTempCleaner();
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

