/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.FinishTableCommand;
import com.tridium.smartTableHx.IFinishableTable;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebService;

public class FinishTableThread
extends Thread {
    HxOp op;
    public IFinishableTable finishableTable;
    public TableContents contents;
    public volatile boolean running;
    public boolean started;
    public boolean paused = false;
    public boolean killed = false;
    public long ticks;
    boolean cachePage = false;
    boolean used = false;
    BAbsTime touch = BAbsTime.NULL;
    private Object monitor = new Object();
    private static final Map<String, FinishTableThread> values = new HashMap<String, FinishTableThread>();
    private static CacheCleaner cacheCleaner = null;
    private static volatile int runningCount = 0;
    static final BRelTime CACHE_LIFE = BRelTime.make((long)(HxUtil.getPollFreq() * 12));
    static final int CACHE_THRESHOLD = AccessController.doPrivileged(() -> Integer.getInteger("niagara.smartTable.cache.threshold", 100));
    static final int CACHE_ENTRY_MAX_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.smartTable.cache.maxSizePerEntry", 1000));
    static int SLEEP_TIME = AccessController.doPrivileged(() -> Integer.getInteger("niagara.smartTable.sleep", 0));
    static final Logger LOGGER = Logger.getLogger("com.tridium.smartTableHx");
    private static boolean DEBUG = false;

    private FinishTableThread() {
        super("FinishTableThread");
    }

    public FinishTableThread(IFinishableTable finishableTable) {
        this(finishableTable, false);
    }

    public FinishTableThread(IFinishableTable finishableTable, boolean cachePage) {
        super("FinishTableThread");
        this.running = true;
        this.started = false;
        this.finishableTable = finishableTable;
        this.contents = null;
        this.cachePage = cachePage;
        this.used = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAndWait(HxOp op, FinishTableCommand command) throws Exception {
        if (!this.increaseRunningCount()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("try again later");
            }
            StringBuilder buf = new StringBuilder();
            buf.append("setTimeout('hx.fireEvent(\"");
            buf.append(op.getPath());
            buf.append("\",\"");
            buf.append(command.getId());
            buf.append("\");', 750);");
            op.getHtmlWriter().w((Object)buf.toString());
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            block14: {
                if (this.getState() == Thread.State.NEW) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("start thread");
                    }
                    this.op = op;
                    this.start();
                } else {
                    this.decreaseRunningCount();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("thread already started");
                    }
                }
                try {
                    if (this.running) {
                        this.monitor.wait();
                    }
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block14;
                    LOGGER.fine("InterruptedException");
                }
            }
            if (this.contents == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("no contents, try again later");
                }
                StringBuilder buf = new StringBuilder();
                buf.append("setTimeout('hx.fireEvent(\"");
                buf.append(op.getPath());
                buf.append("\",\"");
                buf.append(command.getId());
                buf.append("\");', 750);");
                op.getHtmlWriter().w((Object)buf.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.monitor;
        synchronized (object) {
            this.started = true;
            try {
                this.contents = this.finishableTable.writeContents(this.op);
                if (!this.running) {
                    this.contents = null;
                }
                if (SLEEP_TIME > 0) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("sleeping for " + SLEEP_TIME);
                    }
                    Thread.sleep(SLEEP_TIME);
                }
                if (this.cachePage && this.contents != null && this.finishableTable instanceof BHxSmartTableView) {
                    this.contents.hashCode();
                    BHxSmartTableView sView = (BHxSmartTableView)this.finishableTable;
                    int page = sView.getPage(this.op);
                    int pageSize = sView.getPageSize(this.op);
                    TableContents pData = this.contents.getPage(page - 1, pageSize);
                    pData.hashCode();
                    if (sView.supportsPagination(this.op)) {
                        FinishTableThread.startCacheCleaner();
                    }
                }
            }
            catch (InterruptedException e) {
                this.contents = null;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("InterruptedException");
                }
            }
            catch (Throwable e) {
                this.contents = null;
                if (e instanceof BajaRuntimeException && e.getCause() instanceof InterruptedException) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("InterruptedException");
                    }
                    return;
                }
                LOGGER.log(Level.SEVERE, "Cannot write contents", e);
                this.op.getRequest().getSession().setAttribute(this.op.scope("finishTableException"), (Object)e);
            }
            finally {
                this.op = null;
                this.running = false;
                this.decreaseRunningCount();
                this.monitor.notifyAll();
            }
        }
    }

    public void kill() {
        this.running = false;
        this.killed = true;
        this.interrupt();
    }

    public void pause() {
        this.paused = true;
        this.kill();
    }

    @Override
    public String toString() {
        return "" + this.ticks;
    }

    public static void add(FinishTableThread thread, HxOp op) {
        FinishTableThread.add(thread, op, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(FinishTableThread thread, HxOp op, boolean onlyIfEmpty) {
        String key = SmartCommand.universalScope("", op);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("FinishTableThread add:" + key);
        }
        Map<String, FinishTableThread> map = values;
        synchronized (map) {
            if (!onlyIfEmpty || values.get(key) == null) {
                values.put(key, thread);
            }
            if (thread != null) {
                thread.touch = BAbsTime.now();
            }
        }
        FinishTableThread.startCacheCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FinishTableThread remove(HxOp op) {
        String key = SmartCommand.universalScope("", op);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("FinishTableThread remove:" + key);
        }
        Map<String, FinishTableThread> map = values;
        synchronized (map) {
            return values.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FinishTableThread get(HxOp op) {
        String key = SmartCommand.universalScope("", op);
        Map<String, FinishTableThread> map = values;
        synchronized (map) {
            FinishTableThread thread = values.get(key);
            if (thread != null) {
                thread.touch = BAbsTime.now();
            }
            return thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FinishTableThread get(HxOp op, int contentsThreshold) {
        String key = SmartCommand.universalScope("", op);
        int size = 0;
        FinishTableThread thread = null;
        BRelTime bRelTime = values;
        synchronized (bRelTime) {
            thread = values.get(key);
            if (thread != null) {
                if (!thread.running) {
                    thread.used = true;
                }
                if (!(thread.running || thread.contents != null && thread.contents.getRecordCount() <= contentsThreshold)) {
                    values.remove(key);
                } else {
                    thread.touch = BAbsTime.now();
                }
            }
            size = values.size();
        }
        if (size > CACHE_THRESHOLD && CACHE_THRESHOLD > 0) {
            bRelTime = CACHE_LIFE;
            synchronized (bRelTime) {
                CACHE_LIFE.notify();
            }
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startCacheCleaner() {
        Map<String, FinishTableThread> map = values;
        synchronized (map) {
            if (cacheCleaner == null) {
                LOGGER.fine("FinishTableCacheCleaner start");
                cacheCleaner = new CacheCleaner();
                cacheCleaner.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeCacheCleaner() {
        Map<String, FinishTableThread> map = values;
        synchronized (map) {
            cacheCleaner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean increaseRunningCount() {
        Map<String, FinishTableThread> map = values;
        synchronized (map) {
            if (runningCount >= FinishTableThread.getMaxConcurrent()) {
                return false;
            }
            ++runningCount;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("countIncrease: " + runningCount);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseRunningCount() {
        Map<String, FinishTableThread> map = values;
        synchronized (map) {
            --runningCount;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("countDecrease: " + runningCount);
            }
        }
    }

    public static int getMaxConcurrent() {
        int max = Math.max(1, (int)Math.floor((double)FinishTableThread.getMaxWebServiceThreads() / 4.0));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("maxConcurrent:" + max);
        }
        return max;
    }

    public static int getMaxWebServiceThreads() {
        BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
        for (BWebServer server : (BWebServer[])service.getChildren(BWebServer.class)) {
            BValue o = server.get("maxThreads");
            if (!(o instanceof BInteger)) continue;
            return ((BInteger)o).getInt();
        }
        return 1;
    }

    static class CacheCleaner
    extends Thread {
        public CacheCleaner() {
            super("FinishTableCacheCleaner");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (true) {
                    BAbsTime now = BAbsTime.now();
                    BRelTime bRelTime = CACHE_LIFE;
                    // MONITORENTER : bRelTime
                    CACHE_LIFE.wait(CACHE_LIFE.getMillis());
                    // MONITOREXIT : bRelTime
                    long delta = now.delta(BAbsTime.now()).getMillis();
                    if (delta < 10000L && !DEBUG) {
                        Thread.sleep(Math.max(10000L - delta, 100L));
                    }
                    Map map = values;
                    // MONITORENTER : map
                    int size = values.size();
                    if (size <= 0) {
                        FinishTableThread.removeCacheCleaner();
                        // MONITOREXIT : map
                        LOGGER.fine("FinishTableCacheCleaner complete");
                        return;
                    }
                    String[] keys = values.keySet().toArray(new String[values.keySet().size()]);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("FinishTableCacheCleaner size:" + keys.length);
                        if (LOGGER.isLoggable(Level.FINER)) {
                            for (int i = 0; i < keys.length; ++i) {
                                LOGGER.finer("FinishTableCacheCleaner still active:" + keys[i]);
                            }
                        }
                    }
                    Array usedKeys = new Array(String.class);
                    Array lastTouched = new Array(BAbsTime.class);
                    for (int i = 0; i < keys.length; ++i) {
                        FinishTableThread thread = (FinishTableThread)values.get(keys[i]);
                        if (thread == null || thread.touch != BAbsTime.NULL && thread.touch.isBefore(BAbsTime.now().subtract(CACHE_LIFE))) {
                            values.remove(keys[i]);
                            --size;
                            continue;
                        }
                        if (!thread.used) continue;
                        usedKeys.add((Object)keys[i]);
                        lastTouched.add((Object)thread.touch);
                    }
                    if (size > CACHE_THRESHOLD && CACHE_THRESHOLD > 0) {
                        Object[] oldestKeys = (String[])usedKeys.trim();
                        Object[] sortBy = (BAbsTime[])lastTouched.trim();
                        SortUtil.sort((Object[])sortBy, (Object[])oldestKeys);
                        int numToDelete = Math.min(oldestKeys.length, size - CACHE_THRESHOLD);
                        for (int i = 0; i < numToDelete; ++i) {
                            values.remove(oldestKeys[i]);
                        }
                    } else if (values.size() <= 0) {
                        FinishTableThread.removeCacheCleaner();
                        // MONITOREXIT : map
                        LOGGER.fine("FinishTableCacheCleaner complete");
                        return;
                    }
                    // MONITOREXIT : map
                    continue;
                    break;
                }
                catch (Exception e) {
                    FinishTableThread.removeCacheCleaner();
                    e.printStackTrace();
                    return;
                }
            }
            finally {
                LOGGER.fine("FinishTableCacheCleaner complete");
            }
        }
    }
}

