/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxCollectionTableView
extends BHxSmartTableView {
    public static final BHxCollectionTableView INSTANCE = new BHxCollectionTableView();
    public static final Type TYPE = Sys.loadType(BHxCollectionTableView.class);
    public static final String SLOT_PATH = "slotPath";
    protected SmartCommand hyperlinkCommand = new HyperlinkCommand(this);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxCollectionTableView() {
        this.registerEvent((Event)this.hyperlinkCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.hyperlinkCommand};
    }

    public BITable<?> getTable(HxOp op) {
        return (BITable)op.get();
    }

    @Override
    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BITable<?> table = this.getTable(op);
        Column[] columns = table.getColumns().list();
        int visibleColumnCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equals(SLOT_PATH)) continue;
            out.w((Object)"<th ");
            out.attr("id", op.scope("" + visibleColumnCount));
            out.w((Object)"'>");
            out.safe((Object)columns[i].getDisplayName((Context)op));
            out.w((Object)"</th>");
            ++visibleColumnCount;
        }
    }

    @Override
    public TableContents writeContents(HxOp op) throws Exception {
        TableContents t = new TableContents(op.scope("records"));
        BITable<?> table = this.getTable(op);
        TableCursor c = table.cursor();
        Column[] columns = table.getColumns().list();
        for (int j = 0; j < columns.length; ++j) {
            t.columns.td.add(new TableContents.Td(columns[j].getDisplayName((Context)op)));
        }
        while (c.next()) {
            TableContents.Tr tr = new TableContents.Tr();
            Column idColumn = table.getColumns().get(SLOT_PATH);
            tr.id = idColumn != null ? "" + c.cell(idColumn).toString() : "";
            for (int j = 0; j < columns.length; ++j) {
                if (columns[j].getName().equals(SLOT_PATH)) continue;
                tr.td.add(new TableContents.Td(c.cell(columns[j]).toString()));
            }
            t.tr.add(tr);
        }
        return t;
    }

    public static class HyperlinkCommand
    extends SmartCommand {
        public HyperlinkCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        @Override
        public String getName(HxOp op) {
            return "hyperlink";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        @Override
        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList(op);
            if (selectionList.length == 1) {
                this.redirect(op, op.toUri(BOrd.make((String)("station:|" + selectionList[0]))));
            }
        }
    }
}

