/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall.ui;

import com.tridium.oncall.BOnCallContact;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.export.BOnCallUserReportPdfExporter;
import com.tridium.oncall.util.BOnCallContactUserEventInfo;
import com.tridium.oncall.util.OnCallToolkit;
import com.tridium.ui.UiEnv;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public final class BOnCallUserReportView
extends BWbComponentView {
    public static final Action refresh = BOnCallUserReportView.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BOnCallUserReportView.class);
    private BEdgePane pane = new BEdgePane();
    private BWbFieldEditor startFe = BWbFieldEditor.makeFor((BObject)BAbsTime.NULL);
    private BWbFieldEditor endFe = BWbFieldEditor.makeFor((BObject)BAbsTime.NULL);
    private Context lastCx = null;
    private static BAbsTime lastStart = BAbsTime.now();
    private static BAbsTime lastEnd = BAbsTime.now().nextMonth();
    private static final Lexicon LEX = Lexicon.make(BOnCallUserReportView.class);
    private static final BFacets DATE_TIME_FACETS = BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTime", (BIDataValue)BBoolean.FALSE, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE);

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOnCallUserReportView() {
        this.linkTo((BComponent)this.startFe, (Slot)BWbPlugin.setModified, (Slot)refresh);
        this.linkTo((BComponent)this.endFe, (Slot)BWbPlugin.setModified, (Slot)refresh);
        BGridPane grid = new BGridPane(4);
        grid.setHalign(BHalign.left);
        grid.add(null, (BValue)new BBorderPane((BWidget)new BLabel("Start: "), 0.0, 0.0, 0.0, 10.0));
        grid.add(null, (BValue)new BBorderPane((BWidget)this.startFe, 10.0, 10.0, 10.0, 0.0));
        grid.add(null, (BValue)new BBorderPane((BWidget)new BLabel("End: "), 0.0, 0.0, 0.0, 10.0));
        grid.add(null, (BValue)new BBorderPane((BWidget)this.endFe, 10.0, 10.0, 10.0, 0.0));
        this.pane.setTop((BWidget)grid);
        this.setContent((BWidget)this.pane);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.lastCx = context;
        this.startFe.loadValue((BObject)lastStart, (Context)new BasicContext(context, DATE_TIME_FACETS));
        this.endFe.loadValue((BObject)lastEnd, (Context)new BasicContext(context, DATE_TIME_FACETS));
        this.refresh();
    }

    public void deactivated() {
        try {
            lastStart = (BAbsTime)this.startFe.saveValue();
            lastEnd = (BAbsTime)this.endFe.saveValue();
        }
        catch (Exception e) {
            OnCallToolkit.log.error("Saving dates for User Report View", (Throwable)e);
        }
    }

    public void doRefresh() throws Exception {
        UiEnv.get().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BOnCallUserReportView.this.enterBusy();
                    BOnCallContact contact = (BOnCallContact)BOnCallUserReportView.this.getCurrentValue();
                    BOnCallService srv = (BOnCallService)BOrd.make((String)"service:onCall:OnCallService").get((BObject)contact);
                    BAbsTime start = (BAbsTime)BOnCallUserReportView.this.startFe.saveValue();
                    BAbsTime end = (BAbsTime)BOnCallUserReportView.this.endFe.saveValue();
                    if (end.isBefore(start)) {
                        BOnCallUserReportView.this.pane.setCenter((BWidget)new BLabel(LEX.getText("userReport.startEndTimeError")));
                        return;
                    }
                    BComponent info = new BComponent();
                    info.add("ord", (BValue)contact.getHandleOrd());
                    info.add("start", (BValue)start);
                    info.add("end", (BValue)end);
                    BComponent result = srv.createUserReport(info);
                    BOnCallContactUserEventInfo[] evs = (BOnCallContactUserEventInfo[])result.getChildren(BOnCallContactUserEventInfo.class);
                    BTable table = new BTable((TableModel)new BOnCallUserReportPdfExporter.Model(evs, BOnCallUserReportView.this.lastCx));
                    BOnCallUserReportView.this.pane.setCenter((BWidget)BTitlePane.makePane((String)LEX.getText("userReport.report"), (BTable)table));
                }
                catch (Exception e) {
                    OnCallToolkit.log.error("Loading On Call Contact User Report", (Throwable)e);
                    try {
                        BOnCallUserReportView.this.pane.setCenter((BWidget)new BNullWidget());
                        BDialog.error((BWidget)BOnCallUserReportView.this, (String)LEX.getText("userReport.reportError"), (Object)LEX.getText("userReport.errorCouldNotLoad"), (Throwable)e);
                    }
                    catch (Exception e2) {
                        OnCallToolkit.log.error("Fatal error loading report", (Throwable)e2);
                    }
                }
                finally {
                    BOnCallUserReportView.this.exitBusy();
                }
            }
        });
    }

    public BAbsTime getStart() {
        try {
            return (BAbsTime)this.startFe.saveValue();
        }
        catch (Exception e) {
            return BAbsTime.NULL;
        }
    }

    public BAbsTime getEnd() {
        try {
            return (BAbsTime)this.endFe.saveValue();
        }
        catch (Exception e) {
            return BAbsTime.NULL;
        }
    }
}

