/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall.ui;

import com.tridium.oncall.BOnCallContact;
import com.tridium.oncall.BOnCallList;
import com.tridium.oncall.ui.BOnCallListManager;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public final class BOnCallContactManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BOnCallContactManager.class);
    private MgrColumn colPath = new MgrColumn.Path(2);
    private MgrColumn colName = new MgrColumn.Name(5);
    private MgrColumn colStatus = new MgrColumn.Prop(BOnCallContact.status, 4);
    private MgrColumn colEnabled = new MgrColumn.Prop(BOnCallContact.enabled, 1);
    private MgrColumn colPriority = new MgrColumn.Prop(BOnCallContact.priority, 1);
    private MgrColumn colEmployee = new OrdDisplayNameProp(BOnCallContact.user, 1);
    private MgrColumn colUserAlarmReceipient = new OrdDisplayNameProp(BOnCallContact.userAlarmRecipient, 1);
    private MgrColumn colRotationMarked = new MgrColumn.Prop(BOnCallContact.rotationMarker, 6);
    private MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colStatus, this.colEnabled, this.colPriority, this.colEmployee, this.colUserAlarmReceipient, this.colRotationMarked};
    private static final Lexicon lex = Lexicon.make(BOnCallListManager.class);

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private static class OrdDisplayNameProp
    extends MgrColumn.Prop {
        public OrdDisplayNameProp(Property prop, int flags) {
            super(prop, flags);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (value instanceof BOrd) {
                if (((BOrd)value).isNull()) {
                    return "null";
                }
                BWbShell shell = BWbShell.getWbShell((BWidget)this.getManager());
                if (shell == null) {
                    return "no shell";
                }
                BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)((BOrd)value)).normalize();
                return ((BComponent)ord.get()).getDisplayName(cx);
            }
            return super.toDisplayString(row, value, cx);
        }
    }

    private class RotateCmd
    extends MgrController.MgrCommand {
        public RotateCmd(BWidget owner) {
            super(owner, lex, "commands.rotate");
        }

        public CommandArtifact doInvoke() throws Exception {
            ((BOnCallList)BOnCallContactManager.this.getCurrentValue()).rotate();
            return null;
        }
    }

    class Controller
    extends MgrController {
        private RotateCmd rotateCmd;

        Controller(BOnCallContactManager manager) {
            super((BAbstractManager)manager);
            this.rotateCmd = null;
            this.rotateCmd = new RotateCmd((BWidget)manager);
            this.rotateCmd.setFlags(7);
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent comp = table.getComponentAt(row);
            BWbShell shell = BOnCallContactManager.this.getWbShell();
            if (comp != null && shell != null) {
                shell.hyperlink(comp.getNavOrd());
            }
        }

        public CommandArtifact doNew(Context cx) throws Exception {
            String title = this.newCommand.getLabel();
            MgrTypeInfo[] types = BOnCallContactManager.this.getModel().getNewTypes();
            MgrEdit edit = this.makeEdit(title);
            edit.addRow(new MgrEditRow(BOnCallContactManager.this.getModel().newInstance(types[0]), null, types));
            return edit.invoke(null);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.rotateCmd});
        }
    }

    class Model
    extends MgrModel {
        Model(BOnCallContactManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return BOnCallContactManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BOnCallContact.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BOnCallContact.TYPE);
        }
    }
}

