/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.serial.ui;

import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFlowControlModeFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BFlowControlModeFE.class);
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BFlowControlModeFE.class);
    static final String noneText = lexicon.getText("flowcontrol.none");
    static final String rtsCtsOnInputText = lexicon.getText("flowcontrol.rtsCtsOnInput");
    static final String rtsCtsOnOutputText = lexicon.getText("flowcontrol.rtsCtsOnOutput");
    static final String xonXoffOnInputText = lexicon.getText("flowcontrol.xonXoffOnInput");
    static final String xonXoffOnOutputText = lexicon.getText("flowcontrol.xonXoffOnOutput");
    private boolean init = false;
    private BCheckBox rtsCtsOnInput;
    private BCheckBox rtsCtsOnOutput;
    private BCheckBox xonXoffOnInput;
    private BCheckBox xonXoffOnOutput;
    private BGridPane pane = new BGridPane(4);

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean readonly) {
        this.init = false;
        if (readonly) {
            this.setContent((BWidget)new BTextField("", 15, false));
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        BSerialFlowControlMode status = (BSerialFlowControlMode)value;
        if (this.isReadonly()) {
            ((BTextField)this.getContent()).setText(value.toString());
        } else {
            if (!this.init) {
                this.initCheckBoxes();
            }
            this.rtsCtsOnInput.setSelected(status.isRtsCtsOnInput());
            this.rtsCtsOnOutput.setSelected(status.isRtsCtsOnOutput());
            this.xonXoffOnInput.setSelected(status.isXonXoffOnInput());
            this.xonXoffOnOutput.setSelected(status.isXonXoffOnOutput());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        int bits = 0;
        if (this.rtsCtsOnInput.isSelected()) {
            bits |= 1;
        }
        if (this.rtsCtsOnOutput.isSelected()) {
            bits |= 2;
        }
        if (this.xonXoffOnInput.isSelected()) {
            bits |= 4;
        }
        if (this.xonXoffOnOutput.isSelected()) {
            bits |= 8;
        }
        return BSerialFlowControlMode.make((int)bits);
    }

    public void setColumnCount(int v) {
        this.pane.setColumnCount(v);
        this.relayout();
    }

    private void initCheckBoxes() {
        this.init = true;
        this.rtsCtsOnInput = new BCheckBox(rtsCtsOnInputText);
        this.pane.add("c0", (BValue)this.rtsCtsOnInput, null);
        this.rtsCtsOnOutput = new BCheckBox(rtsCtsOnOutputText);
        this.pane.add("c1", (BValue)this.rtsCtsOnOutput, null);
        this.xonXoffOnInput = new BCheckBox(xonXoffOnInputText);
        this.pane.add("c2", (BValue)this.xonXoffOnInput, null);
        this.xonXoffOnOutput = new BCheckBox(xonXoffOnOutputText);
        this.pane.add("c3", (BValue)this.xonXoffOnOutput, null);
        this.setContent((BWidget)this.pane);
        this.linkTo("lk0", (BComponent)this.rtsCtsOnInput, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.rtsCtsOnOutput, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("lk2", (BComponent)this.xonXoffOnInput, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.xonXoffOnOutput, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
    }
}

