/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth.web;

import com.tridium.clientCertAuth.BClientCertAuthScheme;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.web.Template;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.BILoginHTMLForm;
import javax.servlet.http.HttpServletRequest;

@NiagaraType(agent={@AgentOn(types={"clientCertAuth:ClientCertAuthScheme"})})
public class BClientCertLoginHTMLForm
extends BStruct
implements BILoginHTMLForm {
    public static final Type TYPE = Sys.loadType(BClientCertLoginHTMLForm.class);
    private static final BOrd TEMPLATE_ORD = BOrd.make((String)"module://clientCertAuth/com/tridium/clientCertAuth/web/rc/clientCertAuthLogin.vm");
    private static final String DN_PARAM = "subjectDN";
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public Type getType() {
        return TYPE;
    }

    public void initialize(HttpServletRequest request, Context context) {
        String subjectDN = Lexicon.make((String)"clientCertAuth", (Context)context).get("login.defaultDn");
        X509Certificate[] certChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certChain != null) {
            NX509Certificate clientCertificate = NX509Certificate.make((X509Certificate)certChain[0]);
            subjectDN = clientCertificate.getSubjectDN().toString();
        }
        this.parameters.put(DN_PARAM, subjectDN);
    }

    public String getLoginFormHTML(Context context, boolean passwordReset) throws IOException {
        if (context == null) {
            context = new BasicContext();
        }
        String username = this.getLabel(context, "login.username", Lexicon.make((String)"web"));
        String certificate = this.getLabel(context, "login.certificate", Lexicon.make((String)"clientCertAuth"));
        String changeuser = this.getLabel(context, "login.changeuser", Lexicon.make((String)"web"));
        String login = this.getLabel(context, "login", Lexicon.make((String)"web"));
        String certificateDN = "cn=test, o=tridium, ou=test, dn=tridium, dn=com";
        BString initUsername = (BString)context.getFacet("initUsername");
        String ssoId = "";
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser user = userService.getUser(initUsername.getString());
        if (user.getAuthenticationScheme() instanceof BClientCertAuthScheme) {
            ssoId = user.getAuthenticationSchemeName();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", username);
        map.put("certificate", certificate);
        map.put("certificateDN", (String)this.parameters.get(DN_PARAM));
        map.put("changeUser", changeuser);
        map.put("login", login);
        map.put("ssoId", ssoId);
        if (initUsername != null) {
            map.put("initUsername", initUsername.getString());
        } else {
            map.put("initUsername", "");
        }
        String form = Template.process((BOrd)TEMPLATE_ORD, (boolean)true);
        return Template.process(map, (String)form);
    }

    private String getLabel(Context context, String key, Lexicon lexicon) {
        BString bString = (BString)context.getFacet(key);
        if (bString != null) {
            return bString.getString();
        }
        return lexicon.getHtmlSafe(key);
    }
}

