/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.samlEncryption;

import com.onelogin.saml.Utils;
import com.tridium.saml.SAMLConfigurationException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLResponseException;
import com.tridium.saml.authnScheme.BISamlXmlDecrypter;
import com.tridium.samlEncryption.ValidationError;
import java.io.ByteArrayOutputStream;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NiagaraType
@NiagaraProperty(name="samlServerEncryptionCert", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")")})
public class BSamlXmlDecrypter
extends BComponent
implements BISamlXmlDecrypter {
    public static final Property samlServerEncryptionCert = BSamlXmlDecrypter.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))));
    public static final Type TYPE = Sys.loadType(BSamlXmlDecrypter.class);

    public String getSamlServerEncryptionCert() {
        return this.getString(samlServerEncryptionCert);
    }

    public void setSamlServerEncryptionCert(String v) {
        this.setString(samlServerEncryptionCert, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public X509Certificate getEncryptionCertificate() throws SAMLException {
        IKeyStore keyStore;
        if (this.getSamlServerEncryptionCert().isEmpty()) {
            return null;
        }
        try {
            keyStore = CertManagerFactory.getInstance().getKeyStore();
        }
        catch (Exception e) {
            throw new SAMLException("Error getting keystore", (Throwable)e);
        }
        try {
            X509Certificate encryptionCert = keyStore.getCertificate(this.getSamlServerEncryptionCert());
            if (encryptionCert == null) {
                throw new SAMLConfigurationException(String.format("Invalid signing cert {%s}", this.getSamlServerEncryptionCert()));
            }
            return encryptionCert;
        }
        catch (Exception e) {
            throw new SAMLConfigurationException(String.format("Invalid signing cert {%s}", this.getSamlServerEncryptionCert()), (Throwable)e);
        }
    }

    public Document decryptAssertion(Document dom) throws SAMLException {
        PrivateKey key;
        try {
            key = (PrivateKey)CertManagerFactory.getInstance().getKeyStore().getKey(this.getSamlServerEncryptionCert(), "".toCharArray());
        }
        catch (Exception e) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").get("saml.exception.noPrivateKey"), (Throwable)e);
        }
        try {
            NodeList encryptedDataNodes = Utils.query((Document)dom, (String)"/samlp:Response/saml:EncryptedAssertion/xenc:EncryptedData");
            Element encryptedData = (Element)encryptedDataNodes.item(0);
            this.decryptElement(encryptedData, key);
        }
        catch (XPathExpressionException e) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.noEncryptedData"), (Throwable)e);
        }
        catch (Exception e) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.couldNotDecrypt"), (Throwable)e);
        }
        try {
            NodeList AssertionDataNodes = Utils.query((Document)dom, (String)"/samlp:Response/saml:EncryptedAssertion/saml:Assertion");
            Node assertionNode = AssertionDataNodes.item(0);
            assertionNode.getParentNode().getParentNode().replaceChild(assertionNode, assertionNode.getParentNode());
        }
        catch (XPathExpressionException e) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.noAssertion"), (Throwable)e);
        }
        String xmlStr = BSamlXmlDecrypter.convertDocumentToString(dom);
        return Utils.loadXML((String)xmlStr);
    }

    private void decryptElement(Element encryptedDataElement, PrivateKey inputKey) throws Exception {
        AccessController.doPrivileged(() -> {
            Init.init();
            return null;
        });
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        NodeList keyInfoInEncData = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (keyInfoInEncData.getLength() == 0) {
            throw new ValidationError("No KeyInfo inside EncryptedData element", 35);
        }
        NodeList childs = keyInfoInEncData.item(0).getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            if (childs.item(i).getLocalName() == null || !childs.item(i).getLocalName().equals("RetrievalMethod")) continue;
            Element retrievalMethodElem = (Element)childs.item(i);
            if (!retrievalMethodElem.getAttribute("Type").equals("http://www.w3.org/2001/04/xmlenc#EncryptedKey")) {
                throw new ValidationError("Unsupported Retrieval Method found", 37);
            }
            String uri = retrievalMethodElem.getAttribute("URI").substring(1);
            NodeList encryptedKeyNodes = ((Element)encryptedDataElement.getParentNode()).getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
            for (int j = 0; j < encryptedKeyNodes.getLength(); ++j) {
                if (!((Element)encryptedKeyNodes.item(j)).getAttribute("Id").equals(uri)) continue;
                keyInfoInEncData.item(0).replaceChild(encryptedKeyNodes.item(j), childs.item(i));
            }
        }
        xmlCipher.setKEK(inputKey);
        xmlCipher.doFinal(encryptedDataElement.getOwnerDocument(), encryptedDataElement, false);
    }

    public static String convertDocumentToString(Document doc) {
        AccessController.doPrivileged(() -> {
            Init.init();
            return null;
        });
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLUtils.outputDOM(doc, baos);
        return Utils.toStringUtf8((byte[])baos.toByteArray());
    }
}

