/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.weather.ui.BWeatherIconSize;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.weather.BMoonPosition;
import javax.baja.workbench.view.BWbComponentView;

public class BMoonView
extends BWbComponentView {
    private static final Lexicon lex = Lexicon.make((String)"weather");
    public static final Property iconSize = BMoonView.newProperty((int)0, (BValue)BWeatherIconSize.x64, null);
    public static final Property northernHemisphere = BMoonView.newProperty((int)0, (boolean)true, null);
    public static final Property phaseFont = BMoonView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("phase.font")), null);
    public static final Property phaseBrush = BMoonView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Property illuminatedFont = BMoonView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("illumination.font")), null);
    public static final Property illuminatedBrush = BMoonView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    public static final Type TYPE = Sys.loadType(BMoonView.class);

    public BWeatherIconSize getIconSize() {
        return (BWeatherIconSize)this.get(iconSize);
    }

    public void setIconSize(BWeatherIconSize v) {
        this.set(iconSize, (BValue)v, null);
    }

    public boolean getNorthernHemisphere() {
        return this.getBoolean(northernHemisphere);
    }

    public void setNorthernHemisphere(boolean v) {
        this.setBoolean(northernHemisphere, v, null);
    }

    public BFont getPhaseFont() {
        return (BFont)this.get(phaseFont);
    }

    public void setPhaseFont(BFont v) {
        this.set(phaseFont, (BValue)v, null);
    }

    public BBrush getPhaseBrush() {
        return (BBrush)this.get(phaseBrush);
    }

    public void setPhaseBrush(BBrush v) {
        this.set(phaseBrush, (BValue)v, null);
    }

    public BFont getIlluminatedFont() {
        return (BFont)this.get(illuminatedFont);
    }

    public void setIlluminatedFont(BFont v) {
        this.set(illuminatedFont, (BValue)v, null);
    }

    public BBrush getIlluminatedBrush() {
        return (BBrush)this.get(illuminatedBrush);
    }

    public void setIlluminatedBrush(BBrush v) {
        this.set(illuminatedBrush, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.getCurrentValue() == null) {
            return;
        }
        if (prop.equals(iconSize) || prop.equals(phaseFont) || prop.equals(phaseBrush)) {
            this.loadValue(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    protected void doLoadValue(BObject object, Context cx) {
        BMoonPosition moonPosition = (BMoonPosition)object;
        moonPosition.lease();
        String img = BMoonView.getMoonIcon(moonPosition.getPhase().getEnum(), this.getNorthernHemisphere());
        String size = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
        BLabel icon = new BLabel(BImage.make((String)("module://weather/rc/" + img + size + ".png")));
        BFacets phaseFacets = moonPosition.getSlotFacets((Slot)BMoonPosition.phase);
        BLabel phase = new BLabel(moonPosition.getPhase().toString((Context)phaseFacets));
        phase.setFont(this.getPhaseFont());
        phase.setForeground(this.getPhaseBrush());
        BGridPane right = new BGridPane(1);
        right.setRowGap(1.0);
        StringBuffer illuminatedText = new StringBuffer();
        illuminatedText.append(moonPosition.getIllumination());
        illuminatedText.append("% ");
        illuminatedText.append(lex.get("illuminated"));
        BLabel illuminated = new BLabel(illuminatedText.toString());
        illuminated.setFont(this.getIlluminatedFont());
        illuminated.setForeground(this.getIlluminatedBrush());
        right.add(null, (BValue)phase);
        right.add(null, (BValue)illuminated);
        BGridPane grid = new BGridPane(2);
        grid.setColumnGap(6.0);
        grid.add(null, (BValue)icon);
        grid.add(null, (BValue)right);
        this.setContent((BWidget)grid);
        this.registerForComponentEvents((BComponent)moonPosition);
    }

    public static String getMoonIcon(BEnum state, boolean northernHemisphere) {
        switch (state.getOrdinal()) {
            case 0: {
                return "moonNew";
            }
            case 4: {
                return "moonFull";
            }
        }
        if (northernHemisphere) {
            switch (state.getOrdinal()) {
                case 7: {
                    return "moonWaningCrescent";
                }
                case 6: {
                    return "moonLastQuarter";
                }
                case 5: {
                    return "moonWaningGibbous";
                }
                case 3: {
                    return "moonWaxingGibbous";
                }
                case 2: {
                    return "moonFirstQuarter";
                }
                case 1: {
                    return "moonWaxingCrescent";
                }
            }
        } else {
            switch (state.getOrdinal()) {
                case 7: {
                    return "moonWaxingCrescent";
                }
                case 6: {
                    return "moonFirstQuarter";
                }
                case 5: {
                    return "moonWaxingGibbous";
                }
                case 3: {
                    return "moonWaningGibbous";
                }
                case 2: {
                    return "moonLastQuarter";
                }
                case 1: {
                    return "moonWaningCrescent";
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public void handleComponentEvent(BComponentEvent event) {
        BComponent c = event.getSourceComponent();
        if (c instanceof BMoonPosition && (event.getSlot().equals((Object)BMoonPosition.phase) || event.getSlot().equals((Object)BMoonPosition.illumination))) {
            this.doLoadValue((BObject)event.getSourceComponent(), this.getCurrentContext());
            this.relayout();
        }
    }
}

