/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.weather.ui.BAdvisoryManager;
import javax.baja.gx.BBrush;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.weather.advisory.BAdvisory;

public class BAdvisoryDetailsDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BAdvisoryDetailsDialog.class);
    Command closeCmd;
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);
    public static final UiLexicon lex = UiLexicon.makeUiLexicon(BAdvisoryDetailsDialog.class);

    public Type getType() {
        return TYPE;
    }

    public BAdvisoryDetailsDialog() {
        throw new IllegalStateException();
    }

    public BAdvisoryDetailsDialog(BAdvisoryManager manager, BAdvisory advisory) {
        super((BWidget)manager, advisory.getWeatherSummary().getValue(), true);
        this.closeCmd = new CloseCommand((BWidget)this);
        BButton closeBtn = new BButton(this.closeCmd, true, true);
        BGridPane advisoryPane = new BGridPane(2);
        advisoryPane.setColorRows(true);
        advisoryPane.setColumnGap(9.0);
        advisoryPane.setRowAlign(BValign.top);
        Property[] props = advisory.loadSlots().getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (Flags.isHidden((BComplex)advisory, (Slot)props[i])) continue;
            BLabel label = new BLabel(advisory.getDisplayName((Slot)props[i], null), BHalign.left);
            label.setFont(Theme.label().getBoldText());
            advisoryPane.add(null, (BValue)label, null);
            String text = props[i].getType().is(BAbsTime.TYPE) ? advisory.get(props[i]).toString((Context)TIME_FACETS) : (props[i].getType().is(BStatusValue.TYPE) ? SlotPath.unescape((String)((BStatusValue)advisory.get(props[i].getName())).getValueValue().toString()) : SlotPath.unescape((String)advisory.get(props[i].getName()).toString()));
            BTextEditor editor = new BTextEditor(text, false);
            editor.setRenderer(new TextRenderer(){

                public BBrush getBackground() {
                    return BBrush.NULL;
                }
            });
            advisoryPane.add(null, (BValue)editor);
        }
        BGridPane toolBar = new BGridPane(1);
        toolBar.setColumnAlign(BHalign.fill);
        toolBar.setUniformColumnWidth(true);
        toolBar.add("close", (BValue)closeBtn);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)advisoryPane));
        pane.setBottom((BWidget)new BBorderPane((BWidget)toolBar));
        this.setContent((BWidget)pane);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    private class CloseCommand
    extends Command {
        public CloseCommand(BWidget owner) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.close");
        }

        public CommandArtifact doInvoke() {
            BAdvisoryDetailsDialog.this.close();
            return null;
        }
    }
}

