/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.fox.ui;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.weather.fox.BFoxWeatherProvider;
import java.util.Arrays;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.weather.BWeatherService;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFoxWeatherProviderFE
extends BWbFieldEditor {
    public static final Action updateReportList = BFoxWeatherProviderFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BFoxWeatherProviderFE.class);
    Context context;
    BFoxWeatherProvider foxProvider;
    private BListDropDown stationSelect = new BListDropDown();
    private BListDropDown reportSelect = new BListDropDown();

    public void updateReportList() {
        this.invoke(updateReportList, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFoxWeatherProviderFE() {
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)this.stationSelect);
        grid.add(null, (BValue)this.reportSelect);
        this.setContent((BWidget)grid);
        this.linkTo("lk1", (BComponent)this.stationSelect, (Slot)BListDropDown.listActionPerformed, (Slot)updateReportList);
        this.linkTo("lk0", (BComponent)this.stationSelect, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo("lk2", (BComponent)this.reportSelect, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
    }

    protected void doSetReadonly(boolean readonly) {
        boolean ro = readonly;
        if (this.foxProvider != null) {
            ro |= Flags.isReadonly((BComplex)this.foxProvider, (Slot)BFoxWeatherProvider.stationName);
            ro |= Flags.isHidden((BComplex)this.foxProvider, (Slot)BFoxWeatherProvider.stationName);
        }
        this.stationSelect.setDropDownEnabled(!ro);
        this.reportSelect.setDropDownEnabled(!ro);
    }

    protected void doLoadValue(BObject object, Context context) {
        BNiagaraNetwork network;
        this.foxProvider = (BFoxWeatherProvider)object;
        this.context = context;
        if (object == null) {
            return;
        }
        this.foxProvider.lease();
        if (this.getWbShell() != null) {
            OrdTarget ordTarget = this.getWbShell().getActiveOrdTarget();
            BComponent target = (BComponent)ordTarget.get();
            BComponentSpace space = target.getComponentSpace();
            network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get((BObject)space, context);
        } else if (this.foxProvider.getComponentSpace() != null) {
            this.foxProvider.lease();
            network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get((BObject)this.foxProvider.getComponentSpace());
        } else {
            return;
        }
        network.lease();
        BNiagaraStation[] stations = (BNiagaraStation[])network.getChildren(BNiagaraStation.class);
        String[] stationNames = new String[stations.length];
        for (int i = 0; i < stations.length; ++i) {
            stationNames[i] = stations[i].getStationName();
        }
        Arrays.sort(stationNames, String.CASE_INSENSITIVE_ORDER);
        boolean selected = this.foxProvider.getStationName().isEmpty();
        for (int i = 0; i < stationNames.length; ++i) {
            this.stationSelect.getList().addItem((Object)stationNames[i]);
            if (!this.foxProvider.getStationName().equals(stationNames[i])) continue;
            this.stationSelect.getList().setSelectedIndex(i);
            selected = true;
        }
        if (!selected) {
            this.stationSelect.getList().addItem((Object)this.foxProvider.getStationName());
            this.stationSelect.getList().setSelectedIndex(this.stationSelect.getList().getItemCount() - 1);
        }
        this.doUpdateReportList();
        this.doSetReadonly(this.isReadonly());
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        BFoxWeatherProvider foxProvider = (BFoxWeatherProvider)v;
        String station = (String)this.stationSelect.getList().getSelectedItem();
        ReportSelection report = (ReportSelection)this.reportSelect.getList().getSelectedItem();
        if (report == null || report.ord == null) {
            throw new BajaRuntimeException("Weather report required.");
        }
        foxProvider.setStationName(station);
        foxProvider.setOrd(report.ord);
        return foxProvider;
    }

    public void doUpdateReportList() {
        BWeatherService weatherService;
        this.reportSelect.getList().removeAllItems();
        String selectedStation = (String)this.stationSelect.getSelectedItem();
        if (selectedStation == null) {
            this.reportSelect.setEnabled(false);
            return;
        }
        if (this.getWbShell() != null) {
            OrdTarget ordTarget = this.getWbShell().getActiveOrdTarget();
            BComponent target = (BComponent)ordTarget.get();
            BComponentSpace space = target.getComponentSpace();
            weatherService = (BWeatherService)BOrd.make((String)"service:weather:WeatherService").get((BObject)space, this.context);
        } else if (this.foxProvider.getComponentSpace() != null) {
            this.foxProvider.lease();
            weatherService = (BWeatherService)BOrd.make((String)"service:weather:WeatherService").get((BObject)this.foxProvider.getComponentSpace());
        } else {
            this.reportSelect.setEnabled(false);
            return;
        }
        BVector reportVector = FoxRpcUtil.doSilentRpc((BISpaceNode)weatherService, (String)"getReports", (Object[])new Object[]{BString.make((String)selectedStation)}).orElse(null);
        if (reportVector == null || reportVector.getChildComponents().length == 0) {
            this.reportSelect.setEnabled(false);
            return;
        }
        SlotCursor reportCursor = reportVector.getProperties();
        Array reportList = new Array(ReportSelection.class);
        while (reportCursor.next()) {
            reportList.add((Object)new ReportSelection((BComponent)reportVector.get(reportCursor.property())));
        }
        ReportSelection[] reportArray = new ReportSelection[reportList.size()];
        System.arraycopy(reportList.array(), 0, reportArray, 0, reportArray.length);
        boolean selected = this.foxProvider.getOrd().isNull();
        for (int i = 0; i < reportArray.length; ++i) {
            this.reportSelect.getList().addItem((Object)reportArray[i]);
            if (i != 0 && !this.foxProvider.getOrd().equals((Object)reportArray[i].ord)) continue;
            this.reportSelect.getList().setSelectedIndex(i);
            selected = true;
        }
        if (!selected) {
            OrdQuery[] queries = this.foxProvider.getOrd().parse();
            String body = queries[queries.length - 1].getBody();
            this.reportSelect.getList().addItem((Object)body.substring(body.lastIndexOf(47) + 1));
            this.reportSelect.getList().setSelectedIndex(this.reportSelect.getList().getItemCount() - 1);
        }
        this.reportSelect.setEnabled(true);
    }

    private class ReportSelection
    implements Comparable<Object> {
        String displayName;
        BOrd ord;

        public ReportSelection(String displayName, BOrd ord) {
            this.displayName = displayName;
            this.ord = ord;
        }

        public ReportSelection(BComponent value) {
            this.displayName = value.get("name").toString();
            this.ord = (BOrd)value.get("ord");
        }

        @Override
        public int compareTo(Object arg0) {
            return this.displayName.compareToIgnoreCase(((ReportSelection)arg0).displayName);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

