/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.ui;

import com.tridium.saml.attributes.BISAMLUserPropertyInfo;
import com.tridium.saml.attributes.BSAMLAttributeMapping;
import com.tridium.saml.attributes.BSAMLUserProperty;
import com.tridium.saml.attributes.BSAMLUserPropertyType;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import java.util.Optional;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"saml:SAMLAttributeMapping"})})
@NiagaraAction(name="handleTypeChange", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)
public class BSAMLAttributeMappingFE
extends BWbFieldEditor {
    public static final Action handleTypeChange = BSAMLAttributeMappingFE.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BSAMLAttributeMappingFE.class);
    BTextField attributeNameEditor = new BTextField("");
    BFrozenEnumFE typeEditor;
    BGridPane typePane = new BGridPane(1);
    BSAMLAttributeMapping mapping;

    public void handleTypeChange(BWidgetEvent parameter) {
        this.invoke(handleTypeChange, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSAMLAttributeMappingFE() {
        this.typeEditor = new BFrozenEnumFE();
        this.typePane.add(null, (BValue)this.typeEditor);
        BGridPane mainPane = new BGridPane(2);
        mainPane.setRowAlign(BValign.top);
        mainPane.add(null, (BValue)this.attributeNameEditor);
        mainPane.add("type", (BValue)this.typePane);
        this.setContent((BWidget)mainPane);
        this.linkTo(null, (BComponent)this.attributeNameEditor, (Slot)BTextField.focusEvent, (Slot)focusEvent);
        this.linkTo(null, (BComponent)this.attributeNameEditor, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.typeEditor, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.typeEditor.getContent(), (Slot)BDropDown.valueModified, (Slot)handleTypeChange);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.mapping = (BSAMLAttributeMapping)value;
        this.attributeNameEditor.setText(this.mapping.getSAMLAttributeName());
        BSAMLUserProperty userProperty = this.mapping.getUserProperty();
        BSAMLUserPropertyType userPropertyType = userProperty.getUserPropertyType();
        this.typeEditor.loadValue((BObject)userPropertyType);
        this.handlePropertyInfo(userProperty.getAttributeInfo());
        this.relayout();
        this.repaint();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        this.mapping.setSAMLAttributeName(this.attributeNameEditor.getText());
        BSAMLUserPropertyType userPropertyType = (BSAMLUserPropertyType)this.typeEditor.saveValue();
        BSAMLUserProperty userProperty = BSAMLUserPropertyType.generateSAMLUserProperty((BSAMLUserPropertyType)userPropertyType);
        BWbFieldEditor infoEditor = (BWbFieldEditor)this.typePane.get("info");
        if (infoEditor != null) {
            userProperty.setAttributeInfo((BISAMLUserPropertyInfo)infoEditor.saveValue());
        }
        this.mapping.setUserProperty(userProperty);
        return this.mapping;
    }

    public void doHandleTypeChange(BWidgetEvent widgetEvent) throws Exception {
        BListDropDown fe = (BListDropDown)widgetEvent.getWidget();
        int userPropertyTypeIndex = fe.getSelectedIndex();
        BEnumRange range = BSAMLUserPropertyType.DEFAULT.getRange();
        BSAMLUserPropertyType userPropertyType = (BSAMLUserPropertyType)range.get(range.getOrdinals()[userPropertyTypeIndex]);
        this.typeEditor.loadValue((BObject)userPropertyType);
        BSAMLUserProperty userProperty = BSAMLUserPropertyType.generateSAMLUserProperty((BSAMLUserPropertyType)userPropertyType);
        this.handlePropertyInfo(userProperty.getAttributeInfo());
        this.relayout();
        this.repaint();
    }

    private void handlePropertyInfo(Optional<BISAMLUserPropertyInfo> infoHolder) {
        if (infoHolder.isPresent()) {
            BISAMLUserPropertyInfo info = infoHolder.get();
            BWbFieldEditor infoEditor = BWbFieldEditor.makeFor((BObject)info.asObject());
            infoEditor.loadValue(info.asObject());
            if (this.typePane.get("info") != null) {
                this.typePane.set("info", (BValue)infoEditor);
            } else {
                this.typePane.add("info", (BValue)infoEditor);
            }
            this.linkTo(null, (BComponent)infoEditor, (Slot)BWbFieldEditor.focusEvent, (Slot)focusEvent);
            this.linkTo(null, (BComponent)infoEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        } else if (this.typePane.get("info") != null) {
            this.typePane.remove("info");
        }
    }
}

