/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.ui;

import com.tridium.saml.attributes.BSAMLAttributeMapping;
import com.tridium.saml.ui.BSAMLAttributeMappingFE;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"saml:SAMLAttributeMapper"})})
@NiagaraAction(name="handleFocusChange", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4)
public class BSAMLAttributeMapperFE
extends BWbFieldEditor {
    public static final Action handleFocusChange = BSAMLAttributeMapperFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Type TYPE = Sys.loadType(BSAMLAttributeMapperFE.class);
    private BGridPane contentPane;
    private BWidget focusedEditor = null;
    private final Command addCommand = new AddCommand();
    private final Command deleteCommand = new DeleteCommand();

    public void handleFocusChange(BFocusEvent parameter) {
        this.invoke(handleFocusChange, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSAMLAttributeMapperFE() {
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        BToolBar toolbar = new BToolBar();
        toolbarPane.add(null, (BValue)toolbar, null);
        BButton button = new BButton(this.addCommand);
        toolbar.add("add", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        button = new BButton(this.deleteCommand);
        toolbar.add("delete", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        BGridPane outerGrid = new BGridPane(1);
        this.contentPane = new BGridPane(1);
        outerGrid.add(null, (BValue)this.contentPane);
        outerGrid.add(null, (BValue)toolbarPane);
        outerGrid.setHalign(BHalign.left);
        outerGrid.setColumnAlign(BHalign.center);
        this.setContent((BWidget)outerGrid);
    }

    private BSAMLAttributeMappingFE addElement(BSAMLAttributeMapping value) {
        BSAMLAttributeMappingFE editor = new BSAMLAttributeMappingFE();
        editor.loadValue((BObject)value);
        this.contentPane.add(null, (BValue)editor, 0);
        editor.setEnabled(this.isEnabled());
        this.getContent().computePreferredSize();
        this.getContent().relayout();
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
        this.setEnabled(this.isEnabled());
        return editor;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BComponent mapping = (BComponent)value;
        this.contentPane.removeAll();
        SlotCursor c = mapping.loadSlots().getProperties();
        while (c.next(BSAMLAttributeMapping.class)) {
            this.addElement((BSAMLAttributeMapping)c.get());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BComponent mapping = (BComponent)value;
        mapping.lease();
        mapping.removeAll();
        if (mapping.getSlotCount() > 0) {
            throw new Exception("Failed to remove attribute mapping slots");
        }
        for (BWidget child : this.contentPane.getChildWidgets()) {
            BSAMLAttributeMapping fieldValue = (BSAMLAttributeMapping)((BWbFieldEditor)child).saveValue(null);
            String attributeName = fieldValue.getSAMLAttributeName();
            if (attributeName == null || attributeName.isEmpty()) {
                throw new LocalizableRuntimeException("saml", "SAMLAttributeMapperFE.noAttributeName");
            }
            mapping.add("samlAttr?", (BValue)fieldValue, 1, null, null);
        }
        if (mapping.getSlotCount() != this.contentPane.getChildWidgets().length) {
            throw new Exception("Failed to add BSAMLAttributeMapping slots");
        }
        return mapping;
    }

    public void doHandleFocusChange(BFocusEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getId() == 1005) {
            if (this.focusedEditor == this.getMappingAncestor(event.getWidget())) {
                this.focusedEditor = null;
            }
        } else if (event.getId() == 1004) {
            this.focusedEditor = this.getMappingAncestor(event.getWidget());
        }
        this.deleteCommand.setEnabled(this.focusedEditor != null);
    }

    private BWidget getMappingAncestor(BWidget widget) {
        while (widget != null && !(widget instanceof BSAMLAttributeMappingFE)) {
            widget = widget.getParentWidget();
        }
        return widget;
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BSAMLAttributeMapperFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BSAMLAttributeMapperFE.this.focusedEditor == null) {
                return null;
            }
            SlotCursor c = BSAMLAttributeMapperFE.this.contentPane.loadSlots().getProperties();
            while (c.next(BSAMLAttributeMappingFE.class)) {
                if (c.get() != BSAMLAttributeMapperFE.this.focusedEditor) continue;
                BSAMLAttributeMapperFE.this.contentPane.remove(c.property());
                BSAMLAttributeMapperFE.this.focusedEditor = null;
                BSAMLAttributeMapperFE.this.deleteCommand.setEnabled(false);
                BSAMLAttributeMapperFE.this.addCommand.setEnabled(true);
                BSAMLAttributeMapperFE.this.setModified();
                BSAMLAttributeMapperFE.this.relayout();
                return null;
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BSAMLAttributeMapperFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
        }

        public CommandArtifact doInvoke() {
            BSAMLAttributeMappingFE mappingEditor = BSAMLAttributeMapperFE.this.addElement(new BSAMLAttributeMapping());
            mappingEditor.attributeNameEditor.getSelection().selectAll();
            mappingEditor.attributeNameEditor.getController().getEditor().requestFocus();
            return null;
        }
    }
}

