/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.enums.BLinearConversion;
import com.gc5.iSMA_IO.enums.Modbus.BDataType;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusWriteRequest;
import com.gc5.iSMA_IO.points.BNumericPointProxyExt;
import com.gc5.iSMA_IO.points.IWritablePoint;
import java.lang.reflect.Method;
import javax.baja.control.BNumericWritable;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="false", override=true)
@NiagaraAction(name="forceWrite")
public class BNumericWritableProxyExt
extends BNumericPointProxyExt
implements IWritablePoint {
    public static final Property enabled = BNumericWritableProxyExt.newProperty((int)264, (boolean)false, null);
    public static final Action forceWrite = BNumericWritableProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNumericWritableProxyExt.class);
    public boolean forcedWriting = false;
    Double oldValue = null;

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void InitializeVariables() {
        if (this.parentComponent instanceof BIsmaRemoteDevice && !((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.oldValue = this.getInActiveLevel().getNumeric();
        }
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == BLinearConversion.scale || property == BLinearConversion.offset) {
            this.writeValue(true);
        }
    }

    @Override
    public void doForceWrite() {
        if (this.parentComponent == null) {
            return;
        }
        this.writeValue(true);
    }

    public void writeValue(boolean forcedWriting) {
        Double value;
        BStatusNumeric inSlotsActivLevel = this.getInActiveLevel();
        if (this.getEnabled() && !inSlotsActivLevel.getStatus().isNull() && this.isRunning() && this.parentComponent instanceof BIsmaCommonIoDevice && (!(value = Double.valueOf(this.getValueWithLinearConversion(inSlotsActivLevel.getNumeric()))).equals(this.oldValue) || forcedWriting)) {
            this.oldValue = value;
            try {
                Method m = BNumericWritableProxyExt.class.getMethod("callRead", ModbusMessage.class);
                int regCount = 1;
                BDataType dataType = this.getDataType();
                if (dataType == BDataType.Float || dataType == BDataType.UnsignedLong || dataType == BDataType.SignedLong) {
                    regCount = 2;
                }
                this.parentComponent.addRequest(new ModbusWriteRequest(this, m, this.parentComponent.devAddr, 16, this.getDataAddress(), regCount, this.convertNumericToRegisters(this.getDataType(), value)));
            }
            catch (Exception e) {
                log.severe(e.getLocalizedMessage());
            }
        }
    }

    @Override
    Type getPointType() {
        return BNumericWritable.TYPE;
    }

    BStatusNumeric getInActiveLevel() {
        try {
            for (int i = 1; i < 17; ++i) {
                Method getIn = ((BNumericWritable)this.getParent().getParentComponent()).getClass().getMethod("getIn" + i, null);
                BStatusNumeric inVal = (BStatusNumeric)getIn.invoke((Object)this.getParent().getParentComponent(), null);
                if (inVal.getStatus().isNull()) continue;
                return inVal;
            }
        }
        catch (Exception e) {
            log.severe("Getting active level problem: " + e.getLocalizedMessage());
        }
        return ((BNumericWritable)this.getParent().getParentComponent()).getFallback();
    }

    @Override
    public void onExecute(BStatusValue out, Context cx) {
        BStatus stat;
        if (this.isPointReady) {
            this.writeValue(false);
        }
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusNumeric());
        }
        if ((stat = out.getStatus()).isNull()) {
            stat = BStatus.ok;
        }
        BStatusNumeric statusValueForOutputSlot = this.calculateReadValueWithLinearConversion();
        statusValueForOutputSlot.copyFrom((BComplex)new BStatusNumeric(statusValueForOutputSlot.getNumeric(), stat));
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            statusValueForOutputSlot.setStatus(this.getStatus());
            statusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)statusValueForOutputSlot);
    }

    @Override
    protected void onUp() {
        super.onUp();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnUp()) {
            this.doForceWrite();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.doForceWrite();
        }
    }

    @Override
    protected void onEnable() {
        super.onEnable();
        if (this.parentComponent instanceof BIsmaRemoteDevice && ((BIsmaRemoteDevice)this.parentComponent).getWriteOnEnabled()) {
            this.doForceWrite();
        }
    }

    private double getValueWithLinearConversion(double value) {
        double scale = this.getLinearConversion().getScale();
        double offset = this.getLinearConversion().getOffset();
        if (scale == 0.0) {
            return 0.0;
        }
        return (value - offset) / scale;
    }

    @Override
    protected BStatusNumeric calculateReadValueWithLinearConversion() {
        if (this.getLinearConversion().getScale() == 0.0) {
            return new BStatusNumeric(0.0);
        }
        return super.calculateReadValueWithLinearConversion();
    }
}

