/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.enums.BLinearConversion;
import com.gc5.iSMA_IO.enums.Modbus.BDataType;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.points.BModbusProxyExt;
import com.gc5.iSMA_IO.points.BNumericWritableProxyExt;
import java.lang.reflect.Method;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="true", override=true), @NiagaraProperty(name="dataType", type="BDataType", flags=0, defaultValue="BDataType.UnsignedInteger"), @NiagaraProperty(name="linearConversion", type="BLinearConversion", flags=0, defaultValue="new BLinearConversion()")})
public class BNumericPointProxyExt
extends BModbusProxyExt {
    public static final Property enabled = BNumericPointProxyExt.newProperty((int)264, (boolean)true, null);
    public static final Property dataType = BNumericPointProxyExt.newProperty((int)0, (BValue)BDataType.UnsignedInteger, null);
    public static final Property linearConversion = BNumericPointProxyExt.newProperty((int)0, (BValue)new BLinearConversion(), null);
    public static final Type TYPE = Sys.loadType(BNumericPointProxyExt.class);

    public BDataType getDataType() {
        return (BDataType)this.get(dataType);
    }

    public void setDataType(BDataType v) {
        this.set(dataType, (BValue)v, null);
    }

    public BLinearConversion getLinearConversion() {
        return (BLinearConversion)this.get(linearConversion);
    }

    public void setLinearConversion(BLinearConversion v) {
        this.set(linearConversion, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    Type getPointType() {
        return BNumericPoint.TYPE;
    }

    @Override
    public void sendConfigurations() {
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (!(property != BLinearConversion.scale && property != BLinearConversion.offset || this instanceof BNumericWritableProxyExt)) {
            this.doPoll();
        }
    }

    @Override
    public ModbusMessage makeMpm() {
        ModbusReadRequest tempModbusMessage = null;
        try {
            Method m = BNumericPointProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            int regCount = 1;
            BDataType dataType = this.getDataType();
            if (dataType == BDataType.Float || dataType == BDataType.UnsignedLong || dataType == BDataType.SignedLong) {
                regCount = 2;
            }
            tempModbusMessage = new ModbusReadRequest(this, m, this.parentComponent.devAddr, this.getType().is(BNumericWritableProxyExt.TYPE) ? 3 : 4, this.getDataAddress(), regCount);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
        return tempModbusMessage;
    }

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        if (!super.setOutputValues(mm)) {
            return false;
        }
        double val = this.convertRegistersToNumeric(this.getDataType(), mm.getRegisters());
        this.temporaryStatusValueForOutputSlot = new BStatusNumeric(val);
        this.myPoint.doExecute();
        return true;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusNumeric());
        }
        BStatusNumeric statusValueForOutputSlot = this.calculateReadValueWithLinearConversion();
        statusValueForOutputSlot.setStatus(out.getStatus());
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            statusValueForOutputSlot.setStatus(this.getStatus());
            statusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)statusValueForOutputSlot);
    }

    protected BStatusNumeric calculateReadValueWithLinearConversion() {
        if (!(this.temporaryStatusValueForOutputSlot instanceof BStatusNumeric) || this.getLinearConversion().getScale() == 0.0) {
            return new BStatusNumeric(0.0);
        }
        return new BStatusNumeric(((BStatusNumeric)this.temporaryStatusValueForOutputSlot).getNumeric() * this.getLinearConversion().getScale() + this.getLinearConversion().getOffset());
    }
}

