/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.enums.Modbus.BDataType;
import com.gc5.iSMA_IO.points.BIsmaIoProxyExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="dataAddress", type="int", defaultValue="-1", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="9999")})
public abstract class BModbusProxyExt
extends BIsmaIoProxyExt {
    public static final Property dataAddress = BModbusProxyExt.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)9999)));
    public static final Type TYPE = Sys.loadType(BModbusProxyExt.class);

    public int getDataAddress() {
        return this.getInt(dataAddress);
    }

    public void setDataAddress(int v) {
        this.setInt(dataAddress, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        this.InitializeVariables();
        if (this.parentComponent.deviceIsReady) {
            this.setPointToReady();
        } else {
            this.waitingForDevice = true;
        }
    }

    protected void InitializeVariables() {
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == dataAddress) {
            this.doPoll();
        }
    }

    double convertRegistersToNumeric(BDataType type, int[] registers) {
        if (BDataType.UnsignedInteger.equals((Object)type)) {
            return Integer.toUnsignedLong(registers[0]);
        }
        if (BDataType.SignedInteger.equals((Object)type)) {
            int val = registers[0];
            if ((val & 0x8000) == 32768) {
                val -= 65536;
            }
            return val;
        }
        if (BDataType.UnsignedLong.equals((Object)type)) {
            return Integer.toUnsignedLong(registers[0] + (registers[1] << 16));
        }
        if (BDataType.SignedLong.equals((Object)type)) {
            long val = registers[0] + (registers[1] << 16);
            if ((val & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                val -= 0x100000000L;
            }
            return val;
        }
        if (BDataType.Float.equals((Object)type)) {
            return Float.intBitsToFloat(registers[0] + (registers[1] << 16));
        }
        return Double.NaN;
    }

    int[] convertNumericToRegisters(BDataType type, double val) {
        int[] registers = new int[]{0, 0};
        if (type.equals((Object)BDataType.UnsignedInteger) || type.equals((Object)BDataType.SignedInteger)) {
            registers = new int[]{(int)val};
        } else if (type.equals((Object)BDataType.UnsignedLong) || type.equals((Object)BDataType.SignedLong)) {
            registers = new int[]{(int)((long)val & 0xFFFFL), (int)((long)val >>> 16)};
        } else if (type.equals((Object)BDataType.Float)) {
            registers = new int[]{Float.floatToIntBits((float)val) & 0xFFFF, Float.floatToIntBits((float)val) >>> 16};
        }
        return registers;
    }

    @Override
    int getMaxAddress() {
        return 0;
    }

    @Override
    int getAddress() {
        return this.getDataAddress();
    }

    @Override
    void setMyPointAddress() {
        this.setDataAddress(this.getFirstFreeNumber(0, 9999));
    }

    @Override
    public void setMaxIONumber() {
    }

    @Override
    boolean isIOPoint() {
        return false;
    }
}

