/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaIoDevice;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.points.BIsmaDipSwitchS3ProxyExt;
import com.gc5.iSMA_IO.points.BIsmaDipSwitchS4ProxyExt;
import com.gc5.iSMA_IO.points.BIsmaIoProxyExt;
import com.gc5.iSMA_IO.points.BIsmaSwitchBase;
import java.lang.reflect.Method;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="true")
public abstract class BIsmaSwitchBaseProxyExt
extends BIsmaIoProxyExt {
    public static final Property enabled = BIsmaSwitchBaseProxyExt.newProperty((int)264, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BIsmaSwitchBaseProxyExt.class);
    protected BIsmaSwitchBase parentPoint = null;

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Override
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        if (this.parentComponent.deviceIsReady) {
            this.setPointToReady();
        } else {
            this.waitingForDevice = true;
        }
        this.setParentPoint();
    }

    @Override
    protected final BIsmaCommonIoDevice getProperParent() {
        BComponent parentComponent = this.getParent().getParent().getParentComponent();
        while (parentComponent != null && !parentComponent.getType().is(BIsmaIoDevice.TYPE)) {
            BComplex parent = parentComponent.getParent();
            if (parent != null) {
                parentComponent = parent.getParentComponent();
                continue;
            }
            return null;
        }
        if (parentComponent != null && parentComponent.getType().is(BIsmaIoDevice.TYPE)) {
            return (BIsmaCommonIoDevice)parentComponent;
        }
        return null;
    }

    @Override
    int getMaxAddress() {
        return 0;
    }

    @Override
    void setMyPointAddress() {
    }

    @Override
    public void setMaxIONumber() {
    }

    @Override
    boolean isIOPoint() {
        return false;
    }

    @Override
    public ModbusMessage makeMpm() {
        ModbusReadRequest modbusMessage = null;
        try {
            Method m = BIsmaDipSwitchS3ProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            modbusMessage = new ModbusReadRequest(this, m, this.parentComponent.devAddr, 3, this.getAddress(), 1);
        }
        catch (Exception ex) {
            log.severe(ex.getLocalizedMessage());
        }
        return modbusMessage;
    }

    @Override
    public boolean setOutputValues(ModbusMessage modbusMessage) {
        if (!super.setOutputValues(modbusMessage)) {
            return false;
        }
        int value = this.decodeValue(modbusMessage.getRegister(0));
        int valueReversed = this.reverseBytes(value);
        this.temporaryStatusValueForOutputSlot = new BStatusNumeric((double)valueReversed);
        this.myPoint.doExecute();
        if (this.parentPoint != null) {
            this.parentPoint.setOutputs(valueReversed);
        }
        return true;
    }

    private int reverseBytes(int value) {
        if (!(this instanceof BIsmaDipSwitchS3ProxyExt) && !(this instanceof BIsmaDipSwitchS4ProxyExt)) {
            return value;
        }
        int reverseValue = Integer.reverse(value);
        int shiftLength = 0;
        if (this instanceof BIsmaDipSwitchS3ProxyExt) {
            shiftLength = 6;
        } else if (this instanceof BIsmaDipSwitchS4ProxyExt) {
            shiftLength = 8;
        }
        return reverseValue >>> 32 - shiftLength;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusNumeric());
        }
        this.temporaryStatusValueForOutputSlot.setStatus(this.getStatus());
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            this.temporaryStatusValueForOutputSlot.setStatus(this.getStatus());
            this.temporaryStatusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)this.temporaryStatusValueForOutputSlot);
    }

    @Override
    public void sendConfigurations() {
    }

    protected abstract int decodeValue(int var1);

    protected abstract void setParentPoint();
}

