/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.points;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.enums.SerialParameters.BPolarity;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.messages.ModbusWriteCoilsRequest;
import com.gc5.iSMA_IO.points.BIsmaOutputProxyExt;
import java.lang.reflect.Method;
import javax.baja.control.BBooleanWritable;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperty(name="polarityConversion", type="BPolarity", defaultValue="BPolarity.Default", flags=8)
public class BDigitalOutputProxyExt
extends BIsmaOutputProxyExt {
    public static final Property polarityConversion = BDigitalOutputProxyExt.newProperty((int)8, (BValue)BPolarity.Default, null);
    public static final Type TYPE = Sys.loadType(BDigitalOutputProxyExt.class);
    Boolean oldValue = null;
    Property defaultValueProperty = null;

    public BPolarity getPolarityConversion() {
        return (BPolarity)this.get(polarityConversion);
    }

    public void setPolarityConversion(BPolarity v) {
        this.set(polarityConversion, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || this.parentComponent == null) {
            return;
        }
        this.InitializeVariables();
        this.dynamicDefaultValueSlot();
        if (this.parentComponent.deviceIsReady) {
            this.setPointToReady();
        } else {
            this.waitingForDevice = true;
        }
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == polarityConversion) {
            this.doForceWrite();
            this.doPoll();
        }
        if (property == this.defaultValueProperty && this.parentComponent instanceof BIsmaRemoteDevice) {
            this.sendDefaultValueConf();
            this.doPoll();
        }
    }

    @Override
    public void sendConfigurations() {
        if (this.parentComponent instanceof BIsmaRemoteDevice) {
            this.sendDefaultValueConf();
        }
    }

    @Override
    Type getPointType() {
        return BBooleanWritable.TYPE;
    }

    private void dynamicDefaultValueSlot() {
        Slot slot = this.getSlot("DefaultValue");
        if (slot != null) {
            if (this.parentComponent instanceof BIsmaRemoteDevice) {
                this.defaultValueProperty = slot.asProperty();
            } else {
                this.remove(slot.asProperty());
            }
            return;
        }
        if (this.parentComponent instanceof BIsmaRemoteDevice) {
            this.defaultValueProperty = this.add("DefaultValue", (BValue)BBoolean.DEFAULT, 0, null);
            this.setDisplayName(this.defaultValueProperty, BFormat.make((String)"Default Value"), null);
        }
    }

    void sendDefaultValueConf() {
        try {
            this.parentComponent.addRequest(new ModbusWriteCoilsRequest(this, null, this.parentComponent.devAddr, DOConfReg.defaultStateStartReg.getValue() + this.getAddress() - 1, 1, this.booleanToIntArray(this.getBoolean(this.defaultValueProperty))));
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
        }
    }

    int[] booleanToIntArray(boolean val) {
        int[] values = new int[]{val ? 1 : 0};
        return values;
    }

    private void InitializeVariables() {
        if (this.parentComponent instanceof BIsmaRemoteDevice && !((BIsmaRemoteDevice)this.parentComponent).getWriteOnStart()) {
            this.oldValue = this.getInActiveLevel().getBoolean();
        }
    }

    @Override
    public void writeValue(boolean forcedWriting) {
        Boolean value;
        BStatusBoolean inSlotsActivLevel = this.getInActiveLevel();
        if (this.getEnabled() && !inSlotsActivLevel.getStatus().isNull() && this.isRunning() && this.parentComponent instanceof BIsmaCommonIoDevice && ((value = Boolean.valueOf(inSlotsActivLevel.getBoolean())) != this.oldValue || forcedWriting)) {
            this.oldValue = value;
            try {
                Method m = BDigitalOutputProxyExt.class.getMethod("callRead", ModbusMessage.class);
                this.parentComponent.addRequest(new ModbusWriteCoilsRequest(this, m, this.parentComponent.devAddr, DOConfReg.valRegStartReg.getValue() + this.getAddress() - 1, 1, this.booleanToIntArray(this.getPolarityConversion() == BPolarity.Default ? value : value == false)));
            }
            catch (Exception e) {
                log.severe(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public boolean setOutputValues(ModbusMessage mm) {
        boolean baseOutputValue;
        if (!super.setOutputValues(mm)) {
            return false;
        }
        boolean bl = baseOutputValue = mm.getRegisters()[0] > 0;
        this.temporaryStatusValueForOutputSlot = new BStatusBoolean(this.getPolarityConversion() == BPolarity.Default ? baseOutputValue : !baseOutputValue);
        this.myPoint.doExecute();
        return true;
    }

    @Override
    public ModbusMessage makeMpm() {
        try {
            Method m = BDigitalOutputProxyExt.class.getMethod("setOutputValues", ModbusMessage.class);
            return new ModbusReadRequest(this, m, this.parentComponent.devAddr, 1, DOConfReg.valRegStartReg.getValue() + this.getAddress() - 1, 1);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
            return null;
        }
    }

    BStatusBoolean getInActiveLevel() {
        try {
            for (int i = 1; i < 17; ++i) {
                Method getIn = ((BBooleanWritable)this.getParent().getParentComponent()).getClass().getMethod("getIn" + i, null);
                BStatusBoolean inVal = (BStatusBoolean)getIn.invoke((Object)this.getParent().getParentComponent(), null);
                if (inVal.getStatus().isNull()) continue;
                return inVal;
            }
        }
        catch (Exception e) {
            log.severe("Getting active level problem: " + e.getLocalizedMessage());
        }
        return ((BBooleanWritable)this.getParent().getParentComponent()).getFallback();
    }

    public void onExecute(BStatusValue out, Context cx) {
        BStatus stat;
        if (this.isPointReady) {
            this.writeValue(false);
        }
        if ((stat = out.getStatus()).isNull()) {
            stat = BStatus.ok;
        }
        if (this.temporaryStatusValueForOutputSlot == null) {
            this.setTemporaryStatusValueForOutputSlot((BStatusValue)new BStatusBoolean());
        }
        this.temporaryStatusValueForOutputSlot.copyFrom((BComplex)new BStatusBoolean(((BStatusBoolean)this.temporaryStatusValueForOutputSlot).getBoolean(), stat));
        if (!this.getStatus().equals((Object)BStatus.ok)) {
            this.temporaryStatusValueForOutputSlot.setStatus(this.getStatus());
            this.temporaryStatusValueForOutputSlot.setStatusNull(true);
        }
        out.copyFrom((BComplex)this.temporaryStatusValueForOutputSlot);
    }

    @Override
    public int getAddress() {
        return this.getOutputNumber();
    }

    @Override
    public int getMaxAddress() {
        if (this.parentComponent == null) {
            return -1;
        }
        return this.parentComponent.getDOQuantity();
    }

    @Override
    void setMyPointAddress() {
        int myNum = this.getFirstFreeNumber(1, this.parentComponent.getDOQuantity());
        this.setOutputNumber(myNum);
    }

    @Override
    public int getPointQuantity() {
        return this.parentComponent.getDOQuantity();
    }

    @Override
    boolean isIOPoint() {
        return true;
    }

    static enum DOConfReg {
        valRegStartReg(272),
        defaultStateStartReg(2272);

        private final int value;

        private DOConfReg(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

