/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.networks;

import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.networks.PollingThread;
import java.util.Arrays;

public class CircularBuffer {
    private final int size;
    private final ModbusMessage[] buffer;
    private int readIndex;
    private int writeIndex;
    private int counter = 0;

    CircularBuffer(int size) {
        this.size = size;
        this.buffer = new ModbusMessage[size];
    }

    public boolean available() {
        return this.readIndex != this.writeIndex;
    }

    public synchronized void put(ModbusMessage value) {
        this.buffer[this.writeIndex] = value;
        this.writeIndex = (this.writeIndex + 1) % this.size;
        if (++this.counter > this.size) {
            this.counter = 0;
            if (PollingThread.getLogger() != null) {
                PollingThread.getLogger().warning("Communication queue overflown due to too fast polling");
            }
        }
    }

    public ModbusMessage get() {
        if (this.available()) {
            ModbusMessage value = this.buffer[this.readIndex];
            this.readIndex = (this.readIndex + 1) % this.size;
            --this.counter;
            return value;
        }
        this.counter = 0;
        return null;
    }

    public synchronized void clear() {
        Arrays.fill(this.buffer, null);
        this.readIndex = 0;
        this.writeIndex = 0;
    }
}

