/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.networks;

import com.gc5.iSMA_IO.comm.TcpComm;
import com.gc5.iSMA_IO.devices.BIsmaRemoteDevice;
import com.gc5.iSMA_IO.enums.Utilities.Statuses;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import com.gc5.iSMA_IO.models.TcpCommunicationParametersModel;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import com.gc5.iSMA_IO.networks.INetworkListener;
import com.gc5.iSMA_IO.networks.PollingThread;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="pingDevices")
@NiagaraProperties(value={@NiagaraProperty(name="ipAddress", type="String", defaultValue="###.###.###.###"), @NiagaraProperty(name="port", type="int", defaultValue="502", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="65535")}), @NiagaraProperty(name="enabledConfig", type="boolean", defaultValue="true"), @NiagaraProperty(name="socketOptionTimeout", type="BRelTime", defaultValue="BRelTime.make(10000L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1000L)")}), @NiagaraProperty(name="connectTimeout", type="BRelTime", defaultValue="BRelTime.make(10000L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1000L)"), @Facet(name="BFacets.MAX", value="BRelTime.make(60000L)")}), @NiagaraProperty(name="pingFrequency", type="BRelTime", defaultValue="BRelTime.make(300000L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(minimumPingFrequencyValue)"), @Facet(name="BFacets.MAX", value="BRelTime.make(maximumPingFrequencyValue)")}), @NiagaraProperty(name="retryCount", type="int", defaultValue="2", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="10")})})
public class BIsmaRemoteIpNetwork
extends BIsmaNetwork {
    private static long minimumPingFrequencyValue = 1000L;
    private static long maximumPingFrequencyValue = 86400000L;
    public static final Property ipAddress = BIsmaRemoteIpNetwork.newProperty((int)0, (String)"###.###.###.###", null);
    public static final Property port = BIsmaRemoteIpNetwork.newProperty((int)0, (int)502, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)65535)));
    public static final Property enabledConfig = BIsmaRemoteIpNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property socketOptionTimeout = BIsmaRemoteIpNetwork.newProperty((int)0, (BValue)BRelTime.make((long)10000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    public static final Property connectTimeout = BIsmaRemoteIpNetwork.newProperty((int)0, (BValue)BRelTime.make((long)10000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)60000L))));
    public static final Property pingFrequency = BIsmaRemoteIpNetwork.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)minimumPingFrequencyValue)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)maximumPingFrequencyValue))));
    public static final Property retryCount = BIsmaRemoteIpNetwork.newProperty((int)0, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Action pingDevices = BIsmaRemoteIpNetwork.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BIsmaRemoteIpNetwork.class);
    private boolean couldNotOpenSocket = false;
    private PollingThread pollingThread;
    private TcpComm comm = null;
    protected boolean networkStarted = false;
    private static ArrayList<BIsmaRemoteIpNetwork> ismaRemoteIpNetworks = new ArrayList();
    protected final Logger log = Logger.getLogger("iSMA_IO::iSMARemoteIpNetwork");

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public boolean getEnabledConfig() {
        return this.getBoolean(enabledConfig);
    }

    public void setEnabledConfig(boolean v) {
        this.setBoolean(enabledConfig, v, null);
    }

    public BRelTime getSocketOptionTimeout() {
        return (BRelTime)this.get(socketOptionTimeout);
    }

    public void setSocketOptionTimeout(BRelTime v) {
        this.set(socketOptionTimeout, (BValue)v, null);
    }

    public BRelTime getConnectTimeout() {
        return (BRelTime)this.get(connectTimeout);
    }

    public void setConnectTimeout(BRelTime v) {
        this.set(connectTimeout, (BValue)v, null);
    }

    public BRelTime getPingFrequency() {
        return (BRelTime)this.get(pingFrequency);
    }

    public void setPingFrequency(BRelTime v) {
        this.set(pingFrequency, (BValue)v, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    public void pingDevices() {
        this.invoke(pingDevices, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.started();
        this.pollDevicesClock = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPingFrequency(), (Action)pingDevices, null);
        this.startTransmission();
        ismaRemoteIpNetworks.add(this);
        this.networkStarted = true;
    }

    private boolean checkDuplicatedIpAddress() {
        for (BIsmaRemoteIpNetwork remoteIpNetwork : ismaRemoteIpNetworks) {
            if (remoteIpNetwork.equals((Object)this) || !remoteIpNetwork.getStatus().isOk() || !remoteIpNetwork.getIpAddress().equals(this.getIpAddress())) continue;
            return true;
        }
        return false;
    }

    private boolean validateIpAddress() {
        try {
            InetAddress.getByName(this.getIpAddress());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void changed(Property property, Context context) {
        if (!(this.isRunning() && this.networkStarted && this.validHardware && property != faultCause)) {
            return;
        }
        if (property == enabled && !this.getEnabled()) {
            this.stopTransmission();
            this.updateNetworkStatus();
            this.notifyObservers(x -> x.networkUpdated(property));
            return;
        }
        if (property == pingFrequency && this.validatePingFrequencyValue()) {
            this.restartDevicesPingingClock();
        }
        if (property == enabled || property == ipAddress || property == port || property == socketOptionTimeout || property == connectTimeout || property == retryCount) {
            try {
                this.stopTransmission();
                if (!this.checkDuplicatedIpAddress() && this.validateIpAddress()) {
                    this.startTransmission();
                    this.restartDevicesPingingClock();
                }
            }
            catch (Exception ex) {
                this.stopTransmission();
                this.log.severe(ex.getLocalizedMessage());
            }
        }
        if (property != status) {
            this.updateNetworkStatus();
        }
        this.notifyObservers(x -> x.networkUpdated(property));
    }

    @Override
    public void stopped() throws Exception {
        this.stopTransmission();
        super.stopped();
        ismaRemoteIpNetworks.remove((Object)this);
    }

    private TcpCommunicationParametersModel getCommunicationParametersModel() {
        return new TcpCommunicationParametersModel(this.getIpAddress(), this.getPort(), (int)this.getSocketOptionTimeout().getMillis(), (int)this.getConnectTimeout().getMillis(), this);
    }

    private void startTransmission() {
        if (!this.getEnabled() || !this.validateIpAddress() || this.checkDuplicatedIpAddress()) {
            return;
        }
        try {
            if (this.pollingThread != null) {
                this.stopTransmission();
            }
            this.comm = new TcpComm(this.getCommunicationParametersModel());
            this.pollingThread = new PollingThread(this.comm, this.getRetryCount());
            this.pollingThread.start();
            if (!this.comm.open()) {
                throw new SocketException("Failed to open socket");
            }
            if (!this.sendInitialMessage()) {
                throw new Exception(this.getIpAddress() + ":" + this.getPort() + ": could not open socket");
            }
            this.couldNotOpenSocket = false;
        }
        catch (Exception ex) {
            if (this.comm != null) {
                this.comm.close();
            }
            this.makeMpmInitialMessage();
            this.couldNotOpenSocket = true;
            this.updateNetworkStatus();
        }
    }

    private void makeMpmInitialMessage() {
        Method m = null;
        try {
            m = BIsmaRemoteIpNetwork.class.getMethod("initialMessageParseResponse", ModbusMessage.class);
            ModbusReadRequest mrr = new ModbusReadRequest((Object)this, m, 1, 3, 0, 1);
            this.addRequest(mrr);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public boolean initialMessageParseResponse(ModbusMessage mm) {
        return mm.parseResponse();
    }

    private boolean sendInitialMessage() {
        try {
            byte[] openSocketPingMessage = new byte[]{1, 3, 0, 0, 0, 1};
            if (this.comm.write(openSocketPingMessage)) {
                this.comm.receive();
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected void stopTransmission() {
        if (this.pollingThread != null) {
            this.pollingThread.stopThread();
            this.pollingThread = null;
        }
    }

    @Override
    public void updateNetworkStatus() {
        this.networkStatus = !this.getEnabled() ? Statuses.DISABLED : (!this.validHardware ? Statuses.INVALID_HARDWARE : (!this.validateIpAddress() ? Statuses.INVALID_IP_ADDRESS : (this.checkDuplicatedIpAddress() ? Statuses.DUPLICATED_ADDRESS : (this.couldNotOpenSocket ? Statuses.COULD_NOT_OPEN_SOCKET : Statuses.OK))));
        this.setStatusAndFaultCauseSlots();
    }

    private boolean validatePingFrequencyValue() {
        BRelTime pingFrequency = this.getPingFrequency();
        return pingFrequency.getMillis() >= minimumPingFrequencyValue && pingFrequency.getMillis() <= maximumPingFrequencyValue;
    }

    private void restartDevicesPingingClock() {
        if (this.pollDevicesClock != null) {
            try {
                this.pollDevicesClock.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.doPingDevices();
        this.pollDevicesClock = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPingFrequency(), (Action)pingDevices, null);
    }

    public void doPingDevices() {
        for (INetworkListener listener : this.listeners) {
            ((BIsmaRemoteDevice)listener).pingDevice();
        }
    }

    @Override
    public void addListener(INetworkListener listener) {
        super.addListener(listener);
    }

    @Override
    public void removeListener(INetworkListener listener) {
        super.removeListener(listener);
    }

    @Override
    boolean checkDuplicatedNetwork() {
        return false;
    }

    @Override
    public void addRequest(ModbusMessage modbusMessage) {
        if (this.pollingThread != null) {
            this.pollingThread.addRequest(modbusMessage);
        }
    }

    @Override
    public void transmissionFailed(ModbusMessage mm) {
        try {
            this.log.info(this.getName() + ": trying to reopen socket and establish communication");
            this.restartCommunication();
            this.restartDevicesPingingClock();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void tryReopenSocket() throws Exception {
        int repeatTry;
        int defaultValue = 3;
        for (repeatTry = 0; !(repeatTry >= defaultValue || this.pollingThread.stopThread || this.comm != null && this.comm.open()); ++repeatTry) {
        }
        if (repeatTry >= defaultValue) {
            this.comm.close();
            throw new Exception("Could not properly reopen socket.");
        }
        if (!this.sendInitialMessage()) {
            this.comm.close();
            throw new Exception("Could not properly reopen socket.");
        }
    }

    public void restartCommunication() throws InterruptedException {
        this.comm.close();
        while (!this.pollingThread.stopThread && this.comm.isClosed()) {
            try {
                this.tryReopenSocket();
                this.couldNotOpenSocket = false;
                this.updateNetworkStatus();
            }
            catch (Exception ex) {
                this.log.warning(ex.getMessage());
                this.couldNotOpenSocket = true;
                this.updateNetworkStatus();
                if (this.pollingThread != null && this.pollingThread.getBuffer().available()) {
                    this.pollingThread.getBuffer().clear();
                }
                if (this.pollingThread.stopThread) continue;
                Thread.sleep(10000L);
            }
        }
    }
}

