/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.networks;

import com.gc5.iSMA_IO.enums.Utilities.Statuses;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.networks.BIsmaIoNetwork;
import com.gc5.iSMA_IO.networks.INetworkListener;
import com.tridium.platform.npsdk.BSystemPlatformServiceNpsdk;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", flags=65, defaultValue="BStatus.ok"), @NiagaraProperty(name="faultCause", type="String", flags=65, defaultValue=""), @NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="true")})
public abstract class BIsmaNetwork
extends BComponent
implements BIStatus {
    public static final Property status = BIsmaNetwork.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BIsmaNetwork.newProperty((int)65, (String)"", null);
    public static final Property enabled = BIsmaNetwork.newProperty((int)264, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BIsmaNetwork.class);
    protected final List<INetworkListener> listeners = new ArrayList<INetworkListener>();
    boolean validHardware;
    protected Clock.Ticket updateNetworkTicket;
    protected Clock.Ticket pollDevicesClock;
    protected Statuses networkStatus;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        this.validate();
    }

    public void stopped() throws Exception {
        BComponent[] mySibl;
        for (BComponent s : mySibl = this.getParent().getParentComponent().getChildComponents()) {
            if (!s.getType().is(BIsmaIoNetwork.TYPE) || s.getAbsoluteOrd().equals((Object)this.getAbsoluteOrd())) continue;
            ((BIsmaIoNetwork)s).updateNetworkStatus();
        }
    }

    public abstract void transmissionFailed(ModbusMessage var1);

    private void validate() {
        if (this.getAbsoluteOrd() != null) {
            this.validateHardware();
            this.updateNetworkStatus();
        }
    }

    protected void validateHardware() {
        BComponent platComp = BOrd.make((String)"station:|slot:/Services/PlatformServices/SystemService").resolve().get().asComponent();
        boolean bl = this.validHardware = platComp.getType().is(BSystemPlatformServiceNpsdk.TYPE) && (((BSystemPlatformServiceNpsdk)platComp).getModel().equals("ISMA-MAC-HARDWARE") || ((BSystemPlatformServiceNpsdk)platComp).getModel().equals("SD-PRO"));
        if (!this.validHardware) {
            this.networkStatus = Statuses.INVALID_HARDWARE;
            this.setStatusAndFaultCauseSlots();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning() || !this.validHardware) {
            return;
        }
        if (property == enabled) {
            this.updateNetworkStatus();
            this.notifyObservers(x -> x.networkUpdated(property));
        }
    }

    void updateNetworkStatus() {
        if (!this.validHardware) {
            return;
        }
        this.networkStatus = !this.getEnabled() ? Statuses.DISABLED : (this.checkDuplicatedNetwork() ? Statuses.DUPLICATED : Statuses.OK);
        this.setStatusAndFaultCauseSlots();
    }

    protected void setStatusAndFaultCauseSlots() {
        this.setStatus(this.networkStatus.getStatus());
        this.setFaultCause(this.networkStatus.getMessage());
    }

    public ArrayList<INetworkListener> getListeners() {
        return new ArrayList<INetworkListener>(this.listeners);
    }

    public void addListener(INetworkListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException(listener + " already added to the list of listeners.");
        }
        this.listeners.add(listener);
    }

    public void removeListener(INetworkListener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalArgumentException(listener + " not found in the list of listeners.");
        }
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Consumer<INetworkListener> func) {
        List<INetworkListener> list = this.listeners;
        synchronized (list) {
            Iterator<INetworkListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                INetworkListener obj = iterator.next();
                if (obj == null) {
                    iterator.remove();
                    continue;
                }
                func.accept(obj);
            }
        }
    }

    abstract boolean checkDuplicatedNetwork();

    public abstract void addRequest(ModbusMessage var1);
}

