/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.networks;

import com.gc5.iSMA_IO.comm.TcpComm;
import com.gc5.iSMA_IO.devices.BIsmaIoDevice;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import com.gc5.iSMA_IO.networks.INetworkListener;
import com.gc5.iSMA_IO.networks.PollingThread;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BIsmaIoNetwork
extends BIsmaNetwork {
    public static final Type TYPE = Sys.loadType(BIsmaIoNetwork.class);
    private static BOrd localIoExists = BOrd.NULL;
    private PollingThread pollingThread = null;
    private TcpComm comm = null;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.started();
        this.startTransmission();
    }

    @Override
    public void stopped() throws Exception {
        this.stopTransmission();
        if (localIoExists.equals((Object)this.getAbsoluteOrd())) {
            localIoExists = BOrd.NULL;
        }
    }

    @Override
    public void changed(Property property, Context cx) {
        super.changed(property, cx);
        if (property == enabled) {
            try {
                if (this.getEnabled()) {
                    this.startTransmission();
                } else {
                    this.stopTransmission();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void transmissionFailed(ModbusMessage mm) {
        this.comm.close();
        if (this.comm.open()) {
            this.doPingDevices();
        }
    }

    public void doPingDevices() {
        for (INetworkListener listener : this.listeners) {
            ((BIsmaIoDevice)listener).pingDevice();
        }
    }

    @Override
    public boolean checkDuplicatedNetwork() {
        if (!this.isMounted()) {
            return false;
        }
        if (localIoExists.equals((Object)BOrd.NULL)) {
            localIoExists = this.getAbsoluteOrd();
            return false;
        }
        return !localIoExists.equals((Object)this.getAbsoluteOrd());
    }

    @Override
    public void addRequest(ModbusMessage mm) {
        if (this.pollingThread != null) {
            this.pollingThread.addRequest(mm);
        }
    }

    private void startTransmission() throws Exception {
        if (!this.getStatus().isOk()) {
            return;
        }
        this.stopTransmission();
        this.comm = new TcpComm(this);
        this.comm.open();
        this.pollingThread = new PollingThread(this.comm);
        this.pollingThread.start();
        this.notifyObservers(x -> {
            if (x instanceof BIsmaIoDevice) {
                ((BIsmaIoDevice)x).networkStarted();
            }
        });
    }

    private void stopTransmission() {
        if (this.pollingThread != null) {
            this.pollingThread.stopThread();
        }
        if (this.comm != null) {
            this.comm.close();
        }
    }
}

