/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.messages;

import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusOutputStream;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;

public class ModbusWriteRequest
extends ModbusMessage {
    int[] registers;
    ModbusMessage.responseStatus responseError = ModbusMessage.responseStatus.Ok;

    public ModbusWriteRequest(Object object, Method method, int devAddr, int functionCode, int start, int count, int[] valuesToWrite) {
        this.deviceAddress = devAddr;
        this.functionCode = functionCode;
        this.startAddress = start;
        this.numberPoints = count;
        this.registers = valuesToWrite;
        this.object = object;
        this.method = method;
    }

    @Override
    public byte[] getFrame() {
        ModbusOutputStream modOut = new ModbusOutputStream();
        modOut.write((byte)this.deviceAddress);
        modOut.write((byte)this.functionCode);
        modOut.write((byte)((this.startAddress & 0xFF00) >> 8));
        modOut.write((byte)(this.startAddress & 0xFF));
        if (this.functionCode == 16) {
            modOut.write((byte)((this.numberPoints & 0xFF00) >> 8));
            modOut.write((byte)(this.numberPoints & 0xFF));
            modOut.write((byte)(this.numberPoints * 2));
        }
        for (int i = 0; i < this.numberPoints; ++i) {
            modOut.write((byte)((this.registers[i] & 0xFF00) >> 8));
            modOut.write((byte)(this.registers[i] & 0xFF));
        }
        return modOut.toByteArray();
    }

    @Override
    public int getExpectedBytes() {
        return 5 + this.numberPoints * 2;
    }

    @Override
    public boolean parseResponse() {
        int lo;
        if (this.response == null) {
            this.responseError = ModbusMessage.responseStatus.NoResponse;
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(this.response);
        if (is.read() != this.deviceAddress) {
            this.responseError = ModbusMessage.responseStatus.InvalidAddress;
            return false;
        }
        if (is.read() != this.functionCode) {
            this.responseError = ModbusMessage.responseStatus.InvalidFunction;
            return false;
        }
        int hi = is.read();
        int startingAdr = (hi << 8) + (lo = is.read());
        if (startingAdr != this.startAddress) {
            this.responseError = ModbusMessage.responseStatus.InvalidStartAddress;
            return false;
        }
        this.registers = new int[this.numberPoints];
        for (int i = 0; i < this.numberPoints; ++i) {
            hi = is.read();
            lo = is.read();
            this.registers[i] = (hi << 8) + lo;
        }
        return true;
    }

    @Override
    public ModbusMessage.responseStatus getResponseError() {
        return this.responseError;
    }

    @Override
    public int getRegister(int i) {
        return this.registers[i];
    }
}

