/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.messages;

import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusOutputStream;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;

public class ModbusWriteCoilsRequest
extends ModbusMessage {
    ModbusMessage.responseStatus responseError = ModbusMessage.responseStatus.Ok;
    int numberBytes;

    public ModbusWriteCoilsRequest(Object object, Method method, int devAddr, int start, int count, int[] registers) {
        this.deviceAddress = devAddr;
        this.functionCode = 15;
        this.startAddress = start;
        this.numberPoints = count;
        this.numberBytes = this.calculateBytes(this.numberPoints);
        this.values = new int[this.numberBytes % 2 == 1 ? this.numberBytes / 2 + 1 : this.numberBytes / 2];
        if (this.numberBytes > 0) {
            System.arraycopy(registers, 0, this.values, 0, this.values.length);
        }
        this.object = object;
        this.method = method;
    }

    @Override
    public byte[] getFrame() {
        this.numberBytes = this.calculateBytes(this.numberPoints);
        ModbusOutputStream modOut = new ModbusOutputStream();
        modOut.write((byte)this.deviceAddress);
        modOut.write((byte)this.functionCode);
        modOut.write((byte)((this.startAddress & 0xFF00) >> 8));
        modOut.write((byte)(this.startAddress & 0xFF));
        modOut.write((byte)((this.numberPoints & 0xFF00) >> 8));
        modOut.write((byte)(this.numberPoints & 0xFF));
        modOut.write((byte)this.numberBytes);
        for (int i = 0; i < this.values.length; ++i) {
            modOut.write((byte)(this.values[i] & 0xFF));
            modOut.write((byte)((this.values[i] & 0xFF00) >> 8));
        }
        return modOut.toByteArray();
    }

    @Override
    public int getExpectedBytes() {
        return 8;
    }

    @Override
    public boolean parseResponse() {
        int lo;
        if (this.response == null) {
            this.responseError = ModbusMessage.responseStatus.NoResponse;
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(this.response);
        if (is.read() != this.deviceAddress) {
            this.responseError = ModbusMessage.responseStatus.InvalidAddress;
            return false;
        }
        if (is.read() != this.functionCode) {
            this.responseError = ModbusMessage.responseStatus.InvalidFunction;
            return false;
        }
        int hi = is.read();
        int startingAdr = (hi << 8) + (lo = is.read());
        if (startingAdr != this.startAddress) {
            this.responseError = ModbusMessage.responseStatus.InvalidStartAddress;
            return false;
        }
        hi = is.read();
        int realNumberPoints = (hi << 8) + (lo = is.read());
        if (realNumberPoints != this.numberPoints) {
            this.responseError = ModbusMessage.responseStatus.InvalidOutputsQty;
            return false;
        }
        return true;
    }

    @Override
    public ModbusMessage.responseStatus getResponseError() {
        return this.responseError;
    }
}

