/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.messages;

import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.messages.ModbusOutputStream;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import javax.baja.nre.util.ByteArrayUtil;

public class ModbusReadRequest
extends ModbusMessage {
    int[] registers;
    ModbusMessage.responseStatus responseError = ModbusMessage.responseStatus.Ok;

    public ModbusReadRequest(Object object, Method method, int devAddr, int functionCode, int start, int count) {
        this.deviceAddress = devAddr;
        this.functionCode = functionCode;
        this.startAddress = start;
        this.numberPoints = count;
        this.object = object;
        this.method = method;
    }

    @Override
    public byte[] getFrame() {
        ModbusOutputStream modOut = new ModbusOutputStream();
        modOut.write((byte)this.deviceAddress);
        modOut.write((byte)this.functionCode);
        modOut.write((byte)((this.startAddress & 0xFF00) >> 8));
        modOut.write((byte)(this.startAddress & 0xFF));
        modOut.write((byte)((this.numberPoints & 0xFF00) >> 8));
        modOut.write((byte)(this.numberPoints & 0xFF));
        return modOut.toByteArray();
    }

    @Override
    public int getExpectedBytes() {
        return 5 + this.numberPoints * 2;
    }

    @Override
    public boolean parseResponse() {
        log.fine("response: " + ByteArrayUtil.toHexString((byte[])this.response));
        if (this.response == null) {
            this.responseError = ModbusMessage.responseStatus.NoResponse;
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(this.response);
        if (is.read() != this.deviceAddress) {
            this.responseError = ModbusMessage.responseStatus.InvalidAddress;
            return false;
        }
        if (is.read() != this.functionCode) {
            this.responseError = ModbusMessage.responseStatus.InvalidFunction;
            return false;
        }
        switch (this.functionCode) {
            case 1: 
            case 2: {
                if (is.read() != this.calculateBytes(this.numberPoints)) {
                    this.responseError = ModbusMessage.responseStatus.MessageIncomplete;
                    return false;
                }
                int bytesQty = this.calculateBytes(this.numberPoints);
                int registersQty = bytesQty % 2 == 1 ? bytesQty / 2 + 1 : bytesQty / 2;
                this.registers = new int[registersQty];
                for (int i = 0; i < registersQty; ++i) {
                    int lo = is.read();
                    int hi = i < bytesQty / 2 ? is.read() : 0;
                    this.registers[i] = (hi << 8) + lo;
                }
                break;
            }
            case 3: 
            case 4: {
                if (is.read() != this.numberPoints * 2) {
                    this.responseError = ModbusMessage.responseStatus.MessageIncomplete;
                    return false;
                }
                this.registers = new int[this.numberPoints];
                for (int i = 0; i < this.numberPoints; ++i) {
                    int hi = is.read();
                    int lo = is.read();
                    this.registers[i] = (hi << 8) + lo;
                }
                break;
            }
        }
        return true;
    }

    @Override
    public ModbusMessage.responseStatus getResponseError() {
        return this.responseError;
    }

    @Override
    public int getRegister(int i) {
        return this.registers[i];
    }

    @Override
    public int[] getRegisters() {
        return this.registers;
    }
}

