/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.messages;

import com.gc5.iSMA_IO.messages.IIsmaIoComponent;
import com.gc5.iSMA_IO.messages.ModbusReadRequest;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class ModbusMessage {
    protected int deviceAddress = -1;
    protected int functionCode;
    protected int startAddress;
    protected int numberPoints;
    protected int[] values;
    protected IIsmaIoComponent component;
    protected byte[] response;
    protected Object object;
    protected Method method;
    private boolean isPing = false;
    private boolean isForceRequest = false;
    protected static final Logger log = Logger.getLogger("iSMA_IO::Message");

    public void prepareResponseArray(byte[] res) {
        this.response = res;
    }

    public boolean setOutput() {
        if (this.method == null) {
            return true;
        }
        try {
            return (Boolean)this.method.invoke(this.object, this);
        }
        catch (Exception e) {
            log.severe(e.getLocalizedMessage());
            return false;
        }
    }

    public final Object getObject() {
        return this.object;
    }

    protected int calculateBytes(int pointsNumber) {
        int ret = pointsNumber % 8 <= 0 ? pointsNumber / 8 : pointsNumber / 8 + 1;
        return ret;
    }

    public void setAsPingRequest() {
        if (this instanceof ModbusReadRequest) {
            this.isPing = true;
            return;
        }
        throw new UnsupportedOperationException("Ping only supported by ReadRequest");
    }

    public boolean isPingRequest() {
        return this.isPing;
    }

    public void setAsForceRequest() {
        this.isForceRequest = true;
    }

    public boolean isForceRequest() {
        return this.isForceRequest;
    }

    public abstract byte[] getFrame();

    public abstract int getExpectedBytes();

    public abstract boolean parseResponse();

    public abstract responseStatus getResponseError();

    public int getRegister(int i) {
        return 0;
    }

    public int[] getRegisters() {
        return null;
    }

    public static enum responseStatus {
        Ok,
        InvalidCRC,
        InvalidAddress,
        InvalidFunction,
        MessageIncomplete,
        NoResponse,
        InvalidStartAddress,
        InvalidOutputsQty;

    }
}

