/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.enums;

import com.gc5.iSMA_IO.points.BUniversalInputProxyExt;
import java.util.ArrayList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BCustomTable
extends BComponent {
    public static final Type TYPE = Sys.loadType(BCustomTable.class);
    private static final ArrayList<BComponent> listOfParentsWithCustomTableInstance = new ArrayList();
    BComponent parentComponentHandler;
    private boolean started = false;
    double factorA = 1.0;
    double factorB = 0.0;
    int slotsQty;
    int activeRowsQty = this.slotsQty = 32;
    Property[] customTableSlotsX = new Property[this.slotsQty];
    Property[] customTableSlotsY = new Property[this.slotsQty];

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent component) {
        this.parentComponentHandler = component;
        return !listOfParentsWithCustomTableInstance.contains(this.parentComponentHandler) && component instanceof BUniversalInputProxyExt;
    }

    public void changed(Property property, Context context) {
        this.activeRowsQty = this.determineActiveRows();
    }

    public void started() {
        if (listOfParentsWithCustomTableInstance.contains(this.parentComponentHandler)) {
            this.remove((BComplex)this);
        }
        for (int i = 0; i < this.slotsQty; ++i) {
            this.customTableSlotsX[i] = this.getProperty("ctX" + i);
            if (this.customTableSlotsX[i] == null) {
                this.customTableSlotsX[i] = this.add("ctX" + i, (BValue)BDouble.NaN, 0, null);
            }
            this.customTableSlotsY[i] = this.getProperty("ctY" + i);
            if (this.customTableSlotsY[i] != null) continue;
            this.customTableSlotsY[i] = this.add("ctY" + i, (BValue)BDouble.NaN, 0, null);
        }
        this.activeRowsQty = this.determineActiveRows();
        listOfParentsWithCustomTableInstance.add(this.parentComponentHandler);
        this.started = true;
    }

    public void stopped() {
        if (listOfParentsWithCustomTableInstance.contains(this.parentComponentHandler)) {
            listOfParentsWithCustomTableInstance.remove(this.parentComponentHandler);
        }
    }

    int determineActiveRows() {
        for (Property p : this.getPropertiesArray()) {
            if (!p.getName().startsWith("ct") || !((BDouble)this.get(p)).equals((Object)BDouble.NaN)) continue;
            return Integer.parseInt(p.getName().substring(3));
        }
        return this.slotsQty;
    }

    public void calculate(Double in) {
        if (!this.started) {
            return;
        }
        for (int j = 1; j < this.activeRowsQty; ++j) {
            double firstX = ((BDouble)this.get(this.customTableSlotsX[j - 1])).getDouble();
            double secondX = ((BDouble)this.get(this.customTableSlotsX[j])).getDouble();
            if (!(firstX <= in && in <= secondX) && (!(firstX >= in) || !(in >= secondX))) continue;
            double firstY = ((BDouble)this.get(this.customTableSlotsY[j - 1])).getDouble();
            double secondY = ((BDouble)this.get(this.customTableSlotsY[j])).getDouble();
            this.factorA = (secondY - firstY) / (secondX - firstX);
            this.factorB = firstY - this.factorA * firstX;
            return;
        }
        if (this.activeRowsQty <= 1) {
            this.factorA = 1.0;
            this.factorB = 0.0;
        }
    }

    public double getFactorA() {
        return this.factorA;
    }

    public double getFactorB() {
        return this.factorB;
    }
}

