/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.devices;

import com.gc5.iSMA_IO.devices.DeviceCapabilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeviceTypes {
    public static final String DEVICE_UNKNOWN = "Unknown";
    private static final Map<Integer, DeviceCapabilities> deviceTypes;

    public static String getDeviceType(Integer intType) {
        if (!deviceTypes.containsKey(intType)) {
            return null;
        }
        return DeviceTypes.deviceTypes.get((Object)intType).Name;
    }

    static DeviceCapabilities getDeviceCapabilities(Integer intType) {
        DeviceCapabilities dc = deviceTypes.get(intType);
        if (dc == null) {
            dc = new DeviceCapabilities(DEVICE_UNKNOWN, 0, 0, 0, 0);
        }
        return dc;
    }

    public static boolean hasIO(String deviceType) {
        try {
            DeviceCapabilities deviceC = deviceTypes.values().stream().filter(x -> x.Name.equalsIgnoreCase(deviceType)).findFirst().get();
            return deviceC.AOQuantity != 0 || deviceC.DIQuantity != 0 || deviceC.DOQuantity != 0 || deviceC.UIQuantity != 0;
        }
        catch (Exception ex) {
            return true;
        }
    }

    static {
        HashMap<Integer, DeviceCapabilities> aMap = new HashMap<Integer, DeviceCapabilities>();
        aMap.put(50, new DeviceCapabilities("iSMA-B-MIX18 (5 DI, 5 UI, 4 DO, 4 AO)", 5, 5, 4, 4));
        aMap.put(51, new DeviceCapabilities("iSMA-B-MIX38 (12 DI, 8 UI, 12 DO, 6 AO)", 12, 8, 12, 6));
        aMap.put(52, new DeviceCapabilities("iSMA-B-MIX18-IP (5 DI, 5 UI, 4 DO, 4 AO)", 5, 5, 4, 4));
        aMap.put(53, new DeviceCapabilities("iSMA-B-MIX38-IP (12 DI, 8 UI, 12 DO, 6 AO)", 12, 8, 12, 6));
        aMap.put(54, new DeviceCapabilities("iSMA-B-MAC36 (4 DI, 16 UI, 8 DO, 8 AO)", 4, 16, 8, 8));
        aMap.put(59, new DeviceCapabilities("iSMA-B-MG-IP", 0, 0, 0, 0));
        aMap.put(80, new DeviceCapabilities("iSMA-B-W0202 (0 DI, 2 UI, 2 DO, 0 AO)", 0, 2, 2, 0));
        aMap.put(81, new DeviceCapabilities("iSMA-B-8I (8 DI, 0 UI, 0 DO, 0 AO)", 8, 0, 0, 0));
        aMap.put(82, new DeviceCapabilities("iSMA-B-4O-H (0 DI, 0 UI, 4 DO, 0 AO)", 0, 0, 4, 0));
        aMap.put(83, new DeviceCapabilities("iSMA-B-4I4O-H (4 DI, 0 UI, 4 DO, 0 AO)", 4, 0, 4, 0));
        aMap.put(84, new DeviceCapabilities("iSMA-B-8U (0 DI, 8 UI, 0 DO, 0 AO)", 0, 8, 0, 0));
        aMap.put(85, new DeviceCapabilities("iSMA-B-4U4O-H (0 DI, 4 UI, 4 DO, 0 AO)", 0, 4, 4, 0));
        aMap.put(86, new DeviceCapabilities("iSMA-B-4U4A-H (0 DI, 4 UI, 0 DO, 4 AO)", 0, 4, 0, 4));
        aMap.put(87, new DeviceCapabilities("iSMA-B-4TO-H (0 DI, 0 UI, 4 DO | 4 AO)", 0, 0, 4, 4));
        aMap.put(91, new DeviceCapabilities("iSMA-B-8I-IP (8 DI, 0 UI, 0 DO, 0 AO)", 8, 0, 0, 0));
        aMap.put(92, new DeviceCapabilities("iSMA-B-4O-H-IP (0 DI, 0 UI, 4 DO, 0 AO)", 0, 0, 4, 0));
        aMap.put(93, new DeviceCapabilities("iSMA-B-4I4O-H-IP (4 DI, 0 UI, 4 DO, 0 AO)", 4, 0, 4, 0));
        aMap.put(94, new DeviceCapabilities("iSMA-B-8U-IP (0 DI, 8 UI, 0 DO, 0 AO)", 0, 8, 0, 0));
        aMap.put(95, new DeviceCapabilities("iSMA-B-4U4O-H-IP (0 DI, 4 UI, 4 DO, 0 AO)", 0, 4, 4, 0));
        aMap.put(96, new DeviceCapabilities("iSMA-B-4U4A-H-IP (0 DI, 4 UI, 0 DO, 4 AO)", 0, 4, 0, 4));
        aMap.put(97, new DeviceCapabilities("iSMA-B-4TO-H-IP (0 DI, 0 UI, 4 DO | 4 AO)", 0, 0, 4, 4));
        aMap.put(100, new DeviceCapabilities("iSMA-B-AAC20", 0, 0, 0, 0));
        aMap.put(101, new DeviceCapabilities("iSMA-B-AAC20-LCD", 0, 0, 0, 0));
        aMap.put(110, new DeviceCapabilities("iSMA-B-FCU", 0, 0, 0, 0));
        aMap.put(111, new DeviceCapabilities("iSMA-B-LP", 0, 0, 0, 0));
        aMap.put(112, new DeviceCapabilities("Touch Point", 0, 0, 0, 0));
        aMap.put(114, new DeviceCapabilities("iSMA-B-2D1B", 0, 0, 0, 0));
        aMap.put(115, new DeviceCapabilities("iSMA-B-2D", 0, 0, 0, 0));
        deviceTypes = Collections.unmodifiableMap(aMap);
    }
}

